// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutBucketLoggingRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket for which to set the logging parameters.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * Container for logging status information.
     */
    public val bucketLoggingStatus: aws.sdk.kotlin.services.s3.model.BucketLoggingStatus? = builder.bucketLoggingStatus
    /**
     * Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding `x-amz-checksum` or `x-amz-trailer` header sent. Otherwise, Amazon S3 fails the request with the HTTP status code `400 Bad Request`. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     *
     * If you provide an individual checksum, Amazon S3 ignores any provided `ChecksumAlgorithm` parameter.
     */
    public val checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     * The MD5 hash of the `PutBucketLogging` request body.
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     */
    public val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBucketLoggingRequest(")
        append("bucket=$bucket,")
        append("bucketLoggingStatus=$bucketLoggingStatus,")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (bucketLoggingStatus?.hashCode() ?: 0)
        result = 31 * result + (checksumAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBucketLoggingRequest

        if (bucket != other.bucket) return false
        if (bucketLoggingStatus != other.bucketLoggingStatus) return false
        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the bucket for which to set the logging parameters.
         */
        public var bucket: kotlin.String? = null
        /**
         * Container for logging status information.
         */
        public var bucketLoggingStatus: aws.sdk.kotlin.services.s3.model.BucketLoggingStatus? = null
        /**
         * Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding `x-amz-checksum` or `x-amz-trailer` header sent. Otherwise, Amazon S3 fails the request with the HTTP status code `400 Bad Request`. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         *
         * If you provide an individual checksum, Amazon S3 ignores any provided `ChecksumAlgorithm` parameter.
         */
        public var checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = null
        /**
         * The MD5 hash of the `PutBucketLogging` request body.
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         */
        public var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest) : this() {
            this.bucket = x.bucket
            this.bucketLoggingStatus = x.bucketLoggingStatus
            this.checksumAlgorithm = x.checksumAlgorithm
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest = PutBucketLoggingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.BucketLoggingStatus] inside the given [block]
         */
        public fun bucketLoggingStatus(block: aws.sdk.kotlin.services.s3.model.BucketLoggingStatus.Builder.() -> kotlin.Unit) {
            this.bucketLoggingStatus = aws.sdk.kotlin.services.s3.model.BucketLoggingStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
