// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutBucketEncryptionRequest private constructor(builder: Builder) {
    /**
     * Specifies default encryption for a bucket using server-side encryption with different key options.
     *
     * **Directory buckets ** - When you use this operation with a directory bucket, you must use path-style requests in the format `https://s3express-control.<i>region-code</i>.amazonaws.com/<i>bucket-name</i> `. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must also follow the format ` <i>bucket-base-name</i>--<i>zone-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding `x-amz-checksum` or `x-amz-trailer` header sent. Otherwise, Amazon S3 fails the request with the HTTP status code `400 Bad Request`. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     *
     * If you provide an individual checksum, Amazon S3 ignores any provided `ChecksumAlgorithm` parameter.
     *
     * For directory buckets, when you use Amazon Web Services SDKs, `CRC32` is the default checksum algorithm that's used for performance.
     */
    public val checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     * The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     *
     * This functionality is not supported for directory buckets.
     */
    public val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     *
     * For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code `501 Not Implemented`.
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * Specifies the default server-side-encryption configuration.
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutBucketEncryptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBucketEncryptionRequest(")
        append("bucket=$bucket,")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (checksumAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBucketEncryptionRequest

        if (bucket != other.bucket) return false
        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutBucketEncryptionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies default encryption for a bucket using server-side encryption with different key options.
         *
         * **Directory buckets ** - When you use this operation with a directory bucket, you must use path-style requests in the format `https://s3express-control.<i>region-code</i>.amazonaws.com/<i>bucket-name</i> `. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must also follow the format ` <i>bucket-base-name</i>--<i>zone-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*
         */
        public var bucket: kotlin.String? = null
        /**
         * Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding `x-amz-checksum` or `x-amz-trailer` header sent. Otherwise, Amazon S3 fails the request with the HTTP status code `400 Bad Request`. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         *
         * If you provide an individual checksum, Amazon S3 ignores any provided `ChecksumAlgorithm` parameter.
         *
         * For directory buckets, when you use Amazon Web Services SDKs, `CRC32` is the default checksum algorithm that's used for performance.
         */
        public var checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = null
        /**
         * The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         *
         * This functionality is not supported for directory buckets.
         */
        public var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         *
         * For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code `501 Not Implemented`.
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * Specifies the default server-side-encryption configuration.
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutBucketEncryptionRequest) : this() {
            this.bucket = x.bucket
            this.checksumAlgorithm = x.checksumAlgorithm
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutBucketEncryptionRequest = PutBucketEncryptionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.s3.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
