// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Object Identifier is unique value to identify objects.
 */
public class ObjectIdentifier private constructor(builder: Builder) {
    /**
     * An entity tag (ETag) is an identifier assigned by a web server to a specific version of a resource found at a URL. This header field makes the request method conditional on `ETags`.
     *
     * Entity tags (ETags) for S3 Express One Zone are random alphanumeric strings unique to the object.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * Key name of the object.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * If present, the objects are deleted only if its modification times matches the provided `Timestamp`.
     *
     * This functionality is only supported for directory buckets.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * If present, the objects are deleted only if its size matches the provided size in bytes.
     *
     * This functionality is only supported for directory buckets.
     */
    public val size: kotlin.Long? = builder.size
    /**
     * Version ID for the specific version of the object to delete.
     *
     * This functionality is not supported for directory buckets.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ObjectIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectIdentifier(")
        append("eTag=$eTag,")
        append("key=$key,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("size=$size,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eTag?.hashCode() ?: 0
        result = 31 * result + (key.hashCode())
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (size?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObjectIdentifier

        if (eTag != other.eTag) return false
        if (key != other.key) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (size != other.size) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ObjectIdentifier = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An entity tag (ETag) is an identifier assigned by a web server to a specific version of a resource found at a URL. This header field makes the request method conditional on `ETags`.
         *
         * Entity tags (ETags) for S3 Express One Zone are random alphanumeric strings unique to the object.
         */
        public var eTag: kotlin.String? = null
        /**
         * Key name of the object.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        public var key: kotlin.String? = null
        /**
         * If present, the objects are deleted only if its modification times matches the provided `Timestamp`.
         *
         * This functionality is only supported for directory buckets.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If present, the objects are deleted only if its size matches the provided size in bytes.
         *
         * This functionality is only supported for directory buckets.
         */
        public var size: kotlin.Long? = null
        /**
         * Version ID for the specific version of the object to delete.
         *
         * This functionality is not supported for directory buckets.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ObjectIdentifier) : this() {
            this.eTag = x.eTag
            this.key = x.key
            this.lastModifiedTime = x.lastModifiedTime
            this.size = x.size
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ObjectIdentifier = ObjectIdentifier(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            return this
        }
    }
}
