// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListObjectVersionsResponse private constructor(builder: Builder) {
    /**
     * All of the keys rolled up into a common prefix count as a single return when calculating the number of returns.
     */
    public val commonPrefixes: List<CommonPrefix>? = builder.commonPrefixes
    /**
     * Container for an object that is a delete marker.
     */
    public val deleteMarkers: List<DeleteMarkerEntry>? = builder.deleteMarkers
    /**
     * The delimiter grouping the included keys. A delimiter is a character that you specify to group keys. All keys that contain the same string between the prefix and the first occurrence of the delimiter are grouped under a single result element in `CommonPrefixes`. These groups are counted as one result against the `max-keys` limitation. These keys are not returned elsewhere in the response.
     */
    public val delimiter: kotlin.String? = builder.delimiter
    /**
     * Encoding type used by Amazon S3 to encode object key names in the XML response.
     *
     * If you specify the `encoding-type` request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:
     *
     * `KeyMarker, NextKeyMarker, Prefix, Key`, and `Delimiter`.
     */
    public val encodingType: aws.sdk.kotlin.services.s3.model.EncodingType? = builder.encodingType
    /**
     * A flag that indicates whether Amazon S3 returned all of the results that satisfied the search criteria. If your results were truncated, you can make a follow-up paginated request by using the `NextKeyMarker` and `NextVersionIdMarker` response parameters as a starting place in another request to return the rest of the results.
     */
    public val isTruncated: kotlin.Boolean? = builder.isTruncated
    /**
     * Marks the last key returned in a truncated response.
     */
    public val keyMarker: kotlin.String? = builder.keyMarker
    /**
     * Specifies the maximum number of objects to return.
     */
    public val maxKeys: kotlin.Int? = builder.maxKeys
    /**
     * The bucket name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * When the number of responses exceeds the value of `MaxKeys`, `NextKeyMarker` specifies the first key not returned that satisfies the search criteria. Use this value for the key-marker request parameter in a subsequent request.
     */
    public val nextKeyMarker: kotlin.String? = builder.nextKeyMarker
    /**
     * When the number of responses exceeds the value of `MaxKeys`, `NextVersionIdMarker` specifies the first object version not returned that satisfies the search criteria. Use this value for the `version-id-marker` request parameter in a subsequent request.
     */
    public val nextVersionIdMarker: kotlin.String? = builder.nextVersionIdMarker
    /**
     * Selects objects that start with the value supplied by this parameter.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * If present, indicates that the requester was successfully charged for the request.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = builder.requestCharged
    /**
     * Marks the last version of the key returned in a truncated response.
     */
    public val versionIdMarker: kotlin.String? = builder.versionIdMarker
    /**
     * Container for version information.
     */
    public val versions: List<ObjectVersion>? = builder.versions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ListObjectVersionsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListObjectVersionsResponse(")
        append("commonPrefixes=$commonPrefixes,")
        append("deleteMarkers=$deleteMarkers,")
        append("delimiter=$delimiter,")
        append("encodingType=$encodingType,")
        append("isTruncated=$isTruncated,")
        append("keyMarker=$keyMarker,")
        append("maxKeys=$maxKeys,")
        append("name=$name,")
        append("nextKeyMarker=$nextKeyMarker,")
        append("nextVersionIdMarker=$nextVersionIdMarker,")
        append("prefix=$prefix,")
        append("requestCharged=$requestCharged,")
        append("versionIdMarker=$versionIdMarker,")
        append("versions=$versions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = commonPrefixes?.hashCode() ?: 0
        result = 31 * result + (deleteMarkers?.hashCode() ?: 0)
        result = 31 * result + (delimiter?.hashCode() ?: 0)
        result = 31 * result + (encodingType?.hashCode() ?: 0)
        result = 31 * result + (isTruncated?.hashCode() ?: 0)
        result = 31 * result + (keyMarker?.hashCode() ?: 0)
        result = 31 * result + (maxKeys ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextKeyMarker?.hashCode() ?: 0)
        result = 31 * result + (nextVersionIdMarker?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (requestCharged?.hashCode() ?: 0)
        result = 31 * result + (versionIdMarker?.hashCode() ?: 0)
        result = 31 * result + (versions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListObjectVersionsResponse

        if (commonPrefixes != other.commonPrefixes) return false
        if (deleteMarkers != other.deleteMarkers) return false
        if (delimiter != other.delimiter) return false
        if (encodingType != other.encodingType) return false
        if (isTruncated != other.isTruncated) return false
        if (keyMarker != other.keyMarker) return false
        if (maxKeys != other.maxKeys) return false
        if (name != other.name) return false
        if (nextKeyMarker != other.nextKeyMarker) return false
        if (nextVersionIdMarker != other.nextVersionIdMarker) return false
        if (prefix != other.prefix) return false
        if (requestCharged != other.requestCharged) return false
        if (versionIdMarker != other.versionIdMarker) return false
        if (versions != other.versions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ListObjectVersionsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * All of the keys rolled up into a common prefix count as a single return when calculating the number of returns.
         */
        public var commonPrefixes: List<CommonPrefix>? = null
        /**
         * Container for an object that is a delete marker.
         */
        public var deleteMarkers: List<DeleteMarkerEntry>? = null
        /**
         * The delimiter grouping the included keys. A delimiter is a character that you specify to group keys. All keys that contain the same string between the prefix and the first occurrence of the delimiter are grouped under a single result element in `CommonPrefixes`. These groups are counted as one result against the `max-keys` limitation. These keys are not returned elsewhere in the response.
         */
        public var delimiter: kotlin.String? = null
        /**
         * Encoding type used by Amazon S3 to encode object key names in the XML response.
         *
         * If you specify the `encoding-type` request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:
         *
         * `KeyMarker, NextKeyMarker, Prefix, Key`, and `Delimiter`.
         */
        public var encodingType: aws.sdk.kotlin.services.s3.model.EncodingType? = null
        /**
         * A flag that indicates whether Amazon S3 returned all of the results that satisfied the search criteria. If your results were truncated, you can make a follow-up paginated request by using the `NextKeyMarker` and `NextVersionIdMarker` response parameters as a starting place in another request to return the rest of the results.
         */
        public var isTruncated: kotlin.Boolean? = null
        /**
         * Marks the last key returned in a truncated response.
         */
        public var keyMarker: kotlin.String? = null
        /**
         * Specifies the maximum number of objects to return.
         */
        public var maxKeys: kotlin.Int? = null
        /**
         * The bucket name.
         */
        public var name: kotlin.String? = null
        /**
         * When the number of responses exceeds the value of `MaxKeys`, `NextKeyMarker` specifies the first key not returned that satisfies the search criteria. Use this value for the key-marker request parameter in a subsequent request.
         */
        public var nextKeyMarker: kotlin.String? = null
        /**
         * When the number of responses exceeds the value of `MaxKeys`, `NextVersionIdMarker` specifies the first object version not returned that satisfies the search criteria. Use this value for the `version-id-marker` request parameter in a subsequent request.
         */
        public var nextVersionIdMarker: kotlin.String? = null
        /**
         * Selects objects that start with the value supplied by this parameter.
         */
        public var prefix: kotlin.String? = null
        /**
         * If present, indicates that the requester was successfully charged for the request.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = null
        /**
         * Marks the last version of the key returned in a truncated response.
         */
        public var versionIdMarker: kotlin.String? = null
        /**
         * Container for version information.
         */
        public var versions: List<ObjectVersion>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ListObjectVersionsResponse) : this() {
            this.commonPrefixes = x.commonPrefixes
            this.deleteMarkers = x.deleteMarkers
            this.delimiter = x.delimiter
            this.encodingType = x.encodingType
            this.isTruncated = x.isTruncated
            this.keyMarker = x.keyMarker
            this.maxKeys = x.maxKeys
            this.name = x.name
            this.nextKeyMarker = x.nextKeyMarker
            this.nextVersionIdMarker = x.nextVersionIdMarker
            this.prefix = x.prefix
            this.requestCharged = x.requestCharged
            this.versionIdMarker = x.versionIdMarker
            this.versions = x.versions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ListObjectVersionsResponse = ListObjectVersionsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
