// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListBucketsResponse private constructor(builder: Builder) {
    /**
     * The list of buckets owned by the requester.
     */
    public val buckets: List<Bucket>? = builder.buckets
    /**
     * `ContinuationToken` is included in the response when there are more buckets that can be listed with pagination. The next `ListBuckets` request to Amazon S3 can be continued with this `ContinuationToken`. `ContinuationToken` is obfuscated and is not a real bucket.
     */
    public val continuationToken: kotlin.String? = builder.continuationToken
    /**
     * The owner of the buckets listed.
     */
    public val owner: aws.sdk.kotlin.services.s3.model.Owner? = builder.owner
    /**
     * If `Prefix` was sent with the request, it is included in the response.
     *
     * All bucket names in the response begin with the specified bucket name prefix.
     */
    public val prefix: kotlin.String? = builder.prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ListBucketsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBucketsResponse(")
        append("buckets=$buckets,")
        append("continuationToken=$continuationToken,")
        append("owner=$owner,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = buckets?.hashCode() ?: 0
        result = 31 * result + (continuationToken?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBucketsResponse

        if (buckets != other.buckets) return false
        if (continuationToken != other.continuationToken) return false
        if (owner != other.owner) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ListBucketsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of buckets owned by the requester.
         */
        public var buckets: List<Bucket>? = null
        /**
         * `ContinuationToken` is included in the response when there are more buckets that can be listed with pagination. The next `ListBuckets` request to Amazon S3 can be continued with this `ContinuationToken`. `ContinuationToken` is obfuscated and is not a real bucket.
         */
        public var continuationToken: kotlin.String? = null
        /**
         * The owner of the buckets listed.
         */
        public var owner: aws.sdk.kotlin.services.s3.model.Owner? = null
        /**
         * If `Prefix` was sent with the request, it is included in the response.
         *
         * All bucket names in the response begin with the specified bucket name prefix.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ListBucketsResponse) : this() {
            this.buckets = x.buckets
            this.continuationToken = x.continuationToken
            this.owner = x.owner
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ListBucketsResponse = ListBucketsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Owner] inside the given [block]
         */
        public fun owner(block: aws.sdk.kotlin.services.s3.model.Owner.Builder.() -> kotlin.Unit) {
            this.owner = aws.sdk.kotlin.services.s3.model.Owner.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
