// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListBucketsRequest private constructor(builder: Builder) {
    /**
     * Limits the response to buckets that are located in the specified Amazon Web Services Region. The Amazon Web Services Region must be expressed according to the Amazon Web Services Region code, such as `us-west-2` for the US West (Oregon) Region. For a list of the valid values for all of the Amazon Web Services Regions, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region).
     *
     * Requests made to a Regional endpoint that is different from the `bucket-region` parameter are not supported. For example, if you want to limit the response to your buckets in Region `us-west-2`, the request must be made to an endpoint in Region `us-west-2`.
     */
    public val bucketRegion: kotlin.String? = builder.bucketRegion
    /**
     * `ContinuationToken` indicates to Amazon S3 that the list is being continued on this bucket with a token. `ContinuationToken` is obfuscated and is not a real key. You can use this `ContinuationToken` for pagination of the list results.
     *
     * Length Constraints: Minimum length of 0. Maximum length of 1024.
     *
     * Required: No.
     *
     * If you specify the `bucket-region`, `prefix`, or `continuation-token` query parameters without using `max-buckets` to set the maximum number of buckets returned in the response, Amazon S3 applies a default page size of 10,000 and provides a continuation token if there are more buckets.
     */
    public val continuationToken: kotlin.String? = builder.continuationToken
    /**
     * Maximum number of buckets to be returned in response. When the number is more than the count of buckets that are owned by an Amazon Web Services account, return all the buckets in response.
     */
    public val maxBuckets: kotlin.Int? = builder.maxBuckets
    /**
     * Limits the response to bucket names that begin with the specified bucket name prefix.
     */
    public val prefix: kotlin.String? = builder.prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ListBucketsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBucketsRequest(")
        append("bucketRegion=$bucketRegion,")
        append("continuationToken=$continuationToken,")
        append("maxBuckets=$maxBuckets,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketRegion?.hashCode() ?: 0
        result = 31 * result + (continuationToken?.hashCode() ?: 0)
        result = 31 * result + (maxBuckets ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBucketsRequest

        if (bucketRegion != other.bucketRegion) return false
        if (continuationToken != other.continuationToken) return false
        if (maxBuckets != other.maxBuckets) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ListBucketsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Limits the response to buckets that are located in the specified Amazon Web Services Region. The Amazon Web Services Region must be expressed according to the Amazon Web Services Region code, such as `us-west-2` for the US West (Oregon) Region. For a list of the valid values for all of the Amazon Web Services Regions, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region).
         *
         * Requests made to a Regional endpoint that is different from the `bucket-region` parameter are not supported. For example, if you want to limit the response to your buckets in Region `us-west-2`, the request must be made to an endpoint in Region `us-west-2`.
         */
        public var bucketRegion: kotlin.String? = null
        /**
         * `ContinuationToken` indicates to Amazon S3 that the list is being continued on this bucket with a token. `ContinuationToken` is obfuscated and is not a real key. You can use this `ContinuationToken` for pagination of the list results.
         *
         * Length Constraints: Minimum length of 0. Maximum length of 1024.
         *
         * Required: No.
         *
         * If you specify the `bucket-region`, `prefix`, or `continuation-token` query parameters without using `max-buckets` to set the maximum number of buckets returned in the response, Amazon S3 applies a default page size of 10,000 and provides a continuation token if there are more buckets.
         */
        public var continuationToken: kotlin.String? = null
        /**
         * Maximum number of buckets to be returned in response. When the number is more than the count of buckets that are owned by an Amazon Web Services account, return all the buckets in response.
         */
        public var maxBuckets: kotlin.Int? = null
        /**
         * Limits the response to bucket names that begin with the specified bucket name prefix.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ListBucketsRequest) : this() {
            this.bucketRegion = x.bucketRegion
            this.continuationToken = x.continuationToken
            this.maxBuckets = x.maxBuckets
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ListBucketsRequest = ListBucketsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
