// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetBucketPolicyRequest private constructor(builder: Builder) {
    /**
     * The bucket name to get the bucket policy for.
     *
     * **Directory buckets ** - When you use this operation with a directory bucket, you must use path-style requests in the format `https://s3express-control.<i>region-code</i>.amazonaws.com/<i>bucket-name</i> `. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must also follow the format ` <i>bucket-base-name</i>--<i>zone-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*
     *
     * **Access points** - When you use this API operation with an access point, provide the alias of the access point in place of the bucket name.
     *
     * **Object Lambda access points** - When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error code `InvalidAccessPointAliasError` is returned. For more information about `InvalidAccessPointAliasError`, see [List of Error Codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList).
     *
     * Access points and Object Lambda access points are not supported by directory buckets.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     *
     * For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code `501 Not Implemented`.
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.GetBucketPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBucketPolicyRequest(")
        append("bucket=$bucket,")
        append("expectedBucketOwner=$expectedBucketOwner")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBucketPolicyRequest

        if (bucket != other.bucket) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.GetBucketPolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The bucket name to get the bucket policy for.
         *
         * **Directory buckets ** - When you use this operation with a directory bucket, you must use path-style requests in the format `https://s3express-control.<i>region-code</i>.amazonaws.com/<i>bucket-name</i> `. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must also follow the format ` <i>bucket-base-name</i>--<i>zone-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*
         *
         * **Access points** - When you use this API operation with an access point, provide the alias of the access point in place of the bucket name.
         *
         * **Object Lambda access points** - When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error code `InvalidAccessPointAliasError` is returned. For more information about `InvalidAccessPointAliasError`, see [List of Error Codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList).
         *
         * Access points and Object Lambda access points are not supported by directory buckets.
         */
        public var bucket: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         *
         * For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code `501 Not Implemented`.
         */
        public var expectedBucketOwner: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.GetBucketPolicyRequest) : this() {
            this.bucket = x.bucket
            this.expectedBucketOwner = x.expectedBucketOwner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.GetBucketPolicyRequest = GetBucketPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
