// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The metadata table configuration for a general purpose bucket.
 */
public class GetBucketMetadataTableConfigurationResult private constructor(builder: Builder) {
    /**
     * If the `CreateBucketMetadataTableConfiguration` request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code and error message.
     */
    public val error: aws.sdk.kotlin.services.s3.model.ErrorDetails? = builder.error
    /**
     * The metadata table configuration for a general purpose bucket.
     */
    public val metadataTableConfigurationResult: aws.sdk.kotlin.services.s3.model.MetadataTableConfigurationResult? = builder.metadataTableConfigurationResult
    /**
     * The status of the metadata table. The status values are:
     * + `CREATING` - The metadata table is in the process of being created in the specified table bucket.
     * + `ACTIVE` - The metadata table has been created successfully and records are being delivered to the table.
     * + `FAILED` - Amazon S3 is unable to create the metadata table, or Amazon S3 is unable to deliver records. See `ErrorDetails` for details.
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.GetBucketMetadataTableConfigurationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBucketMetadataTableConfigurationResult(")
        append("error=$error,")
        append("metadataTableConfigurationResult=$metadataTableConfigurationResult,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = error?.hashCode() ?: 0
        result = 31 * result + (metadataTableConfigurationResult?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBucketMetadataTableConfigurationResult

        if (error != other.error) return false
        if (metadataTableConfigurationResult != other.metadataTableConfigurationResult) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.GetBucketMetadataTableConfigurationResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If the `CreateBucketMetadataTableConfiguration` request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code and error message.
         */
        public var error: aws.sdk.kotlin.services.s3.model.ErrorDetails? = null
        /**
         * The metadata table configuration for a general purpose bucket.
         */
        public var metadataTableConfigurationResult: aws.sdk.kotlin.services.s3.model.MetadataTableConfigurationResult? = null
        /**
         * The status of the metadata table. The status values are:
         * + `CREATING` - The metadata table is in the process of being created in the specified table bucket.
         * + `ACTIVE` - The metadata table has been created successfully and records are being delivered to the table.
         * + `FAILED` - Amazon S3 is unable to create the metadata table, or Amazon S3 is unable to deliver records. See `ErrorDetails` for details.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.GetBucketMetadataTableConfigurationResult) : this() {
            this.error = x.error
            this.metadataTableConfigurationResult = x.metadataTableConfigurationResult
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.GetBucketMetadataTableConfigurationResult = GetBucketMetadataTableConfigurationResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.ErrorDetails] inside the given [block]
         */
        public fun error(block: aws.sdk.kotlin.services.s3.model.ErrorDetails.Builder.() -> kotlin.Unit) {
            this.error = aws.sdk.kotlin.services.s3.model.ErrorDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.MetadataTableConfigurationResult] inside the given [block]
         */
        public fun metadataTableConfigurationResult(block: aws.sdk.kotlin.services.s3.model.MetadataTableConfigurationResult.Builder.() -> kotlin.Unit) {
            this.metadataTableConfigurationResult = aws.sdk.kotlin.services.s3.model.MetadataTableConfigurationResult.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (status == null) status = ""
            return this
        }
    }
}
