// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetBucketLifecycleConfigurationResponse private constructor(builder: Builder) {
    /**
     * Container for a lifecycle rule.
     */
    public val rules: List<LifecycleRule>? = builder.rules
    /**
     * Indicates which default minimum object size behavior is applied to the lifecycle configuration.
     *
     * This parameter applies to general purpose buckets only. It is not supported for directory bucket lifecycle configurations.
     *
     * + `all_storage_classes_128K` - Objects smaller than 128 KB will not transition to any storage class by default.
     * + `varies_by_storage_class` - Objects smaller than 128 KB will transition to Glacier Flexible Retrieval or Glacier Deep Archive storage classes. By default, all other storage classes will prevent transitions smaller than 128 KB.
     *
     * To customize the minimum object size for any transition you can add a filter that specifies a custom `ObjectSizeGreaterThan` or `ObjectSizeLessThan` in the body of your transition rule. Custom filters always take precedence over the default transition behavior.
     */
    public val transitionDefaultMinimumObjectSize: aws.sdk.kotlin.services.s3.model.TransitionDefaultMinimumObjectSize? = builder.transitionDefaultMinimumObjectSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.GetBucketLifecycleConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBucketLifecycleConfigurationResponse(")
        append("rules=$rules,")
        append("transitionDefaultMinimumObjectSize=$transitionDefaultMinimumObjectSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = rules?.hashCode() ?: 0
        result = 31 * result + (transitionDefaultMinimumObjectSize?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBucketLifecycleConfigurationResponse

        if (rules != other.rules) return false
        if (transitionDefaultMinimumObjectSize != other.transitionDefaultMinimumObjectSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.GetBucketLifecycleConfigurationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Container for a lifecycle rule.
         */
        public var rules: List<LifecycleRule>? = null
        /**
         * Indicates which default minimum object size behavior is applied to the lifecycle configuration.
         *
         * This parameter applies to general purpose buckets only. It is not supported for directory bucket lifecycle configurations.
         *
         * + `all_storage_classes_128K` - Objects smaller than 128 KB will not transition to any storage class by default.
         * + `varies_by_storage_class` - Objects smaller than 128 KB will transition to Glacier Flexible Retrieval or Glacier Deep Archive storage classes. By default, all other storage classes will prevent transitions smaller than 128 KB.
         *
         * To customize the minimum object size for any transition you can add a filter that specifies a custom `ObjectSizeGreaterThan` or `ObjectSizeLessThan` in the body of your transition rule. Custom filters always take precedence over the default transition behavior.
         */
        public var transitionDefaultMinimumObjectSize: aws.sdk.kotlin.services.s3.model.TransitionDefaultMinimumObjectSize? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.GetBucketLifecycleConfigurationResponse) : this() {
            this.rules = x.rules
            this.transitionDefaultMinimumObjectSize = x.transitionDefaultMinimumObjectSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.GetBucketLifecycleConfigurationResponse = GetBucketLifecycleConfigurationResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
