// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the type of server-side encryption used.
 */
public class Encryption private constructor(builder: Builder) {
    /**
     * The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, `aws:kms`).
     */
    public val encryptionType: aws.sdk.kotlin.services.s3.model.ServerSideEncryption = requireNotNull(builder.encryptionType) { "A non-null value must be provided for encryptionType" }
    /**
     * If the encryption type is `aws:kms`, this optional value can be used to specify the encryption context for the restore results.
     */
    public val kmsContext: kotlin.String? = builder.kmsContext
    /**
     * If the encryption type is `aws:kms`, this optional value specifies the ID of the symmetric encryption customer managed key to use for encryption of job results. Amazon S3 only supports symmetric encryption KMS keys. For more information, see [Asymmetric keys in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Amazon Web Services Key Management Service Developer Guide*.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.Encryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Encryption(")
        append("encryptionType=$encryptionType,")
        append("kmsContext=$kmsContext,")
        append("kmsKeyId=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionType.hashCode()
        result = 31 * result + (kmsContext?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Encryption

        if (encryptionType != other.encryptionType) return false
        if (kmsContext != other.kmsContext) return false
        if (kmsKeyId != other.kmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.Encryption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, `aws:kms`).
         */
        public var encryptionType: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = null
        /**
         * If the encryption type is `aws:kms`, this optional value can be used to specify the encryption context for the restore results.
         */
        public var kmsContext: kotlin.String? = null
        /**
         * If the encryption type is `aws:kms`, this optional value specifies the ID of the symmetric encryption customer managed key to use for encryption of job results. Amazon S3 only supports symmetric encryption KMS keys. For more information, see [Asymmetric keys in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Amazon Web Services Key Management Service Developer Guide*.
         */
        public var kmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.Encryption) : this() {
            this.encryptionType = x.encryptionType
            this.kmsContext = x.kmsContext
            this.kmsKeyId = x.kmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.Encryption = Encryption(this)

        internal fun correctErrors(): Builder {
            if (encryptionType == null) encryptionType = ServerSideEncryption.SdkUnknown("no value provided")
            return this
        }
    }
}
