// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import kotlin.collections.List

/**
 * Encoding type used by Amazon S3 to encode the [object keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html) in the response. Responses are encoded only in UTF-8. An object key can contain any Unicode character. However, the XML 1.0 parser can't parse certain characters, such as characters with an ASCII value from 0 to 10. For characters that aren't supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response. For more information about characters to avoid in object key names, see [Object key naming guidelines](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-guidelines).
 *
 * When using the URL encoding type, non-ASCII characters that are used in an object's key name will be percent-encoded according to UTF-8 code values. For example, the object `test_file(3).png` will appear as `test_file%283%29.png`.
 */
public sealed class EncodingType {
    public abstract val value: kotlin.String

    public object Url : aws.sdk.kotlin.services.s3.model.EncodingType() {
        override val value: kotlin.String = "url"
        override fun toString(): kotlin.String = "Url"
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.s3.model.EncodingType() {
        override fun toString(): kotlin.String = "SdkUnknown($value)"
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(value: kotlin.String): aws.sdk.kotlin.services.s3.model.EncodingType = when (value) {
            "url" -> Url
            else -> SdkUnknown(value)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.s3.model.EncodingType> = values

        private val values: kotlin.collections.List<aws.sdk.kotlin.services.s3.model.EncodingType> = listOf(
            Url,
        )
    }
}
