// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the deleted object.
 */
public class DeletedObject private constructor(builder: Builder) {
    /**
     * Indicates whether the specified object version that was permanently deleted was (true) or was not (false) a delete marker before deletion. In a simple DELETE, this header indicates whether (true) or not (false) the current version of the object is a delete marker.
     *
     * This functionality is not supported for directory buckets.
     */
    public val deleteMarker: kotlin.Boolean? = builder.deleteMarker
    /**
     * The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.
     *
     * This functionality is not supported for directory buckets.
     */
    public val deleteMarkerVersionId: kotlin.String? = builder.deleteMarkerVersionId
    /**
     * The name of the deleted object.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The version ID of the deleted object.
     *
     * This functionality is not supported for directory buckets.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.DeletedObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeletedObject(")
        append("deleteMarker=$deleteMarker,")
        append("deleteMarkerVersionId=$deleteMarkerVersionId,")
        append("key=$key,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteMarker?.hashCode() ?: 0
        result = 31 * result + (deleteMarkerVersionId?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeletedObject

        if (deleteMarker != other.deleteMarker) return false
        if (deleteMarkerVersionId != other.deleteMarkerVersionId) return false
        if (key != other.key) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.DeletedObject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the specified object version that was permanently deleted was (true) or was not (false) a delete marker before deletion. In a simple DELETE, this header indicates whether (true) or not (false) the current version of the object is a delete marker.
         *
         * This functionality is not supported for directory buckets.
         */
        public var deleteMarker: kotlin.Boolean? = null
        /**
         * The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.
         *
         * This functionality is not supported for directory buckets.
         */
        public var deleteMarkerVersionId: kotlin.String? = null
        /**
         * The name of the deleted object.
         */
        public var key: kotlin.String? = null
        /**
         * The version ID of the deleted object.
         *
         * This functionality is not supported for directory buckets.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.DeletedObject) : this() {
            this.deleteMarker = x.deleteMarker
            this.deleteMarkerVersionId = x.deleteMarkerVersionId
            this.key = x.key
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.DeletedObject = DeletedObject(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
