// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies whether Amazon S3 replicates delete markers. If you specify a `Filter` in your replication configuration, you must also include a `DeleteMarkerReplication` element. If your `Filter` includes a `Tag` element, the `DeleteMarkerReplication``Status` must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config).
 *
 * For more information about delete marker replication, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html).
 *
 * If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see [Backward Compatibility](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
 */
public class DeleteMarkerReplication private constructor(builder: Builder) {
    /**
     * Indicates whether to replicate delete markers.
     *
     * Indicates whether to replicate delete markers.
     */
    public val status: aws.sdk.kotlin.services.s3.model.DeleteMarkerReplicationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteMarkerReplication(")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteMarkerReplication

        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether to replicate delete markers.
         *
         * Indicates whether to replicate delete markers.
         */
        public var status: aws.sdk.kotlin.services.s3.model.DeleteMarkerReplicationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication) : this() {
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication = DeleteMarkerReplication(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
