// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the objects to delete.
 */
public class Delete private constructor(builder: Builder) {
    /**
     * The object to delete.
     *
     * **Directory buckets** - For directory buckets, an object that's composed entirely of whitespace characters is not supported by the `DeleteObjects` API operation. The request will receive a `400 Bad Request` error and none of the objects in the request will be deleted.
     */
    public val objects: List<ObjectIdentifier> = requireNotNull(builder.objects) { "A non-null value must be provided for objects" }
    /**
     * Element to enable quiet mode for the request. When you add this element, you must set its value to `true`.
     */
    public val quiet: kotlin.Boolean? = builder.quiet

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.Delete = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Delete(")
        append("objects=$objects,")
        append("quiet=$quiet")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = objects.hashCode()
        result = 31 * result + (quiet?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Delete

        if (objects != other.objects) return false
        if (quiet != other.quiet) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.Delete = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The object to delete.
         *
         * **Directory buckets** - For directory buckets, an object that's composed entirely of whitespace characters is not supported by the `DeleteObjects` API operation. The request will receive a `400 Bad Request` error and none of the objects in the request will be deleted.
         */
        public var objects: List<ObjectIdentifier>? = null
        /**
         * Element to enable quiet mode for the request. When you add this element, you must set its value to `true`.
         */
        public var quiet: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.Delete) : this() {
            this.objects = x.objects
            this.quiet = x.quiet
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.Delete = Delete(this)

        internal fun correctErrors(): Builder {
            if (objects == null) objects = emptyList()
            return this
        }
    }
}
