// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateSessionResponse private constructor(builder: Builder) {
    /**
     * Indicates whether to use an S3 Bucket Key for server-side encryption with KMS keys (SSE-KMS).
     */
    public val bucketKeyEnabled: kotlin.Boolean? = builder.bucketKeyEnabled
    /**
     * The established temporary security credentials for the created session.
     */
    public val credentials: aws.sdk.kotlin.services.s3.model.SessionCredentials? = builder.credentials
    /**
     * The server-side encryption algorithm used when you store objects in the directory bucket.
     */
    public val serverSideEncryption: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = builder.serverSideEncryption
    /**
     * If present, indicates the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a Base64-encoded string of a UTF-8 encoded JSON, which contains the encryption context as key-value pairs. This value is stored as object metadata and automatically gets passed on to Amazon Web Services KMS for future `GetObject` operations on this object.
     */
    public val ssekmsEncryptionContext: kotlin.String? = builder.ssekmsEncryptionContext
    /**
     * If you specify `x-amz-server-side-encryption` with `aws:kms`, this header indicates the ID of the KMS symmetric encryption customer managed key that was used for object encryption.
     */
    public val ssekmsKeyId: kotlin.String? = builder.ssekmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.CreateSessionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSessionResponse(")
        append("bucketKeyEnabled=$bucketKeyEnabled,")
        append("credentials=$credentials,")
        append("serverSideEncryption=$serverSideEncryption,")
        append("ssekmsEncryptionContext=*** Sensitive Data Redacted ***,")
        append("ssekmsKeyId=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketKeyEnabled?.hashCode() ?: 0
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (ssekmsEncryptionContext?.hashCode() ?: 0)
        result = 31 * result + (ssekmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSessionResponse

        if (bucketKeyEnabled != other.bucketKeyEnabled) return false
        if (credentials != other.credentials) return false
        if (serverSideEncryption != other.serverSideEncryption) return false
        if (ssekmsEncryptionContext != other.ssekmsEncryptionContext) return false
        if (ssekmsKeyId != other.ssekmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.CreateSessionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether to use an S3 Bucket Key for server-side encryption with KMS keys (SSE-KMS).
         */
        public var bucketKeyEnabled: kotlin.Boolean? = null
        /**
         * The established temporary security credentials for the created session.
         */
        public var credentials: aws.sdk.kotlin.services.s3.model.SessionCredentials? = null
        /**
         * The server-side encryption algorithm used when you store objects in the directory bucket.
         */
        public var serverSideEncryption: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = null
        /**
         * If present, indicates the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a Base64-encoded string of a UTF-8 encoded JSON, which contains the encryption context as key-value pairs. This value is stored as object metadata and automatically gets passed on to Amazon Web Services KMS for future `GetObject` operations on this object.
         */
        public var ssekmsEncryptionContext: kotlin.String? = null
        /**
         * If you specify `x-amz-server-side-encryption` with `aws:kms`, this header indicates the ID of the KMS symmetric encryption customer managed key that was used for object encryption.
         */
        public var ssekmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.CreateSessionResponse) : this() {
            this.bucketKeyEnabled = x.bucketKeyEnabled
            this.credentials = x.credentials
            this.serverSideEncryption = x.serverSideEncryption
            this.ssekmsEncryptionContext = x.ssekmsEncryptionContext
            this.ssekmsKeyId = x.ssekmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.CreateSessionResponse = CreateSessionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.SessionCredentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.services.s3.model.SessionCredentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.s3.model.SessionCredentials.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
