// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the `/docs` folder, redirect to the `/documents` folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
 */
public class Condition private constructor(builder: Builder) {
    /**
     * The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied. Required when parent element `Condition` is specified and sibling `KeyPrefixEquals` is not specified. If both are specified, then both must be true for the redirect to be applied.
     */
    public val httpErrorCodeReturnedEquals: kotlin.String? = builder.httpErrorCodeReturnedEquals
    /**
     * The object key name prefix when the redirect is applied. For example, to redirect requests for `ExamplePage.html`, the key prefix will be `ExamplePage.html`. To redirect request for all pages with the prefix `docs/`, the key prefix will be `/docs`, which identifies all objects in the `docs/` folder. Required when the parent element `Condition` is specified and sibling `HttpErrorCodeReturnedEquals` is not specified. If both conditions are specified, both must be true for the redirect to be applied.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    public val keyPrefixEquals: kotlin.String? = builder.keyPrefixEquals

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.Condition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Condition(")
        append("httpErrorCodeReturnedEquals=$httpErrorCodeReturnedEquals,")
        append("keyPrefixEquals=$keyPrefixEquals")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpErrorCodeReturnedEquals?.hashCode() ?: 0
        result = 31 * result + (keyPrefixEquals?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Condition

        if (httpErrorCodeReturnedEquals != other.httpErrorCodeReturnedEquals) return false
        if (keyPrefixEquals != other.keyPrefixEquals) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.Condition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied. Required when parent element `Condition` is specified and sibling `KeyPrefixEquals` is not specified. If both are specified, then both must be true for the redirect to be applied.
         */
        public var httpErrorCodeReturnedEquals: kotlin.String? = null
        /**
         * The object key name prefix when the redirect is applied. For example, to redirect requests for `ExamplePage.html`, the key prefix will be `ExamplePage.html`. To redirect request for all pages with the prefix `docs/`, the key prefix will be `/docs`, which identifies all objects in the `docs/` folder. Required when the parent element `Condition` is specified and sibling `HttpErrorCodeReturnedEquals` is not specified. If both conditions are specified, both must be true for the redirect to be applied.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        public var keyPrefixEquals: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.Condition) : this() {
            this.httpErrorCodeReturnedEquals = x.httpErrorCodeReturnedEquals
            this.keyPrefixEquals = x.keyPrefixEquals
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.Condition = Condition(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
