// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class AbortMultipartUploadRequest private constructor(builder: Builder) {
    /**
     * The bucket name to which the upload was taking place.
     *
     * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket-name</i>.s3express-<i>zone-id</i>.<i>region-code</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must follow the format ` <i>bucket-base-name</i>--<i>zone-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
     *
     * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     *
     * Access points and Object Lambda access points are not supported by directory buckets.
     *
     * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * If present, this header aborts an in progress multipart upload only if it was initiated on the provided timestamp. If the initiated timestamp of the multipart upload does not match the provided value, the operation returns a `412 Precondition Failed` error. If the initiated timestamp matches or if the multipart upload doesn’t exist, the operation returns a `204 Success (No Content)` response.
     *
     * This functionality is only supported for directory buckets.
     */
    public val ifMatchInitiatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.ifMatchInitiatedTime
    /**
     * Key of the object for which the multipart upload was initiated.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * Upload ID that identifies the multipart upload.
     */
    public val uploadId: kotlin.String? = builder.uploadId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.AbortMultipartUploadRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AbortMultipartUploadRequest(")
        append("bucket=$bucket,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("ifMatchInitiatedTime=$ifMatchInitiatedTime,")
        append("key=$key,")
        append("requestPayer=$requestPayer,")
        append("uploadId=$uploadId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (ifMatchInitiatedTime?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AbortMultipartUploadRequest

        if (bucket != other.bucket) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (ifMatchInitiatedTime != other.ifMatchInitiatedTime) return false
        if (key != other.key) return false
        if (requestPayer != other.requestPayer) return false
        if (uploadId != other.uploadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.AbortMultipartUploadRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The bucket name to which the upload was taking place.
         *
         * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket-name</i>.s3express-<i>zone-id</i>.<i>region-code</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must follow the format ` <i>bucket-base-name</i>--<i>zone-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
         *
         * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         *
         * Access points and Object Lambda access points are not supported by directory buckets.
         *
         * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
         */
        public var bucket: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * If present, this header aborts an in progress multipart upload only if it was initiated on the provided timestamp. If the initiated timestamp of the multipart upload does not match the provided value, the operation returns a `412 Precondition Failed` error. If the initiated timestamp matches or if the multipart upload doesn’t exist, the operation returns a `204 Success (No Content)` response.
         *
         * This functionality is only supported for directory buckets.
         */
        public var ifMatchInitiatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Key of the object for which the multipart upload was initiated.
         */
        public var key: kotlin.String? = null
        /**
         * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * Upload ID that identifies the multipart upload.
         */
        public var uploadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.AbortMultipartUploadRequest) : this() {
            this.bucket = x.bucket
            this.expectedBucketOwner = x.expectedBucketOwner
            this.ifMatchInitiatedTime = x.ifMatchInitiatedTime
            this.key = x.key
            this.requestPayer = x.requestPayer
            this.uploadId = x.uploadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.AbortMultipartUploadRequest = AbortMultipartUploadRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
