// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.endpoints



/**
 * The set of values necessary for endpoint resolution.
 */
public class S3EndpointParameters private constructor(builder: Builder) {
    /**
     * When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.
     */
    public val accelerate: Boolean? = requireNotNull(builder.accelerate) { "endpoint provider parameter #accelerate is required" }

    /**
     * The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
     */
    public val bucket: String? = builder.bucket

    /**
     * The Copy Source used for Copy Object request. This is an optional parameter that will be set automatically for operations that are scoped to Copy Source.
     */
    public val copySource: String? = builder.copySource

    /**
     * Internal parameter to disable Access Point Buckets
     */
    public val disableAccessPoints: Boolean? = builder.disableAccessPoints

    /**
     * Whether multi-region access points (MRAP) should be disabled.
     */
    public val disableMultiRegionAccessPoints: Boolean? = requireNotNull(builder.disableMultiRegionAccessPoints) { "endpoint provider parameter #disableMultiRegionAccessPoints is required" }

    /**
     * Parameter to indicate whether S3Express session auth should be disabled
     */
    public val disableS3ExpressSessionAuth: Boolean? = builder.disableS3ExpressSessionAuth

    /**
     * Override the endpoint used to send this request
     */
    public val endpoint: String? = builder.endpoint

    /**
     * When true, force a path-style endpoint to be used where the bucket name is part of the path.
     */
    public val forcePathStyle: Boolean? = requireNotNull(builder.forcePathStyle) { "endpoint provider parameter #forcePathStyle is required" }

    /**
     * The S3 Key used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Key.
     */
    public val key: String? = builder.key

    /**
     * The S3 Prefix used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Prefix.
     */
    public val prefix: String? = builder.prefix

    /**
     * The AWS region used to dispatch the request.
     */
    public val region: String? = builder.region

    /**
     * When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.
     */
    public val useArnRegion: Boolean? = builder.useArnRegion

    /**
     * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
     */
    public val useDualStack: Boolean? = requireNotNull(builder.useDualStack) { "endpoint provider parameter #useDualStack is required" }

    /**
     * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
     */
    public val useFips: Boolean? = requireNotNull(builder.useFips) { "endpoint provider parameter #useFips is required" }

    /**
     * Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
     */
    public val useGlobalEndpoint: Boolean? = requireNotNull(builder.useGlobalEndpoint) { "endpoint provider parameter #useGlobalEndpoint is required" }

    /**
     * Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)
     */
    public val useObjectLambdaEndpoint: Boolean? = builder.useObjectLambdaEndpoint

    /**
     * Internal parameter to indicate whether S3Express operation should use control plane, (ex. CreateBucket)
     */
    public val useS3ExpressControlEndpoint: Boolean? = builder.useS3ExpressControlEndpoint

    public companion object {
        public inline operator fun invoke(block: Builder.() -> Unit): S3EndpointParameters = Builder().apply(block).build()
    }

    public override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is S3EndpointParameters) return false
        if (this.accelerate != other.accelerate) return false
        if (this.bucket != other.bucket) return false
        if (this.copySource != other.copySource) return false
        if (this.disableAccessPoints != other.disableAccessPoints) return false
        if (this.disableMultiRegionAccessPoints != other.disableMultiRegionAccessPoints) return false
        if (this.disableS3ExpressSessionAuth != other.disableS3ExpressSessionAuth) return false
        if (this.endpoint != other.endpoint) return false
        if (this.forcePathStyle != other.forcePathStyle) return false
        if (this.key != other.key) return false
        if (this.prefix != other.prefix) return false
        if (this.region != other.region) return false
        if (this.useArnRegion != other.useArnRegion) return false
        if (this.useDualStack != other.useDualStack) return false
        if (this.useFips != other.useFips) return false
        if (this.useGlobalEndpoint != other.useGlobalEndpoint) return false
        if (this.useObjectLambdaEndpoint != other.useObjectLambdaEndpoint) return false
        if (this.useS3ExpressControlEndpoint != other.useS3ExpressControlEndpoint) return false
        return true
    }

    public override fun hashCode(): Int {
        var result = accelerate?.hashCode() ?: 0
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (copySource?.hashCode() ?: 0)
        result = 31 * result + (disableAccessPoints?.hashCode() ?: 0)
        result = 31 * result + (disableMultiRegionAccessPoints?.hashCode() ?: 0)
        result = 31 * result + (disableS3ExpressSessionAuth?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (forcePathStyle?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (useArnRegion?.hashCode() ?: 0)
        result = 31 * result + (useDualStack?.hashCode() ?: 0)
        result = 31 * result + (useFips?.hashCode() ?: 0)
        result = 31 * result + (useGlobalEndpoint?.hashCode() ?: 0)
        result = 31 * result + (useObjectLambdaEndpoint?.hashCode() ?: 0)
        result = 31 * result + (useS3ExpressControlEndpoint?.hashCode() ?: 0)
        return result
    }

    public override fun toString(): String = buildString {
        append("S3EndpointParameters(")
        append("accelerate=$accelerate,")
        append("bucket=$bucket,")
        append("copySource=$copySource,")
        append("disableAccessPoints=$disableAccessPoints,")
        append("disableMultiRegionAccessPoints=$disableMultiRegionAccessPoints,")
        append("disableS3ExpressSessionAuth=$disableS3ExpressSessionAuth,")
        append("endpoint=$endpoint,")
        append("forcePathStyle=$forcePathStyle,")
        append("key=$key,")
        append("prefix=$prefix,")
        append("region=$region,")
        append("useArnRegion=$useArnRegion,")
        append("useDualStack=$useDualStack,")
        append("useFips=$useFips,")
        append("useGlobalEndpoint=$useGlobalEndpoint,")
        append("useObjectLambdaEndpoint=$useObjectLambdaEndpoint,")
        append("useS3ExpressControlEndpoint=$useS3ExpressControlEndpoint)")
    }

    public fun copy(block: Builder.() -> Unit = {}): S3EndpointParameters {
        return Builder().apply {
            accelerate = this@S3EndpointParameters.accelerate
            bucket = this@S3EndpointParameters.bucket
            copySource = this@S3EndpointParameters.copySource
            disableAccessPoints = this@S3EndpointParameters.disableAccessPoints
            disableMultiRegionAccessPoints = this@S3EndpointParameters.disableMultiRegionAccessPoints
            disableS3ExpressSessionAuth = this@S3EndpointParameters.disableS3ExpressSessionAuth
            endpoint = this@S3EndpointParameters.endpoint
            forcePathStyle = this@S3EndpointParameters.forcePathStyle
            key = this@S3EndpointParameters.key
            prefix = this@S3EndpointParameters.prefix
            region = this@S3EndpointParameters.region
            useArnRegion = this@S3EndpointParameters.useArnRegion
            useDualStack = this@S3EndpointParameters.useDualStack
            useFips = this@S3EndpointParameters.useFips
            useGlobalEndpoint = this@S3EndpointParameters.useGlobalEndpoint
            useObjectLambdaEndpoint = this@S3EndpointParameters.useObjectLambdaEndpoint
            useS3ExpressControlEndpoint = this@S3EndpointParameters.useS3ExpressControlEndpoint
            block()
        }
        .build()
    }

    public class Builder {
        /**
         * When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.
         */
        public var accelerate: Boolean? = false

        /**
         * The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
         */
        public var bucket: String? = null

        /**
         * The Copy Source used for Copy Object request. This is an optional parameter that will be set automatically for operations that are scoped to Copy Source.
         */
        public var copySource: String? = null

        /**
         * Internal parameter to disable Access Point Buckets
         */
        public var disableAccessPoints: Boolean? = null

        /**
         * Whether multi-region access points (MRAP) should be disabled.
         */
        public var disableMultiRegionAccessPoints: Boolean? = false

        /**
         * Parameter to indicate whether S3Express session auth should be disabled
         */
        public var disableS3ExpressSessionAuth: Boolean? = null

        /**
         * Override the endpoint used to send this request
         */
        public var endpoint: String? = null

        /**
         * When true, force a path-style endpoint to be used where the bucket name is part of the path.
         */
        public var forcePathStyle: Boolean? = false

        /**
         * The S3 Key used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Key.
         */
        public var key: String? = null

        /**
         * The S3 Prefix used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Prefix.
         */
        public var prefix: String? = null

        /**
         * The AWS region used to dispatch the request.
         */
        public var region: String? = null

        /**
         * When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.
         */
        public var useArnRegion: Boolean? = null

        /**
         * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
         */
        public var useDualStack: Boolean? = false

        /**
         * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
         */
        public var useFips: Boolean? = false

        /**
         * Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
         */
        public var useGlobalEndpoint: Boolean? = false

        /**
         * Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)
         */
        public var useObjectLambdaEndpoint: Boolean? = null

        /**
         * Internal parameter to indicate whether S3Express operation should use control plane, (ex. CreateBucket)
         */
        public var useS3ExpressControlEndpoint: Boolean? = null

        public fun build(): S3EndpointParameters = S3EndpointParameters(this)
    }
}
