// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.auth

import aws.sdk.kotlin.services.s3.endpoints.S3EndpointParameters

public class S3AuthSchemeParameters private constructor(builder: Builder) {
    public val endpointParameters: S3EndpointParameters? = builder.endpointParameters
    public val operationName: String = requireNotNull(builder.operationName) { "operationName is a required auth scheme parameter" }
    public companion object {
        public inline operator fun invoke(block: Builder.() -> kotlin.Unit): S3AuthSchemeParameters = Builder().apply(block).build()
    }

    public fun toBuilder(): Builder = Builder().apply {
        endpointParameters = this@S3AuthSchemeParameters.endpointParameters
        operationName = this@S3AuthSchemeParameters.operationName
    }

    public class Builder {
        /**
         * The parameters used for endpoint resolution. The default implementation of this interface
         * relies on endpoint metadata to resolve auth scheme candidates.
         */
        public var endpointParameters: S3EndpointParameters? = null

        /**
         * The name of the operation currently being invoked.
         */
        public var operationName: String? = null

        @PublishedApi
        internal fun build(): S3AuthSchemeParameters = S3AuthSchemeParameters(this)
    }

    override fun toString(): String = buildString {
        append("S3AuthSchemeParameters(")
        append("endpointParameters=$endpointParameters,")
        append("operationName=$operationName)")
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is S3AuthSchemeParameters) return false
        if (this.endpointParameters != other.endpointParameters) return false
        if (this.operationName != other.operationName) return false
        return true
    }

    override fun hashCode(): Int {
        var result = endpointParameters?.hashCode() ?: 0
        result = 31 * result + (operationName?.hashCode() ?: 0)
        return result
    }

    public fun copy(block: Builder.() -> Unit = {}): S3AuthSchemeParameters {
        return Builder().apply {
            endpointParameters = this@S3AuthSchemeParameters.endpointParameters
            operationName = this@S3AuthSchemeParameters.operationName
            block()
        }
        .build()
    }
}
