/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.maven;

import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PublishConfiguration;
import au.com.dius.pact.core.pactbroker.RequestFailedException;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.provider.maven.PactBaseMojo;
import au.com.dius.pact.provider.maven.PactPublishMojo;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lau/com/dius/pact/provider/maven/PactPublishMojo;", "Lau/com/dius/pact/provider/maven/PactBaseMojo;", "()V", "branchName", "", "getBranchName", "()Ljava/lang/String;", "setBranchName", "(Ljava/lang/String;)V", "brokerClient", "Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "buildUrl", "getBuildUrl", "setBuildUrl", "excludes", "", "pactDirectory", "projectVersion", "skipPactPublish", "", "tags", "trimSnapshot", "calculateTags", "", "execute", "", "pactFileIsExcluded", "exclusions", "Lkotlin/text/Regex;", "pactFile", "Ljava/io/File;", "maven"})
@Mojo(name="publish")
public class PactPublishMojo
extends PactBaseMojo {
    @Parameter(property="skipPactPublish", defaultValue="false")
    private boolean skipPactPublish;
    @Parameter(property="pact.projectVersion", defaultValue="${project.version}", required=true)
    private String projectVersion;
    @Parameter(property="pact.trimSnapshot", defaultValue="false")
    private boolean trimSnapshot;
    @Parameter(property="pact.pactDirectory", defaultValue="${project.build.directory}/pacts")
    private String pactDirectory;
    @Nullable
    private PactBrokerClient brokerClient;
    @Parameter
    @NotNull
    private List<String> tags;
    @Parameter
    @NotNull
    private List<String> excludes;
    @Parameter
    @Nullable
    private String branchName;
    @Parameter
    @Nullable
    private String buildUrl;

    public PactPublishMojo() {
        boolean bl = false;
        this.tags = new ArrayList();
        bl = false;
        this.excludes = new ArrayList();
    }

    @Nullable
    public final String getBranchName() {
        return this.branchName;
    }

    public final void setBranchName(@Nullable String string) {
        this.branchName = string;
    }

    @Nullable
    public final String getBuildUrl() {
        return this.buildUrl;
    }

    public final void setBuildUrl(@Nullable String string) {
        this.buildUrl = string;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        String string;
        String string2;
        String string3;
        if (this.skipPactPublish) {
            String string4 = "'skipPactPublish' is set to true, skipping uploading of pacts";
            boolean bl = false;
            System.out.println((Object)string4);
            return;
        }
        CharSequence charSequence = this.getPactBrokerUrl();
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && this.brokerClient == null) {
            throw new MojoExecutionException("pactBrokerUrl is required");
        }
        String snapShotDefinitionString = "-SNAPSHOT";
        if (this.trimSnapshot) {
            String string5;
            String string6 = this.projectVersion;
            if (string6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                string5 = null;
            } else {
                string5 = string6;
            }
            if (StringsKt.contains$default((CharSequence)string5, (CharSequence)snapShotDefinitionString, (boolean)false, (int)2, null)) {
                String string7;
                String string8;
                Regex snapshotRegex = new Regex(".*(" + snapShotDefinitionString + ")");
                String string9 = this.projectVersion;
                if (string9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                    string8 = null;
                } else {
                    string8 = string9;
                }
                string9 = string8;
                String string10 = this.projectVersion;
                if (string10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                    string7 = null;
                } else {
                    string7 = string10;
                }
                MatchResult matchResult = Regex.find$default((Regex)snapshotRegex, (CharSequence)string7, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                string10 = matchGroup.getRange();
                boolean bl3 = false;
                this.projectVersion = ((Object)StringsKt.removeRange((CharSequence)string9, (IntRange)string10)).toString();
            }
        }
        if (this.brokerClient == null) {
            String string11 = this.getPactBrokerUrl();
            Intrinsics.checkNotNull((Object)string11);
            this.brokerClient = new PactBrokerClient(string11, this.brokerClientOptions(), this.brokerClientConfig());
        }
        if ((string3 = this.pactDirectory) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pactDirectory");
            string2 = null;
        } else {
            string2 = string3;
        }
        File pactDirectory = new File(string2);
        List<String> tagsToPublish = this.calculateTags();
        Object object = this.projectVersion;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
            string = null;
        } else {
            string = object;
        }
        PublishConfiguration publishConfiguration = new PublishConfiguration(string, tagsToPublish, this.branchName, this.buildUrl);
        if (!pactDirectory.exists()) {
            object = "Pact directory " + pactDirectory + " does not exist, skipping uploading of pacts";
            boolean bl4 = false;
            System.out.println(object);
        } else {
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.excludes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string12 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl52 = false;
                Regex regex = new Regex(it);
                collection.add(regex);
            }
            List excludedList = (List)destination$iv$iv;
            boolean anyFailed = false;
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)pactDirectory)), (Function1)execute.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl52;
                File pactFile = (File)element$iv;
                boolean bl6 = false;
                if (this.pactFileIsExcluded(excludedList, pactFile)) {
                    it = "Not publishing '" + pactFile.getName() + "' as it matches an item in the excluded list";
                    boolean bl52 = false;
                    System.out.println((Object)it);
                    continue;
                }
                if (KotlinLanguageSupportKt.isNotEmpty(tagsToPublish)) {
                    it = "Publishing '" + pactFile.getName() + "' with tags '" + CollectionsKt.joinToString$default((Iterable)tagsToPublish, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "' ... ";
                    bl52 = false;
                    System.out.println((Object)it);
                } else {
                    it = "Publishing '" + pactFile.getName() + "' ... ";
                    bl52 = false;
                    System.out.println((Object)it);
                }
                PactBrokerClient pactBrokerClient = this.brokerClient;
                Intrinsics.checkNotNull((Object)pactBrokerClient);
                Result result = pactBrokerClient.uploadPactFile(pactFile, publishConfiguration);
                if (result instanceof Ok) {
                    String bl52 = "OK";
                    boolean bl7 = false;
                    System.out.println((Object)bl52);
                    continue;
                }
                if (!(result instanceof Err)) continue;
                Exception error = (Exception)((Err)result).getError();
                Object object2 = "Failed - " + ((Exception)((Err)result).getError()).getMessage();
                boolean bl8 = false;
                System.out.println(object2);
                if (error instanceof RequestFailedException && KotlinLanguageSupportKt.isNotEmpty((String)((RequestFailedException)error).getBody())) {
                    object2 = ((RequestFailedException)error).getBody();
                    bl8 = false;
                    System.out.println(object2);
                }
                anyFailed = true;
            }
            if (anyFailed) {
                throw new MojoExecutionException("One or more of the pact files were rejected by the pact broker");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> calculateTags() {
        List list;
        String property = System.getProperty("pact.consumer.tags");
        if (KotlinLanguageSupportKt.isNotEmpty((String)property)) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
            char[] cArray = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)property, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                boolean bl2 = false;
                void v0 = var11_11;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                collection.add(string2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.tags;
        }
        return list;
    }

    private final boolean pactFileIsExcluded(List<Regex> exclusions, File pactFile) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = exclusions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)FilesKt.getNameWithoutExtension((File)pactFile))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

