/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.filter;

import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import java.util.Arrays;
import java.util.function.Predicate;

public interface InteractionFilter<I extends Interaction> {
    public Predicate<I> buildPredicate(String[] var1);

    public static class ByRequestPath<I extends Interaction>
    implements InteractionFilter<I> {
        @Override
        public Predicate<I> buildPredicate(String[] values) {
            return interaction -> {
                if (interaction instanceof RequestResponseInteraction) {
                    return Arrays.stream(values).anyMatch(value -> ((RequestResponseInteraction)interaction).getRequest().getPath().matches((String)value));
                }
                return false;
            };
        }
    }

    public static class ByProviderState<I extends Interaction>
    implements InteractionFilter<I> {
        @Override
        public Predicate<I> buildPredicate(String[] values) {
            return interaction -> Arrays.stream(values).anyMatch(value -> interaction.getProviderStates().stream().anyMatch(state -> state.getName() != null && state.getName().matches((String)value)));
        }
    }
}

