/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.loader;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactBrokerSource;
import au.com.dius.pact.core.model.PactReader;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.ConsumerVersionSelector;
import au.com.dius.pact.core.pactbroker.IPactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerResult;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.expressions.DataType;
import au.com.dius.pact.core.support.expressions.ExpressionParser;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.junitsupport.loader.NoPactsFoundException;
import au.com.dius.pact.provider.junitsupport.loader.OverrideablePactLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactBroker;
import au.com.dius.pact.provider.junitsupport.loader.PactBrokerAuth;
import au.com.dius.pact.provider.junitsupport.loader.PactBrokerLoader;
import au.com.dius.pact.provider.junitsupport.loader.VersionSelector;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import mu.KLogging;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 W2\u00020\u0001:\u0001WB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u00a5\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010<\u001a\u00020=2\u0006\u00107\u001a\u00020\u0014H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\n2\u0006\u00107\u001a\u00020\u0014H\u0002J\b\u0010@\u001a\u00020\u0006H\u0016J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u00107\u001a\u00020\u0014H\u0002J\n\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0018\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u00062\u0006\u0010H\u001a\u00020IH\u0002J\u001a\u0010J\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030K0\n2\u0006\u0010G\u001a\u00020\u0006H\u0016J0\u0010L\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030K0\n2\u0006\u0010G\u001a\u00020\u00062\f\u0010M\u001a\b\u0012\u0004\u0012\u00020?0\n2\u0006\u00107\u001a\u00020\u0014H\u0002J\u0018\u0010N\u001a\u00020I2\u0006\u0010O\u001a\u00020P2\u0006\u00107\u001a\u00020\u0014H\u0016J\u0018\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u0006H\u0016J\u0010\u0010U\u001a\u00020R2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010V\u001a\u00020\u0014H\u0002R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001fR\u0010\u0010%\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010(R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001fR$\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b-\u0010.\u001a\u0004\b/\u0010(R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010(R\u0010\u00107\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u00a8\u0006X"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerLoader;", "Lau/com/dius/pact/provider/junitsupport/loader/OverrideablePactLoader;", "pactBroker", "Lau/com/dius/pact/provider/junitsupport/loader/PactBroker;", "(Lau/com/dius/pact/provider/junitsupport/loader/PactBroker;)V", "pactBrokerHost", "", "pactBrokerPort", "pactBrokerScheme", "pactBrokerTags", "", "pactBrokerConsumerVersionSelectors", "Lau/com/dius/pact/provider/junitsupport/loader/VersionSelector;", "pactBrokerConsumers", "failIfNoPactsFound", "", "authentication", "Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;", "valueResolverClass", "Lkotlin/reflect/KClass;", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "valueResolver", "enablePendingPacts", "providerTags", "includeWipPactsSince", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;Lkotlin/reflect/KClass;Lau/com/dius/pact/core/support/expressions/ValueResolver;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getAuthentication", "()Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;", "setAuthentication", "(Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;)V", "getEnablePendingPacts", "()Ljava/lang/String;", "getFailIfNoPactsFound", "()Z", "setFailIfNoPactsFound", "(Z)V", "getIncludeWipPactsSince", "overriddenConsumer", "overriddenPactUrl", "getPactBrokerConsumerVersionSelectors", "()Ljava/util/List;", "getPactBrokerConsumers", "getPactBrokerHost", "getPactBrokerPort", "getPactBrokerScheme", "pactBrokerTags$annotations", "()V", "getPactBrokerTags", "pactReader", "Lau/com/dius/pact/core/model/PactReader;", "getPactReader", "()Lau/com/dius/pact/core/model/PactReader;", "setPactReader", "(Lau/com/dius/pact/core/model/PactReader;)V", "getProviderTags", "resolver", "getValueResolverClass", "()Lkotlin/reflect/KClass;", "setValueResolverClass", "(Lkotlin/reflect/KClass;)V", "brokerUrl", "Lorg/apache/http/client/utils/URIBuilder;", "buildConsumerVersionSelectors", "Lau/com/dius/pact/core/pactbroker/ConsumerVersionSelector;", "description", "getPactBrokerSource", "Lau/com/dius/pact/core/model/PactBrokerSource;", "Lau/com/dius/pact/core/model/Interaction;", "getPactSource", "Lau/com/dius/pact/core/model/PactSource;", "getUrlForProvider", "providerName", "pactBrokerClient", "Lau/com/dius/pact/core/pactbroker/IPactBrokerClient;", "load", "Lau/com/dius/pact/core/model/Pact;", "loadPactsForProvider", "selectors", "newPactBrokerClient", "url", "Ljava/net/URI;", "overridePactUrl", "", "pactUrl", "consumer", "setValueResolver", "setupValueResolver", "Companion", "provider"})
public class PactBrokerLoader
implements OverrideablePactLoader {
    private ValueResolver resolver;
    private String overriddenPactUrl;
    private String overriddenConsumer;
    @NotNull
    private PactReader pactReader;
    @NotNull
    private final String pactBrokerHost;
    @Nullable
    private final String pactBrokerPort;
    @NotNull
    private final String pactBrokerScheme;
    @Nullable
    private final List<String> pactBrokerTags;
    @NotNull
    private final List<VersionSelector> pactBrokerConsumerVersionSelectors;
    @NotNull
    private final List<String> pactBrokerConsumers;
    private boolean failIfNoPactsFound;
    @Nullable
    private PactBrokerAuth authentication;
    @Nullable
    private KClass<? extends ValueResolver> valueResolverClass;
    @NotNull
    private final String enablePendingPacts;
    @NotNull
    private final List<String> providerTags;
    @NotNull
    private final String includeWipPactsSince;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PactReader getPactReader() {
        return this.pactReader;
    }

    public final void setPactReader(@NotNull PactReader pactReader) {
        Intrinsics.checkParameterIsNotNull((Object)pactReader, (String)"<set-?>");
        this.pactReader = pactReader;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String description() {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        ValueResolver resolver = this.setupValueResolver();
        List<ConsumerVersionSelector> consumerVersionSelectors = this.buildConsumerVersionSelectors(resolver);
        Iterable $this$flatMap$iv = this.pactBrokerConsumers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List consumers = (List)destination$iv$iv;
        String source = this.getPactBrokerSource(resolver).description();
        Collection collection = consumerVersionSelectors;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            source = source + " consumerVersionSelectors=" + consumerVersionSelectors;
        }
        collection = consumers;
        bl = false;
        if (!collection.isEmpty()) {
            source = source + " consumers=" + consumers;
        }
        return source;
    }

    @Override
    public void overridePactUrl(@NotNull String pactUrl, @NotNull String consumer) {
        Intrinsics.checkParameterIsNotNull((Object)pactUrl, (String)"pactUrl");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        this.overriddenPactUrl = pactUrl;
        this.overriddenConsumer = consumer;
    }

    @NotNull
    public List<Pact<?>> load(@NotNull String providerName) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        ValueResolver resolver = this.setupValueResolver();
        if (KotlinLanguageSupportKt.isNotEmpty((String)this.overriddenPactUrl)) {
            URI brokerUri;
            URI uRI = brokerUri = this.brokerUrl(resolver).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"brokerUri");
            IPactBrokerClient pactBrokerClient = this.newPactBrokerClient(uRI, resolver);
            String string = this.overriddenPactUrl;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = brokerUri.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"brokerUri.toString()");
            BrokerUrlSource pactSource = new BrokerUrlSource(string, string2, null, pactBrokerClient.getOptions(), null, null, 52, null);
            pactSource.setEncodePath(false);
            list = CollectionsKt.listOf((Object)this.pactReader.loadPact((Object)pactSource, pactBrokerClient.getOptions()));
        } else {
            List list2;
            try {
                List<ConsumerVersionSelector> consumerVersionSelectors = this.buildConsumerVersionSelectors(resolver);
                list2 = this.loadPactsForProvider(providerName, consumerVersionSelectors, resolver);
            }
            catch (NoPactsFoundException e) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConsumerVersionSelector> buildConsumerVersionSelectors(ValueResolver resolver) {
        List list;
        if (this.pactBrokerConsumerVersionSelectors.isEmpty()) {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            List list2 = this.pactBrokerTags;
            boolean bl = false;
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv = list3;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                ConsumerVersionSelector consumerVersionSelector = new ConsumerVersionSelector(it, false, 2, null);
                collection.add(consumerVersionSelector);
            }
            list = (List)destination$iv$iv;
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.pactBrokerConsumerVersionSelectors;
            boolean $i$f$flatMap = false;
            Iterable $this$mapTo$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapIndexedTo$iv$iv;
                List latest;
                List list4;
                String string;
                Collection<String> collection;
                int n;
                List tags;
                VersionSelector it = (VersionSelector)element$iv$iv;
                boolean bl = false;
                List parsedTags = ExpressionParser.parseListExpression((String)it.tag(), (ValueResolver)resolver);
                List parsedLatest = ExpressionParser.parseListExpression((String)it.latest(), (ValueResolver)resolver);
                List list5 = tags = parsedTags.isEmpty() ? CollectionsKt.listOf((Object)"latest") : parsedTags;
                if (parsedLatest.isEmpty()) {
                    int n2 = tags.size();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    ArrayList<String> arrayList = new ArrayList<String>(n2);
                    boolean bl6 = false;
                    int n3 = 0;
                    n3 = 0;
                    int n4 = n2;
                    while (n3 < n4) {
                        int n5 = n3++;
                        n = 0;
                        int n6 = n5;
                        collection = arrayList;
                        boolean bl7 = false;
                        string = String.valueOf(true);
                        ((ArrayList)collection).add(string);
                    }
                    list4 = arrayList;
                } else {
                    list4 = latest = parsedLatest;
                }
                if (tags.size() != latest.size()) {
                    throw (Throwable)new IllegalArgumentException("Invalid Consumer version selectors. Each version selector must have a tag and latest property");
                }
                Iterable $this$mapIndexed$iv = tags;
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    boolean bl8;
                    void tag;
                    void index;
                    n = index$iv$iv++;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl9 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n7 = n;
                    String string2 = (String)item$iv$iv;
                    int n8 = n7;
                    collection = collection2;
                    boolean bl10 = false;
                    String string3 = (String)latest.get((int)index);
                    void var33_49 = tag;
                    boolean bl11 = false;
                    boolean bl12 = bl8 = Boolean.parseBoolean(string3);
                    void var41_53 = var33_49;
                    string = new ConsumerVersionSelector((String)var41_53, bl12);
                    collection.add(string);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final ValueResolver setupValueResolver() {
        ValueResolver valueResolver = (ValueResolver)new SystemPropertyResolver();
        if (this.resolver != null) {
            ValueResolver valueResolver2 = this.resolver;
            if (valueResolver2 == null) {
                Intrinsics.throwNpe();
            }
            valueResolver = valueResolver2;
        } else if (this.valueResolverClass != null) {
            try {
                KClass<? extends ValueResolver> kClass = this.valueResolverClass;
                if (kClass == null) {
                    Intrinsics.throwNpe();
                }
                Object t = JvmClassMappingKt.getJavaClass(kClass).newInstance();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"valueResolverClass!!.java.newInstance()");
                valueResolver = (ValueResolver)t;
            }
            catch (InstantiationException e) {
                Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.1.INSTANCE);
            }
            catch (IllegalAccessException e) {
                Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.2.INSTANCE);
            }
        }
        return valueResolver;
    }

    @Override
    @Nullable
    public PactSource getPactSource() {
        ValueResolver resolver = this.setupValueResolver();
        return (PactSource)this.getPactBrokerSource(resolver);
    }

    @Override
    public void setValueResolver(@NotNull ValueResolver valueResolver) {
        Intrinsics.checkParameterIsNotNull((Object)valueResolver, (String)"valueResolver");
        this.resolver = valueResolver;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pact<?>> loadPactsForProvider(String providerName, List<ConsumerVersionSelector> selectors, ValueResolver resolver) throws IOException, IllegalArgumentException {
        String string;
        Iterator $this$filterTo$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Companion.getLogger().debug((Function0)new Function0<String>(providerName, selectors){
            final /* synthetic */ String $providerName;
            final /* synthetic */ List $selectors;

            @NotNull
            public final String invoke() {
                return "Loading pacts from pact broker for provider " + this.$providerName + " and consumer version selectors " + this.$selectors;
            }
            {
                this.$providerName = string;
                this.$selectors = list;
                super(0);
            }
        });
        Object object = ExpressionParser.parseExpression((String)this.enablePendingPacts, (DataType)DataType.BOOLEAN, (ValueResolver)resolver);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean pending = (Boolean)object;
        Iterable $this$flatMap$iv = this.providerTags;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List providerTags = (List)destination$iv$iv;
        if (pending) {
            boolean bl;
            block20: {
                Iterable $this$none$iv = providerTags;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it2 = (String)element$iv;
                        boolean bl2 = false;
                        if (!KotlinLanguageSupportKt.isNotEmpty((String)it2)) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw (Throwable)new IllegalArgumentException("Pending pacts feature has been enabled, but no provider tags have been specified. To use the pending pacts feature, you need to provide the list of provider names for the provider application version with the providerTags property that will be published with the verification results.");
            }
        }
        if (pending) {
            Object object2 = ExpressionParser.parseExpression((String)this.includeWipPactsSince, (DataType)DataType.STRING, (ValueResolver)resolver);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            string = (String)object2;
        } else {
            string = "";
        }
        String wipSinceDate = string;
        URIBuilder uriBuilder = this.brokerUrl(resolver);
        try {
            void $this$mapTo$iv$iv;
            URI uRI = uriBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uriBuilder.build()");
            IPactBrokerClient pactBrokerClient = this.newPactBrokerClient(uRI, resolver);
            Result result2 = pactBrokerClient.fetchConsumersWithSelectors(providerName, selectors, providerTags, pending, wipSinceDate);
            Object bl2 = result2;
            if (!(bl2 instanceof Ok)) {
                if (bl2 instanceof Err) {
                    throw (Throwable)((Err)result2).getError();
                }
                throw new NoWhenBranchMatchedException();
            }
            List consumers = (List)((Ok)result2).getValue();
            if (this.failIfNoPactsFound && consumers.isEmpty()) {
                throw (Throwable)new NoPactsFoundException("No consumer pacts were found for provider '" + providerName + "' and consumer " + "version selectors '" + selectors + "'. (URL " + this.getUrlForProvider(providerName, pactBrokerClient) + ")");
            }
            bl2 = this.pactBrokerConsumers;
            boolean element$iv$iv = false;
            if (!bl2.isEmpty()) {
                void $this$filterTo$iv$iv2;
                String it3;
                Iterable $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2 = this.pactBrokerConsumers;
                boolean $i$f$flatMap2 = false;
                Iterable bl = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                    it3 = (String)element$iv$iv2;
                    boolean bl3 = false;
                    Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it3, (ValueResolver)resolver);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List consumerInclusions = (List)destination$iv$iv2;
                Iterable $this$filter$iv2 = consumers;
                boolean $i$f$filter2 = false;
                $this$flatMapTo$iv$iv2 = $this$filter$iv2;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                    it3 = (PactBrokerResult)element$iv$iv2;
                    boolean bl4 = false;
                    if (!(consumerInclusions.isEmpty() || consumerInclusions.contains(it3.getName()))) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                consumers = (List)destination$iv$iv2;
            }
            Iterable $this$map$iv = consumers;
            boolean $i$f$map = false;
            Iterable $i$f$filter2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                Object element$iv$iv2;
                element$iv$iv2 = (PactBrokerResult)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                Pact pact2 = this.pactReader.loadPact((Object)it4, pactBrokerClient.getOptions());
                collection.add(pact2);
            }
            return (List)destination$iv$iv3;
        }
        catch (URISyntaxException e) {
            throw (Throwable)new IOException("Was not able load pacts from broker as the broker URL was invalid", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final URIBuilder brokerUrl(ValueResolver resolver) {
        void port;
        void host;
        PactBrokerSource<Interaction> pactBrokerSource = this.getPactBrokerSource(resolver);
        String string = pactBrokerSource.component1();
        String string2 = pactBrokerSource.component2();
        String scheme = pactBrokerSource.component3();
        URIBuilder uriBuilder = new URIBuilder().setScheme(scheme).setHost((String)host);
        if (KotlinLanguageSupportKt.isNotEmpty((String)port)) {
            URIBuilder uRIBuilder = uriBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRIBuilder, (String)"uriBuilder");
            uRIBuilder.setPort(Integer.parseInt((String)port));
        }
        URIBuilder uRIBuilder = uriBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRIBuilder, (String)"uriBuilder");
        return uRIBuilder;
    }

    private final PactBrokerSource<Interaction> getPactBrokerSource(ValueResolver resolver) {
        Object object = ExpressionParser.parseExpression((String)this.pactBrokerScheme, (DataType)DataType.RAW, (ValueResolver)resolver);
        String scheme = object != null ? object.toString() : null;
        Object object2 = ExpressionParser.parseExpression((String)this.pactBrokerHost, (DataType)DataType.RAW, (ValueResolver)resolver);
        String host = object2 != null ? object2.toString() : null;
        Object object3 = ExpressionParser.parseExpression((String)this.pactBrokerPort, (DataType)DataType.RAW, (ValueResolver)resolver);
        String port = object3 != null ? object3.toString() : null;
        CharSequence charSequence = host;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            String string;
            charSequence = StringCompanionObject.INSTANCE;
            String string2 = "Invalid pact broker host specified ('%s'). Please provide a valid host or specify the system property 'pactbroker.host'.";
            Object[] objectArray = new Object[]{this.pactBrokerHost};
            boolean bl3 = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string = string3;
            throw (Throwable)new IllegalArgumentException(string4);
        }
        if (KotlinLanguageSupportKt.isNotEmpty((String)port)) {
            String string = port;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            charSequence = string;
            Object object4 = new Regex("^[0-9]+");
            bl2 = false;
            if (!object4.matches(charSequence)) {
                String string5;
                charSequence = StringCompanionObject.INSTANCE;
                object4 = "Invalid pact broker port specified ('%s'). Please provide a valid port number or specify the system property 'pactbroker.port'.";
                Object[] objectArray = new Object[]{this.pactBrokerPort};
                boolean bl4 = false;
                String string6 = String.format((String)object4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
                String string7 = string5 = string6;
                throw (Throwable)new IllegalArgumentException(string7);
            }
        }
        return scheme == null ? new PactBrokerSource(host, port, null, null, 12, null) : new PactBrokerSource(host, port, scheme, null, 8, null);
    }

    private final String getUrlForProvider(String providerName, IPactBrokerClient pactBrokerClient) {
        String string;
        try {
            String string2 = pactBrokerClient.getUrlForProvider(providerName, "");
            if (string2 == null) {
                string2 = "Unknown";
            }
            string = string2;
        }
        catch (Exception e) {
            Companion.getLogger().debug((Throwable)e, (Function0)getUrlForProvider.1.INSTANCE);
            string = "Unknown";
        }
        return string;
    }

    @NotNull
    public IPactBrokerClient newPactBrokerClient(@NotNull URI url, @NotNull ValueResolver resolver) {
        String token;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        if (this.authentication == null) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.1.INSTANCE);
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return (IPactBrokerClient)new PactBrokerClient(string, MapsKt.emptyMap());
        }
        PactBrokerAuth pactBrokerAuth = this.authentication;
        if (pactBrokerAuth == null) {
            Intrinsics.throwNpe();
        }
        Object object = ExpressionParser.parseExpression((String)pactBrokerAuth.username(), (DataType)DataType.RAW, (ValueResolver)resolver);
        String username = object != null ? object.toString() : null;
        PactBrokerAuth pactBrokerAuth2 = this.authentication;
        if (pactBrokerAuth2 == null) {
            Intrinsics.throwNpe();
        }
        Object object2 = ExpressionParser.parseExpression((String)pactBrokerAuth2.token(), (DataType)DataType.RAW, (ValueResolver)resolver);
        String string = token = object2 != null ? object2.toString() : null;
        if (KotlinLanguageSupportKt.isNotEmpty((String)username)) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.2.INSTANCE);
            Object[] objectArray = new Object[3];
            objectArray[0] = "basic";
            objectArray[1] = username;
            PactBrokerAuth pactBrokerAuth3 = this.authentication;
            if (pactBrokerAuth3 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[2] = ExpressionParser.parseExpression((String)pactBrokerAuth3.password(), (DataType)DataType.RAW, (ValueResolver)resolver);
            Map options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])objectArray)));
            String string2 = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.toString()");
            return (IPactBrokerClient)new PactBrokerClient(string2, options);
        }
        if (KotlinLanguageSupportKt.isNotEmpty((String)token)) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.3.INSTANCE);
            Map options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])new String[]{"bearer", token})));
            String string3 = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"url.toString()");
            return (IPactBrokerClient)new PactBrokerClient(string3, options);
        }
        Companion.getLogger().debug((Function0)newPactBrokerClient.4.INSTANCE);
        String string4 = url.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"url.toString()");
        return (IPactBrokerClient)new PactBrokerClient(string4, MapsKt.emptyMap());
    }

    @NotNull
    public final String getPactBrokerHost() {
        return this.pactBrokerHost;
    }

    @Nullable
    public final String getPactBrokerPort() {
        return this.pactBrokerPort;
    }

    @NotNull
    public final String getPactBrokerScheme() {
        return this.pactBrokerScheme;
    }

    @Deprecated(message="Use Consumer version selectors instead", replaceWith=@ReplaceWith(imports={}, expression="pactBrokerConsumerVersionSelectors"))
    public static /* synthetic */ void pactBrokerTags$annotations() {
    }

    @Nullable
    public final List<String> getPactBrokerTags() {
        return this.pactBrokerTags;
    }

    @NotNull
    public final List<VersionSelector> getPactBrokerConsumerVersionSelectors() {
        return this.pactBrokerConsumerVersionSelectors;
    }

    @NotNull
    public final List<String> getPactBrokerConsumers() {
        return this.pactBrokerConsumers;
    }

    public final boolean getFailIfNoPactsFound() {
        return this.failIfNoPactsFound;
    }

    public final void setFailIfNoPactsFound(boolean bl) {
        this.failIfNoPactsFound = bl;
    }

    @Nullable
    public final PactBrokerAuth getAuthentication() {
        return this.authentication;
    }

    public final void setAuthentication(@Nullable PactBrokerAuth pactBrokerAuth) {
        this.authentication = pactBrokerAuth;
    }

    @Nullable
    public final KClass<? extends ValueResolver> getValueResolverClass() {
        return this.valueResolverClass;
    }

    public final void setValueResolverClass(@Nullable KClass<? extends ValueResolver> kClass) {
        this.valueResolverClass = kClass;
    }

    @NotNull
    public final String getEnablePendingPacts() {
        return this.enablePendingPacts;
    }

    @NotNull
    public final List<String> getProviderTags() {
        return this.providerTags;
    }

    @NotNull
    public final String getIncludeWipPactsSince() {
        return this.includeWipPactsSince;
    }

    public PactBrokerLoader(@NotNull String pactBrokerHost, @Nullable String pactBrokerPort, @NotNull String pactBrokerScheme, @Nullable List<String> pactBrokerTags, @NotNull List<VersionSelector> pactBrokerConsumerVersionSelectors, @NotNull List<String> pactBrokerConsumers, boolean failIfNoPactsFound, @Nullable PactBrokerAuth authentication, @Nullable KClass<? extends ValueResolver> valueResolverClass, @Nullable ValueResolver valueResolver, @NotNull String enablePendingPacts, @NotNull List<String> providerTags, @NotNull String includeWipPactsSince) {
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerHost, (String)"pactBrokerHost");
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerScheme, (String)"pactBrokerScheme");
        Intrinsics.checkParameterIsNotNull(pactBrokerConsumerVersionSelectors, (String)"pactBrokerConsumerVersionSelectors");
        Intrinsics.checkParameterIsNotNull(pactBrokerConsumers, (String)"pactBrokerConsumers");
        Intrinsics.checkParameterIsNotNull((Object)enablePendingPacts, (String)"enablePendingPacts");
        Intrinsics.checkParameterIsNotNull(providerTags, (String)"providerTags");
        Intrinsics.checkParameterIsNotNull((Object)includeWipPactsSince, (String)"includeWipPactsSince");
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerScheme = pactBrokerScheme;
        this.pactBrokerTags = pactBrokerTags;
        this.pactBrokerConsumerVersionSelectors = pactBrokerConsumerVersionSelectors;
        this.pactBrokerConsumers = pactBrokerConsumers;
        this.failIfNoPactsFound = failIfNoPactsFound;
        this.authentication = authentication;
        this.valueResolverClass = valueResolverClass;
        this.enablePendingPacts = enablePendingPacts;
        this.providerTags = providerTags;
        this.includeWipPactsSince = includeWipPactsSince;
        this.resolver = valueResolver;
        this.pactReader = (PactReader)DefaultPactReader.INSTANCE;
    }

    public /* synthetic */ PactBrokerLoader(String string, String string2, String string3, List list, List list2, List list3, boolean bl, PactBrokerAuth pactBrokerAuth, KClass kClass, ValueResolver valueResolver, String string4, List list4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)"latest");
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x200) != 0) {
            valueResolver = null;
        }
        if ((n & 0x400) != 0) {
            string4 = "false";
        }
        if ((n & 0x800) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x1000) != 0) {
            string5 = "";
        }
        this(string, string2, string3, list, list2, list3, bl, pactBrokerAuth, (KClass<? extends ValueResolver>)kClass, valueResolver, string4, list4, string5);
    }

    public PactBrokerLoader(@NotNull PactBroker pactBroker) {
        Intrinsics.checkParameterIsNotNull((Object)pactBroker, (String)"pactBroker");
        this(pactBroker.host(), pactBroker.port(), pactBroker.scheme(), ArraysKt.toList((Object[])pactBroker.tags()), ArraysKt.toList((Object[])pactBroker.consumerVersionSelectors()), ArraysKt.toList((Object[])pactBroker.consumers()), true, pactBroker.authentication(), (KClass<? extends ValueResolver>)Reflection.getOrCreateKotlinClass(pactBroker.valueResolver()), null, pactBroker.enablePendingPacts(), ArraysKt.toList((Object[])pactBroker.providerTags()), pactBroker.includeWipPactsSince());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerLoader$Companion;", "Lmu/KLogging;", "()V", "provider"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

