/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.provider.IHttpClientFactory;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.ProviderResponse;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.Closeable;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.collections4.Closure;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Function1;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J4\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0018\u0010(\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0002"}, d2={"Lau/com/dius/pact/provider/ProviderClient;", "", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "httpClientFactory", "Lau/com/dius/pact/provider/IHttpClientFactory;", "(Lau/com/dius/pact/provider/IProviderInfo;Lau/com/dius/pact/provider/IHttpClientFactory;)V", "getProvider", "()Lau/com/dius/pact/provider/IProviderInfo;", "executeRequest", "Lau/com/dius/pact/provider/ProviderResponse;", "httpclient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "method", "Lorg/apache/http/client/methods/HttpUriRequest;", "executeRequestFilter", "", "Lorg/apache/http/HttpRequest;", "getHttpClient", "handleResponse", "httpResponse", "Lorg/apache/http/HttpResponse;", "invokeJavaFunctionalInterface", "functionalInterface", "httpRequest", "makeRequest", "request", "Lau/com/dius/pact/core/model/Request;", "makeStateChangeRequest", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "stateChangeUrl", "state", "Lau/com/dius/pact/core/model/ProviderState;", "postStateInBody", "", "isSetup", "stateChangeTeardown", "newRequest", "prepareRequest", "setupBody", "setupHeaders", "systemPropertySet", "property", "", "Companion", "HttpDeleteWithEntity"})
public class ProviderClient {
    @NotNull
    private final IProviderInfo provider;
    private final IHttpClientFactory httpClientFactory;
    @NotNull
    public static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String UTF8 = "UTF-8";
    @NotNull
    public static final String REQUEST = "request";
    @NotNull
    public static final String ACTION = "action";
    @NotNull
    private static final Set<String> SINGLE_VALUE_HEADERS;
    public static final Companion Companion;

    @NotNull
    public ProviderResponse makeRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpUriRequest method = this.prepareRequest(request);
        return this.executeRequest(httpclient, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ProviderResponse executeRequest(@NotNull CloseableHttpClient httpclient, @NotNull HttpUriRequest method) {
        ProviderResponse providerResponse;
        Intrinsics.checkParameterIsNotNull((Object)httpclient, (String)"httpclient");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Closeable closeable = (Closeable)httpclient.execute(method);
        boolean bl = false;
        Throwable throwable = null;
        try {
            CloseableHttpResponse it = (CloseableHttpResponse)closeable;
            boolean bl2 = false;
            CloseableHttpResponse closeableHttpResponse = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
            providerResponse = this.handleResponse((HttpResponse)closeableHttpResponse);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return providerResponse;
    }

    @NotNull
    public HttpUriRequest prepareRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        Companion.getLogger().debug((Function0)new Function0<String>(this){
            final /* synthetic */ ProviderClient this$0;

            @NotNull
            public final String invoke() {
                return "Making request for provider " + this.this$0.getProvider() + ':';
            }
            {
                this.this$0 = providerClient;
                super(0);
            }
        });
        Companion.getLogger().debug((Function0)new Function0<String>(request){
            final /* synthetic */ Request $request;

            @NotNull
            public final String invoke() {
                return this.$request.toString();
            }
            {
                this.$request = request;
                super(0);
            }
        });
        HttpUriRequest method = this.newRequest(request);
        this.setupHeaders(request, (HttpRequest)method);
        this.setupBody(request, (HttpRequest)method);
        this.executeRequestFilter((HttpRequest)method);
        return method;
    }

    public void executeRequestFilter(@NotNull HttpRequest method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Object requestFilter = this.provider.getRequestFilter();
        if (requestFilter != null) {
            Object object = requestFilter;
            if (object instanceof groovy.lang.Closure) {
                ((groovy.lang.Closure)requestFilter).call((Object)method);
            } else if (object instanceof Function1) {
                ((Function1)requestFilter).apply((Object)method);
            } else if (object instanceof Closure) {
                ((Closure)requestFilter).execute((Object)method);
            } else if (Companion.isFunctionalInterface(requestFilter)) {
                this.invokeJavaFunctionalInterface(requestFilter, method);
            } else {
                Binding binding = new Binding();
                binding.setVariable(REQUEST, (Object)method);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate((String)requestFilter);
            }
        }
    }

    private final void invokeJavaFunctionalInterface(Object functionalInterface, HttpRequest httpRequest) {
        Object object = functionalInterface;
        if (object instanceof Consumer) {
            Object object2 = functionalInterface;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.function.Consumer<org.apache.http.HttpRequest>");
            }
            ((Consumer)object2).accept(httpRequest);
        } else if (object instanceof Function) {
            Object object3 = functionalInterface;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.function.Function<org.apache.http.HttpRequest, kotlin.Any?>");
            }
            ((Function)object3).apply(httpRequest);
        } else if (object instanceof Callable) {
            Object object4 = functionalInterface;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.Callable<org.apache.http.HttpRequest>");
            }
            ((Callable)object4).call();
        } else {
            throw (Throwable)new IllegalArgumentException("Java request filters must be either a Consumer or Function that takes at least one HttpRequest parameter");
        }
    }

    public void setupBody(@NotNull Request request, @NotNull HttpRequest method) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (method instanceof HttpEntityEnclosingRequest && request.getBody().isPresent()) {
            String contentTypeHeader = request.contentTypeHeader();
            if (contentTypeHeader != null) {
                try {
                    org.apache.http.entity.ContentType contentType = org.apache.http.entity.ContentType.parse((String)contentTypeHeader);
                    ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)new StringEntity(request.getBody().valueAsString(), contentType));
                }
                catch (UnsupportedCharsetException e) {
                    ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)new StringEntity(request.getBody().valueAsString()));
                }
            } else {
                ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)new StringEntity(request.getBody().valueAsString()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setupHeaders(@NotNull Request request, @NotNull HttpRequest method) {
        Map headers;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Map map = headers = request.getHeaders();
        boolean bl = false;
        if (!map.isEmpty()) {
            Map $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl3 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl4 = false;
                String string = (String)entry.getKey();
                entry = $dstr$key$value;
                bl4 = false;
                List value = (List)entry.getValue();
                method.addHeader((String)key, CollectionsKt.joinToString$default((Iterable)value, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (!method.containsHeader(CONTENT_TYPE) && request.getBody().isPresent()) {
            ContentType contentType = request.getBody().getContentType();
            String contentType2 = Intrinsics.areEqual((Object)contentType, (Object)ContentType.Companion.getUNKNOWN()) ? "text/plain; charset=ISO-8859-1" : request.getBody().getContentType().toString();
            method.addHeader(CONTENT_TYPE, contentType2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CloseableHttpResponse makeStateChangeRequest(@Nullable Object stateChangeUrl, @NotNull ProviderState state, boolean postStateInBody, boolean isSetup, boolean stateChangeTeardown) {
        CloseableHttpResponse closeableHttpResponse;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (stateChangeUrl != null) {
            CloseableHttpClient httpclient = this.getHttpClient();
            URIBuilder urlBuilder = stateChangeUrl instanceof URI ? new URIBuilder((URI)stateChangeUrl) : new URIBuilder(stateChangeUrl.toString());
            HttpPost method = null;
            if (postStateInBody) {
                method = new HttpPost(urlBuilder.build());
                Map map = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"state", (Object)String.valueOf(state.getName()))});
                Map map2 = state.getParams();
                boolean bl = false;
                if (!map2.isEmpty()) {
                    map.put("params", state.getParams());
                }
                if (stateChangeTeardown) {
                    map.put(ACTION, isSetup ? "setup" : "teardown");
                }
                method.setEntity((HttpEntity)new StringEntity(Json.INSTANCE.prettyPrint((Object)map), org.apache.http.entity.ContentType.APPLICATION_JSON));
            } else {
                urlBuilder.setParameter("state", state.getName());
                Map $this$forEach$iv = state.getParams();
                boolean $i$f$forEach = false;
                Map map = $this$forEach$iv;
                boolean bl = false;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    void k;
                    Map.Entry element$iv;
                    Map.Entry $dstr$k$v = element$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry entry = $dstr$k$v;
                    boolean bl3 = false;
                    String string = (String)entry.getKey();
                    entry = $dstr$k$v;
                    bl3 = false;
                    Object v = entry.getValue();
                    urlBuilder.setParameter((String)k, String.valueOf(v));
                }
                if (stateChangeTeardown) {
                    if (isSetup) {
                        urlBuilder.setParameter(ACTION, "setup");
                    } else {
                        urlBuilder.setParameter(ACTION, "teardown");
                    }
                }
                method = new HttpPost(urlBuilder.build());
            }
            if (this.provider.getStateChangeRequestFilter() != null) {
                Object object = this.provider.getStateChangeRequestFilter();
                if (object instanceof groovy.lang.Closure) {
                    Object object2 = this.provider.getStateChangeRequestFilter();
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type groovy.lang.Closure<*>");
                    }
                    ((groovy.lang.Closure)object2).call((Object)method);
                } else if (object instanceof Function1) {
                    Object object3 = this.provider.getStateChangeRequestFilter();
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type scala.Function1<kotlin.Any, kotlin.Any>");
                    }
                    ((Function1)object3).apply((Object)method);
                } else {
                    Binding binding = new Binding();
                    binding.setVariable(REQUEST, (Object)method);
                    GroovyShell shell = new GroovyShell(binding);
                    shell.evaluate(String.valueOf(this.provider.getStateChangeRequestFilter()));
                }
            }
            closeableHttpResponse = httpclient.execute((HttpUriRequest)method);
        } else {
            closeableHttpResponse = null;
        }
        return closeableHttpResponse;
    }

    @NotNull
    public final CloseableHttpClient getHttpClient() {
        return this.httpClientFactory.newClient(this.provider);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProviderResponse handleResponse(@NotNull HttpResponse httpResponse) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object object2;
        Object list$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)httpResponse, (String)"httpResponse");
        Companion.getLogger().debug((Function0)new Function0<String>(httpResponse){
            final /* synthetic */ HttpResponse $httpResponse;

            @NotNull
            public final String invoke() {
                return "Received response: " + this.$httpResponse.getStatusLine();
            }
            {
                this.$httpResponse = httpResponse;
                super(0);
            }
        });
        ContentType contentType = ContentType.Companion.getTEXT_PLAIN();
        Header[] headerArray = httpResponse.getAllHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)headerArray, (String)"httpResponse.allHeaders");
        Header[] $this$groupBy$iv = headerArray;
        boolean $i$f$groupBy = false;
        Header[] headerArray2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        void var9_9 = $this$groupByTo$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            List list;
            String string;
            String string2;
            void header;
            Object object3;
            void element$iv$iv;
            void header2 = element$iv$iv = var9_9[i];
            boolean $i$a$-groupBy-ProviderClient$handleResponse$headers$32 = false;
            void v1 = header2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"header");
            String key$iv$iv = v1.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            void $i$a$-groupBy-ProviderClient$handleResponse$headers$32 = element$iv$iv;
            object2 = list$iv$iv;
            boolean bl = false;
            void v3 = header;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"header");
            Intrinsics.checkExpressionValueIsNotNull((Object)v3.getName(), (String)"header.name");
            Collection<String> collection = SINGLE_VALUE_HEADERS;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            if (collection.contains(string)) {
                String string4 = header.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"header.value");
                string2 = string4;
                bl2 = false;
                String string5 = string2;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                list = CollectionsKt.listOf((Object)((Object)StringsKt.trim((CharSequence)string5)).toString());
            } else {
                void $this$mapTo$iv$iv;
                String string6 = header.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"header.value");
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)string6, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string7 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    void var32_38 = it;
                    boolean bl4 = false;
                    void v9 = var32_38;
                    if (v9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = ((Object)StringsKt.trim((CharSequence)((CharSequence)v9))).toString();
                    collection.add(string);
                }
                list = (List)destination$iv$iv2;
            }
            object = list;
            object2.add(object);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            list$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry $i$f$getOrPut = (Map.Entry)element$iv$iv$iv;
            object = k;
            object2 = map;
            boolean bl5 = false;
            List list = CollectionsKt.flatten((Iterable)((Iterable)it.getValue()));
            object2.put(object, list);
        }
        Map headers = destination$iv$iv;
        String body = null;
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            if (entity.getContentType() != null) {
                Header header = entity.getContentType();
                Intrinsics.checkExpressionValueIsNotNull((Object)header, (String)"entity.contentType");
                contentType = ContentType.Companion.fromString(header.getValue());
            }
            body = EntityUtils.toString((HttpEntity)entity, (Charset)contentType.asCharset());
        }
        StatusLine statusLine = httpResponse.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"httpResponse.statusLine");
        ProviderResponse response = new ProviderResponse(statusLine.getStatusCode(), headers, contentType, body);
        Companion.getLogger().debug((Function0)new Function0<String>(response){
            final /* synthetic */ ProviderResponse $response;

            @NotNull
            public final String invoke() {
                return "Response: " + this.$response;
            }
            {
                this.$response = providerResponse;
                super(0);
            }
        });
        return response;
    }

    @NotNull
    public HttpUriRequest newRequest(@NotNull Request request) {
        HttpUriRequest httpUriRequest;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        String scheme = this.provider.getProtocol();
        Object host = ProviderClient.Companion.invokeIfClosure(this.provider.getHost());
        int port = ProviderClient.Companion.convertToInteger(ProviderClient.Companion.invokeIfClosure(this.provider.getPort()));
        String path = ProviderClient.Companion.stripTrailingSlash(this.provider.getPath());
        URIBuilder urlBuilder = new URIBuilder();
        if (this.systemPropertySet("pact.verifier.disableUrlPathDecoding")) {
            path = path + request.getPath();
            urlBuilder = new URIBuilder(scheme + "://" + host + ':' + port + path);
        } else {
            path = path + URLDecoder.decode(request.getPath(), UTF8);
            urlBuilder.setScheme(this.provider.getProtocol());
            Object object = ProviderClient.Companion.invokeIfClosure(this.provider.getHost());
            urlBuilder.setHost(object != null ? object.toString() : null);
            urlBuilder.setPort(ProviderClient.Companion.convertToInteger(ProviderClient.Companion.invokeIfClosure(this.provider.getPort())));
            urlBuilder.setPath(path);
        }
        if (request.getQuery() != null) {
            Map $this$forEach$iv = request.getQuery();
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = (Iterable)entry.getValue();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it = (String)element$iv2;
                    boolean bl3 = false;
                    urlBuilder.addParameter((String)entry.getKey(), it);
                }
            }
        }
        String string = urlBuilder.build().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"urlBuilder.build().toString()");
        String url = string;
        String string2 = request.getMethod();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        switch (string4) {
            case "post": {
                httpUriRequest = (HttpUriRequest)new HttpPost(url);
                break;
            }
            case "put": {
                httpUriRequest = (HttpUriRequest)new HttpPut(url);
                break;
            }
            case "options": {
                httpUriRequest = (HttpUriRequest)new HttpOptions(url);
                break;
            }
            case "delete": {
                httpUriRequest = (HttpUriRequest)new HttpDeleteWithEntity(url);
                break;
            }
            case "head": {
                httpUriRequest = (HttpUriRequest)new HttpHead(url);
                break;
            }
            case "patch": {
                httpUriRequest = (HttpUriRequest)new HttpPatch(url);
                break;
            }
            case "trace": {
                httpUriRequest = (HttpUriRequest)new HttpTrace(url);
                break;
            }
            default: {
                httpUriRequest = (HttpUriRequest)new HttpGet(url);
            }
        }
        return httpUriRequest;
    }

    public boolean systemPropertySet(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return Boolean.getBoolean(property);
    }

    @NotNull
    public final IProviderInfo getProvider() {
        return this.provider;
    }

    public ProviderClient(@NotNull IProviderInfo provider, @NotNull IHttpClientFactory httpClientFactory) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)httpClientFactory, (String)"httpClientFactory");
        this.provider = provider;
        this.httpClientFactory = httpClientFactory;
    }

    static {
        Companion = new Companion(null);
        SINGLE_VALUE_HEADERS = SetsKt.setOf((Object[])new String[]{"set-cookie", "www-authenticate", "proxy-authenticate", "date", "expires", "last-modified", "if-modified-since", "if-unmodified-since", "retry-after"});
    }

    @JvmStatic
    public static final boolean urlEncodedFormPost(@NotNull Request request) {
        return Companion.urlEncodedFormPost(request);
    }

    @JvmStatic
    private static final String stripTrailingSlash(String basePath) {
        return ProviderClient.Companion.stripTrailingSlash(basePath);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lau/com/dius/pact/provider/ProviderClient$HttpDeleteWithEntity;", "Lorg/apache/http/client/methods/HttpEntityEnclosingRequestBase;", "uri", "", "(Ljava/lang/String;)V", "getMethod", "provider"})
    public static final class HttpDeleteWithEntity
    extends HttpEntityEnclosingRequestBase {
        @NotNull
        public String getMethod() {
            return "DELETE";
        }

        public HttpDeleteWithEntity(@NotNull String uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            this.setURI(URI.create(uri));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0003J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lau/com/dius/pact/provider/ProviderClient$Companion;", "Lmu/KLogging;", "()V", "ACTION", "", "CONTENT_TYPE", "REQUEST", "SINGLE_VALUE_HEADERS", "", "getSINGLE_VALUE_HEADERS", "()Ljava/util/Set;", "UTF8", "convertToInteger", "", "port", "", "invokeIfClosure", "property", "isFunctionalInterface", "", "requestFilter", "stripTrailingSlash", "basePath", "urlEncodedFormPost", "request", "Lau/com/dius/pact/core/model/Request;", "provider"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final Set<String> getSINGLE_VALUE_HEADERS() {
            return SINGLE_VALUE_HEADERS;
        }

        private final Object invokeIfClosure(Object property) {
            return property instanceof groovy.lang.Closure ? ((groovy.lang.Closure)property).call() : property;
        }

        private final int convertToInteger(Object port) {
            return port instanceof Number ? ((Number)port).intValue() : Integer.parseInt(String.valueOf(port));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean urlEncodedFormPost(@NotNull Request request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)ProviderClient.REQUEST);
            String string = request.getMethod();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            if (!Intrinsics.areEqual((Object)string3, (Object)"post")) return false;
            String string4 = request.contentType();
            org.apache.http.entity.ContentType contentType = org.apache.http.entity.ContentType.APPLICATION_FORM_URLENCODED;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType, (String)"ContentType.APPLICATION_FORM_URLENCODED");
            if (!Intrinsics.areEqual((Object)string4, (Object)contentType.getMimeType())) return false;
            return true;
        }

        public final boolean isFunctionalInterface(@NotNull Object requestFilter) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)requestFilter, (String)"requestFilter");
                Class<?>[] classArray = requestFilter.getClass().getInterfaces();
                Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"requestFilter::class.java.interfaces");
                Class<?>[] $this$any$iv = classArray;
                boolean $i$f$any = false;
                Class<?>[] classArray2 = $this$any$iv;
                int n = classArray2.length;
                for (int i = 0; i < n; ++i) {
                    Class<?> element$iv;
                    Class<?> it = element$iv = classArray2[i];
                    boolean bl2 = false;
                    if (!it.isAnnotationPresent(FunctionalInterface.class)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        private final String stripTrailingSlash(String basePath) {
            String string;
            if (Intrinsics.areEqual((Object)basePath, (Object)"/")) {
                string = "";
            } else {
                CharSequence charSequence = basePath;
                int n = 0;
                if (charSequence.length() > 0 && StringsKt.last((CharSequence)basePath) == '/') {
                    charSequence = basePath;
                    n = 0;
                    int n2 = basePath.length() - 1;
                    boolean bl = false;
                    CharSequence charSequence2 = charSequence;
                    if (charSequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = ((String)charSequence2).substring(n, n2);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = basePath;
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

