/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.junit;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.ConsumerPactRunnerKt;
import au.com.dius.pact.consumer.MockServer;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithoutPath;
import au.com.dius.pact.consumer.dsl.PactDslResponse;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.junit.DefaultRequestValues;
import au.com.dius.pact.consumer.junit.DefaultResponseValues;
import au.com.dius.pact.consumer.junit.JUnitTestSupport;
import au.com.dius.pact.consumer.junit.PactVerification;
import au.com.dius.pact.consumer.junit.PactVerifications;
import au.com.dius.pact.consumer.model.MockProviderConfig;
import au.com.dius.pact.consumer.model.MockServerImplementation;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.model.annotations.Pact;
import au.com.dius.pact.core.model.annotations.PactDirectory;
import au.com.dius.pact.core.model.annotations.PactFolder;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.MetricEvent;
import au.com.dius.pact.core.support.Metrics;
import au.com.dius.pact.core.support.expressions.DataType;
import au.com.dius.pact.core.support.expressions.ExpressionParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BaseProviderRule
extends ExternalResource {
    protected final String provider;
    protected final Object target;
    protected MockProviderConfig config;
    private Map<String, BasePact> pacts;
    private MockServer mockServer;
    private final ExpressionParser ep;

    public BaseProviderRule(Object target, String provider, String hostInterface, Integer port, PactSpecVersion pactVersion) {
        this.target = target;
        this.provider = provider;
        this.config = MockProviderConfig.httpConfig((String)(StringUtils.isEmpty((CharSequence)hostInterface) ? "127.0.0.1" : hostInterface), (int)(port == null ? 0 : port), (PactSpecVersion)pactVersion, (MockServerImplementation)MockServerImplementation.Default);
        this.ep = new ExpressionParser();
    }

    public MockProviderConfig getConfig() {
        return this.config;
    }

    public MockServer getMockServer() {
        return this.mockServer;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerifications pactVerifications = (PactVerifications)description.getAnnotation(PactVerifications.class);
                if (pactVerifications != null) {
                    BaseProviderRule.this.evaluatePactVerifications(pactVerifications, base);
                    return;
                }
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                Map<String, BasePact> pacts = BaseProviderRule.this.getPacts(pactDef.fragment());
                Optional<BasePact> pact = pactDef.value().length == 1 && StringUtils.isEmpty((CharSequence)pactDef.value()[0]) ? pacts.values().stream().findFirst() : Arrays.stream(pactDef.value()).map(pacts::get).filter(Objects::nonNull).findFirst();
                if (pact.isEmpty()) {
                    base.evaluate();
                    return;
                }
                if (BaseProviderRule.this.config.getPactVersion() == PactSpecVersion.V4) {
                    ((V4Pact)pact.get().asV4Pact().component1()).getInteractions().forEach(i -> i.getComments().put("testname", Json.toJson((Object)description.getDisplayName())));
                }
                PactFolder pactFolder = BaseProviderRule.this.target.getClass().getAnnotation(PactFolder.class);
                PactDirectory pactDirectory = BaseProviderRule.this.target.getClass().getAnnotation(PactDirectory.class);
                BasePact basePact = pact.get();
                Metrics.INSTANCE.sendMetrics((MetricEvent)new MetricEvent.ConsumerTestRun(basePact.getInteractions().size(), "junit"));
                PactVerificationResult result = BaseProviderRule.this.runPactTest(base, basePact, pactFolder, pactDirectory);
                BaseProviderRule.this.validateResult(result, pactDef);
            }
        };
    }

    private void evaluatePactVerifications(PactVerifications pactVerifications, Statement base) throws Throwable {
        List<PactVerification> possiblePactVerifications = this.findPactVerifications(pactVerifications, this.provider);
        if (possiblePactVerifications.isEmpty()) {
            base.evaluate();
            return;
        }
        BasePact[] pact = new BasePact[]{null};
        possiblePactVerifications.forEach(pactVerification -> {
            Optional<Method> possiblePactMethod = this.findPactMethod((PactVerification)pactVerification);
            if (possiblePactMethod.isEmpty()) {
                throw new UnsupportedOperationException("Could not find method with @Pact for the provider " + this.provider);
            }
            Method method = possiblePactMethod.get();
            Pact pactAnnotation = method.getAnnotation(Pact.class);
            PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)this.ep.parseExpression(pactAnnotation.consumer(), DataType.RAW).toString()).pactSpecVersion(this.config.getPactVersion()).hasPactWith(this.provider);
            this.updateAnyDefaultValues(dslBuilder);
            try {
                BasePact pactFromMethod = (BasePact)method.invoke(this.target, dslBuilder);
                if (pact[0] == null) {
                    pact[0] = pactFromMethod;
                } else {
                    pact[0].mergeInteractions(pactFromMethod.getInteractions());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke pact method", e);
            }
        });
        PactFolder pactFolder = this.target.getClass().getAnnotation(PactFolder.class);
        PactDirectory pactDirectory = this.target.getClass().getAnnotation(PactDirectory.class);
        PactVerificationResult result = this.runPactTest(base, pact[0], pactFolder, pactDirectory);
        JUnitTestSupport.validateMockServerResult((PactVerificationResult)result);
    }

    private List<PactVerification> findPactVerifications(PactVerifications pactVerifications, String providerName) {
        PactVerification[] pactVerificationValues = pactVerifications.value();
        return Arrays.stream(pactVerificationValues).filter(p -> {
            String[] providers = p.value();
            if (providers.length != 1) {
                throw new IllegalArgumentException("Each @PactVerification must specify one and only provider when using @PactVerifications");
            }
            String provider = providers[0];
            return StringUtils.equals((CharSequence)provider, (CharSequence)providerName);
        }).collect(Collectors.toList());
    }

    private Optional<Method> findPactMethod(PactVerification pactVerification) {
        String pactFragment = pactVerification.fragment();
        for (Method method : this.target.getClass().getMethods()) {
            Pact pact = method.getAnnotation(Pact.class);
            if (pact == null || !this.provider.equals(this.ep.parseExpression(pact.provider(), DataType.RAW).toString()) || !pactFragment.isEmpty() && !pactFragment.equals(method.getName())) continue;
            this.validatePactSignature(method);
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private void validatePactSignature(Method method) {
        boolean hasValidPactSignature;
        boolean bl = hasValidPactSignature = RequestResponsePact.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(PactDslWithProvider.class);
        if (!hasValidPactSignature) {
            throw new UnsupportedOperationException("Method " + method.getName() + " does not conform required method signature 'public RequestResponsePact xxx(PactDslWithProvider builder)'");
        }
    }

    private PactVerificationResult runPactTest(Statement base, BasePact pact, PactFolder pactFolder, PactDirectory pactDirectory) {
        return ConsumerPactRunnerKt.runConsumerTest((BasePact)pact, (MockProviderConfig)this.config, (mockServer, context) -> {
            this.mockServer = mockServer;
            base.evaluate();
            this.mockServer = null;
            if (pactFolder != null) {
                context.setPactFolder(pactFolder.value());
            }
            if (pactDirectory != null) {
                context.setPactFolder(pactDirectory.value());
            }
            return null;
        });
    }

    protected void validateResult(PactVerificationResult result, PactVerification pactVerification) throws Throwable {
        JUnitTestSupport.validateMockServerResult((PactVerificationResult)result);
    }

    protected Map<String, BasePact> getPacts(String fragment) {
        if (this.pacts == null) {
            this.pacts = new HashMap<String, BasePact>();
            for (Method m : this.target.getClass().getMethods()) {
                Pact pactAnnotation;
                String provider;
                if (!JUnitTestSupport.conformsToSignature((Method)m, (PactSpecVersion)this.config.getPactVersion()) || !this.methodMatchesFragment(m, fragment) || !StringUtils.isEmpty((CharSequence)(provider = this.ep.parseExpression((pactAnnotation = m.getAnnotation(Pact.class)).provider(), DataType.RAW).toString())) && !this.provider.equals(provider)) continue;
                PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)this.ep.parseExpression(pactAnnotation.consumer(), DataType.RAW).toString()).pactSpecVersion(this.config.getPactVersion()).hasPactWith(this.provider);
                this.updateAnyDefaultValues(dslBuilder);
                try {
                    BasePact pact = (BasePact)m.invoke(this.target, dslBuilder);
                    this.pacts.put(this.provider, pact);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke pact method", e);
                }
            }
        }
        return this.pacts;
    }

    private void updateAnyDefaultValues(PactDslWithProvider dslBuilder) {
        for (Method m : this.target.getClass().getMethods()) {
            if (m.isAnnotationPresent(DefaultRequestValues.class)) {
                this.setupDefaultRequestValues(dslBuilder, m);
                continue;
            }
            if (!m.isAnnotationPresent(DefaultResponseValues.class)) continue;
            this.setupDefaultResponseValues(dslBuilder, m);
        }
    }

    private void setupDefaultRequestValues(PactDslWithProvider dslBuilder, Method m) {
        PactDslRequestWithoutPath defaults;
        if (m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(PactDslRequestWithoutPath.class)) {
            defaults = dslBuilder.uponReceiving("defaults");
            try {
                m.invoke(this.target, defaults);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke default request method", e);
            }
        } else {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public void " + m.getName() + "(PactDslRequestWithoutPath defaultRequest)'");
        }
        dslBuilder.setDefaultRequestValues(defaults);
    }

    private void setupDefaultResponseValues(PactDslWithProvider dslBuilder, Method m) {
        PactDslResponse defaults;
        if (m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(PactDslResponse.class)) {
            defaults = new PactDslResponse(dslBuilder.getConsumerPactBuilder(), null, null, null);
            try {
                m.invoke(this.target, defaults);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke default response method", e);
            }
        } else {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public void " + m.getName() + "(PactDslResponse defaultResponse)'");
        }
        dslBuilder.setDefaultResponseValues(defaults);
    }

    private boolean methodMatchesFragment(Method m, String fragment) {
        return StringUtils.isEmpty((CharSequence)fragment) || m.getName().equals(fragment);
    }

    public String getUrl() {
        return this.mockServer == null ? null : this.mockServer.getUrl();
    }

    public Integer getPort() {
        return this.mockServer == null ? null : Integer.valueOf(this.mockServer.getPort());
    }
}

