/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.apt;

import java.io.PrintWriter;
import java.io.Writer;
import org.kohsuke.args4j.apt.AnnotationVisitor;
import org.kohsuke.args4j.apt.OptionWithUsage;

class HtmlWriter
implements AnnotationVisitor {
    private final PrintWriter out;

    public HtmlWriter(Writer out) {
        this.out = new PrintWriter(out);
        this.out.println("<table class='args4j-usage'>");
    }

    public void onOption(String name, String usage) {
        this.out.println("  <tr>");
        this.writeTag("td", "args4j-option", name);
        this.writeTag("td", "args4j-usage", usage);
        this.out.println("  </tr>");
    }

    public void onOption(OptionWithUsage optionWithUsage) {
        this.out.println("  <tr>");
        this.writeTag("td", "args4j-option", optionWithUsage.option.name());
        this.writeTag("td", "args4j-usage", optionWithUsage.usage);
        this.out.println("  </tr>");
    }

    private void writeTag(String tag, String cssClass, String value) {
        this.out.println("    <" + tag + " class='" + cssClass + "'><![CDATA[" + value + "]]></" + tag + ">");
    }

    public void done() {
        this.out.println("</table>");
        this.out.close();
    }
}

