/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.DJDefaultScriptlet;
import ar.com.fdvs.dj.core.layout.AbstractLayoutManager;
import ar.com.fdvs.dj.core.layout.CrossTabColorShema;
import ar.com.fdvs.dj.core.layout.CrossTabColorShemaGenerator;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.DJBaseElement;
import ar.com.fdvs.dj.domain.DJCRosstabMeasurePrecalculatedTotalProvider;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJCrosstabColumn;
import ar.com.fdvs.dj.domain.DJCrosstabMeasure;
import ar.com.fdvs.dj.domain.DJCrosstabRow;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.HyperLinkUtil;
import ar.com.fdvs.dj.util.LayoutUtils;
import ar.com.fdvs.dj.util.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculatorFactory;
import net.sf.jasperreports.crosstabs.type.CrosstabPercentageEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Dj2JrCrosstabBuilder {
    private static final Log log = LogFactory.getLog(Dj2JrCrosstabBuilder.class);
    private static final Random random = new Random();
    private JasperDesign design;
    private JRDesignCrosstab jrcross;
    private DJCrosstab djcross;
    private DJCrosstabColumn[] cols;
    private DJCrosstabRow[] rows;
    private Color[][] colors;
    private AbstractLayoutManager layoutManager;

    public JRDesignCrosstab createCrosstab(DJCrosstab djcrosstab, AbstractLayoutManager layoutManager) {
        this.djcross = djcrosstab;
        this.layoutManager = layoutManager;
        this.design = layoutManager.getDesign();
        this.jrcross = new JRDesignCrosstab();
        this.jrcross.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
        this.cols = djcrosstab.getColumns().toArray(new DJCrosstabColumn[0]);
        this.rows = djcrosstab.getRows().toArray(new DJCrosstabRow[0]);
        JRDesignExpression mapExp = new JRDesignExpression();
        mapExp.setText("$P{REPORT_PARAMETERS_MAP}");
        mapExp.setValueClass(Map.class);
        this.jrcross.setParametersMapExpression((JRExpression)mapExp);
        JRDesignCrosstabParameter crossParameter = new JRDesignCrosstabParameter();
        crossParameter.setName("REPORT_SCRIPTLET");
        crossParameter.setValueClassName(DJDefaultScriptlet.class.getName());
        JRDesignExpression expression = new JRDesignExpression();
        expression.setText("$P{REPORT_PARAMETERS_MAP}.get(\"REPORT_SCRIPTLET\")");
        expression.setValueClassName(DJDefaultScriptlet.class.getName());
        crossParameter.setExpression((JRExpression)expression);
        try {
            this.jrcross.addParameter((JRCrosstabParameter)crossParameter);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        this.initColors();
        this.setCrosstabOptions();
        this.registerColumns();
        this.registerRows();
        this.registerMeasures();
        this.createCells();
        this.createMainHeaderCell();
        this.registerDataSet(djcrosstab);
        return this.jrcross;
    }

    private void setCrosstabOptions() {
        if (this.djcross.isUseFullWidth()) {
            this.jrcross.setWidth(this.layoutManager.getReport().getOptions().getPrintableWidth());
        } else {
            this.jrcross.setWidth(this.djcross.getWidth());
        }
        this.jrcross.setHeight(this.djcross.getHeight());
        this.jrcross.setColumnBreakOffset(this.djcross.getColumnBreakOffset());
        this.jrcross.setIgnoreWidth(this.djcross.isIgnoreWidth());
    }

    private void createMainHeaderCell() {
        JRDesignCellContents contents = new JRDesignCellContents();
        contents.setBackcolor(this.colors[this.colors.length - 1][this.colors[0].length - 1]);
        contents.setMode(ModeEnum.OPAQUE);
        this.jrcross.setHeaderCell(contents);
        JRDesignTextField element = new JRDesignTextField();
        String text = "";
        int auxHeight = 0;
        int auxWidth = 0;
        if (this.djcross.isAutomaticTitle()) {
            text = this.createAutomaticMainHeaderTitle();
        } else if (this.djcross.getMainHeaderTitle() != null) {
            text = "\"" + this.djcross.getMainHeaderTitle() + "\"";
        }
        for (DJCrosstabColumn col : this.djcross.getColumns()) {
            auxHeight += col.getHeaderHeight();
        }
        for (DJCrosstabRow row : this.djcross.getRows()) {
            auxWidth += row.getHeaderWidth();
        }
        JRDesignExpression exp = ExpressionUtils.createStringExpression(text);
        element.setExpression((JRExpression)exp);
        element.setWidth(auxWidth);
        element.setHeight(auxHeight);
        element.setStretchWithOverflow(true);
        if (this.djcross.getHeaderStyle() != null) {
            this.layoutManager.applyStyleToElement(this.djcross.getHeaderStyle(), (JRDesignElement)element);
        }
        this.applyCellBorder(contents, true, true);
        contents.addElement((JRDesignElement)element);
    }

    private String createAutomaticMainHeaderTitle() {
        String text = "";
        Iterator<DJBaseElement> iterator = this.djcross.getColumns().iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = iterator.next();
            text = text + col.getTitle();
            if (!iterator.hasNext()) continue;
            text = text + ", ";
        }
        text = text + "\\nvs.\\n";
        iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            text = text + row.getTitle();
            if (!iterator.hasNext()) continue;
            text = text + ", ";
        }
        text = "\"" + text + "\"";
        return text;
    }

    private void initColors() {
        CrossTabColorShema colorScheme = this.djcross.getCtColorScheme();
        if (colorScheme != null) {
            colorScheme.create(this.cols.length, this.rows.length);
            this.colors = colorScheme.getColors();
        } else {
            this.colors = CrossTabColorShemaGenerator.createSchema(this.djcross.getColorScheme(), this.cols.length, this.rows.length);
        }
    }

    private void registerDataSet(DJCrosstab djcrosstab) {
        JRDesignField field;
        int i;
        JRDesignCrosstabDataset dataset = new JRDesignCrosstabDataset();
        dataset.setDataPreSorted(djcrosstab.getDatasource().isPreSorted());
        JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
        JRDesignExpression exp = ExpressionUtils.getDataSourceExpression(djcrosstab.getDatasource());
        datasetRun.setDataSourceExpression((JRExpression)exp);
        dataset.setDatasetRun((JRDatasetRun)datasetRun);
        JRDesignDataset jrDataset = new JRDesignDataset(false);
        for (i = this.rows.length - 1; i >= 0; --i) {
            DJCrosstabRow crosstabRow = this.rows[i];
            field = new JRDesignField();
            field.setName(crosstabRow.getProperty().getProperty());
            field.setValueClassName(crosstabRow.getProperty().getValueClassName());
            try {
                jrDataset.addField((JRField)field);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (i = this.cols.length - 1; i >= 0; --i) {
            DJCrosstabColumn crosstabColumn = this.cols[i];
            field = new JRDesignField();
            field.setName(crosstabColumn.getProperty().getProperty());
            field.setValueClassName(crosstabColumn.getProperty().getValueClassName());
            try {
                jrDataset.addField((JRField)field);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (DJCrosstabMeasure djmeasure : djcrosstab.getMeasures()) {
            field = new JRDesignField();
            field.setName(djmeasure.getProperty().getProperty());
            field.setValueClassName(djmeasure.getProperty().getValueClassName());
            try {
                jrDataset.addField((JRField)field);
            }
            catch (JRException e) {
                log.warn((Object)(e.getMessage() + " in crosstab, using old one."));
            }
        }
        this.jrcross.setDataset(dataset);
        String dsName = "crosstabDataSource_" + Math.abs(random.nextLong());
        while (this.design.getDatasetMap().containsKey(dsName)) {
            dsName = "crosstabDataSource_" + Math.abs(random.nextLong());
        }
        datasetRun.setDatasetName(dsName);
        jrDataset.setName(dsName);
        log.debug((Object)("Crosstab dataset name = " + dsName));
        try {
            if (!this.design.getDatasetMap().containsKey(jrDataset.getName())) {
                this.design.addDataset(jrDataset);
            }
        }
        catch (JRException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createCells() {
        DJCrosstabColumn auxCol = new DJCrosstabColumn();
        DJCrosstabRow auxRow = new DJCrosstabRow();
        try {
            BeanUtils.copyProperties((Object)auxCol, (Object)this.djcross.getColumns().get(this.djcross.getColumns().size() - 1));
            BeanUtils.copyProperties((Object)auxRow, (Object)this.djcross.getRows().get(this.djcross.getRows().size() - 1));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        auxCol.setProperty(null);
        auxRow.setProperty(null);
        ArrayList<DJCrosstabColumn> auxColsList = new ArrayList<DJCrosstabColumn>(this.djcross.getColumns());
        auxColsList.add(auxCol);
        ArrayList<DJCrosstabRow> auxRowsList = new ArrayList<DJCrosstabRow>(this.djcross.getRows());
        auxRowsList.add(auxRow);
        DJCrosstabColumn[] auxCols = auxColsList.toArray(new DJCrosstabColumn[0]);
        DJCrosstabRow[] auxRows = auxRowsList.toArray(new DJCrosstabRow[0]);
        for (int i = auxCols.length - 1; i >= 0; --i) {
            for (int j = auxRows.length - 1; j >= 0; --j) {
                boolean isColumnTotal;
                DJCrosstabColumn crosstabColumn = auxCols[i];
                DJCrosstabRow crosstabRow = auxRows[j];
                JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
                cell.setWidth(Integer.valueOf(crosstabColumn.getWidth()));
                cell.setHeight(Integer.valueOf(crosstabRow.getHeight()));
                boolean isRowTotal = crosstabRow.getProperty() != null;
                boolean bl = isColumnTotal = crosstabColumn.getProperty() != null;
                if (isColumnTotal) {
                    cell.setColumnTotalGroup(crosstabColumn.getProperty().getProperty());
                }
                if (isRowTotal) {
                    cell.setRowTotalGroup(crosstabRow.getProperty().getProperty());
                }
                JRDesignCellContents contents = new JRDesignCellContents();
                int measureIdx = 0;
                int yOffsetCounter = 0;
                int measureHeight = crosstabRow.getHeight() / this.djcross.getVisibleMeasures().size();
                for (DJCrosstabMeasure djmeasure : this.djcross.getMeasures()) {
                    if (!djmeasure.getVisible().booleanValue()) {
                        --yOffsetCounter;
                    } else {
                        JRDesignStyle jrstyle;
                        Style style;
                        JRDesignTextField element = new JRDesignTextField();
                        element.setWidth(crosstabColumn.getWidth());
                        element.setHeight(measureHeight);
                        element.setY(yOffsetCounter * measureHeight);
                        JRDesignExpression measureExp = new JRDesignExpression();
                        boolean isTotalCell = isRowTotal || isColumnTotal;
                        String measureValueClassName = djmeasure.getProperty().getValueClassName();
                        String measureProperty = djmeasure.getMeasureIdentifier(measureIdx);
                        String meausrePrefix = djmeasure.getMeasurePrefix(measureIdx);
                        if (!isTotalCell) {
                            if (djmeasure.getValueFormatter() == null) {
                                measureExp.setValueClassName(measureValueClassName);
                                measureExp.setText("$V{" + measureProperty + "}");
                            } else {
                                measureExp.setText(djmeasure.getTextForValueFormatterExpression(measureProperty, this.djcross.getMeasures()));
                                measureExp.setValueClassName(djmeasure.getValueFormatter().getClassName());
                            }
                        } else if (djmeasure.getValueFormatter() == null) {
                            if (djmeasure.getPrecalculatedTotalProvider() == null) {
                                measureExp.setValueClassName(measureValueClassName);
                                measureExp.setText("$V{" + measureProperty + "}");
                            } else {
                                this.setExpressionForPrecalculatedTotalValue(auxCols, auxRows, measureExp, djmeasure, crosstabColumn, crosstabRow, meausrePrefix);
                            }
                        } else if (djmeasure.getPrecalculatedTotalProvider() == null) {
                            measureExp.setText(djmeasure.getTextForValueFormatterExpression(measureProperty, this.djcross.getMeasures()));
                            measureExp.setValueClassName(djmeasure.getValueFormatter().getClassName());
                        } else {
                            this.setExpressionForPrecalculatedTotalValue(auxCols, auxRows, measureExp, djmeasure, crosstabColumn, crosstabRow, meausrePrefix);
                        }
                        element.setExpression((JRExpression)measureExp);
                        if (!isRowTotal && !isColumnTotal && djmeasure.getStyle() != null) {
                            this.layoutManager.applyStyleToElement(djmeasure.getStyle(), (JRDesignElement)element);
                        }
                        if (isRowTotal && !isColumnTotal) {
                            style = this.getRowTotalStyle(crosstabRow);
                            if (style == null) {
                                style = djmeasure.getStyle();
                            }
                            if (style != null) {
                                this.layoutManager.applyStyleToElement(style, (JRDesignElement)element);
                            }
                        }
                        if (isColumnTotal && !isRowTotal) {
                            style = this.getColumnTotalStyle(crosstabColumn);
                            if (style == null) {
                                style = djmeasure.getStyle();
                            }
                            if (style != null) {
                                this.layoutManager.applyStyleToElement(style, (JRDesignElement)element);
                            }
                        }
                        if (isRowTotal && isColumnTotal) {
                            style = this.getRowTotalStyle(crosstabRow);
                            if (style == null) {
                                style = this.getColumnTotalStyle(crosstabColumn);
                            }
                            if (style == null) {
                                style = djmeasure.getStyle();
                            }
                            if (style != null) {
                                this.layoutManager.applyStyleToElement(style, (JRDesignElement)element);
                            }
                        }
                        if ((jrstyle = (JRDesignStyle)element.getStyle()) == null) {
                            if (log.isDebugEnabled()) {
                                log.warn((Object)"jrstyle is null in crosstab cell, this should have not happened.");
                            }
                            this.layoutManager.applyStyleToElement(null, (JRDesignElement)element);
                            jrstyle = (JRDesignStyle)element.getStyle();
                            jrstyle.setBlankWhenNull(true);
                        }
                        JRDesignStyle alternateStyle = Utils.cloneStyle(jrstyle);
                        alternateStyle.setName(alternateStyle.getFontName() + "_for_column_" + djmeasure.getProperty().getProperty() + "_i" + i + "_j" + j);
                        alternateStyle.getConditionalStyleList().clear();
                        element.setStyle((JRStyle)alternateStyle);
                        try {
                            this.design.addStyle((JRStyle)alternateStyle);
                        }
                        catch (JRException jRException) {
                            // empty catch block
                        }
                        this.setUpConditionStyles(alternateStyle, djmeasure, measureExp.getText());
                        if (djmeasure.getLink() != null) {
                            String name = "cell_" + i + "_" + j + "_ope" + djmeasure.getOperation().getValue();
                            HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.design, djmeasure.getLink(), element, name);
                        }
                        contents.addElement((JRDesignElement)element);
                    }
                    ++measureIdx;
                    ++yOffsetCounter;
                }
                contents.setMode(ModeEnum.OPAQUE);
                this.applyBackgroundColor(contents, crosstabRow, crosstabColumn, i, j);
                this.applyCellBorder(contents, false, false);
                cell.setContents(contents);
                try {
                    this.jrcross.addCell(cell);
                    continue;
                }
                catch (JRException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void setExpressionForPrecalculatedTotalValue(DJCrosstabColumn[] auxCols, DJCrosstabRow[] auxRows, JRDesignExpression measureExp, DJCrosstabMeasure djmeasure, DJCrosstabColumn crosstabColumn, DJCrosstabRow crosstabRow, String meausrePrefix) {
        String rowValuesExp = "new Object[]{";
        String rowPropsExp = "new String[]{";
        for (int i = 0; i < auxRows.length; ++i) {
            if (auxRows[i].getProperty() == null) continue;
            rowValuesExp = rowValuesExp + "$V{" + auxRows[i].getProperty().getProperty() + "}";
            rowPropsExp = rowPropsExp + "\"" + auxRows[i].getProperty().getProperty() + "\"";
            if (i + 1 >= auxRows.length || auxRows[i + 1].getProperty() == null) continue;
            rowValuesExp = rowValuesExp + ", ";
            rowPropsExp = rowPropsExp + ", ";
        }
        rowValuesExp = rowValuesExp + "}";
        rowPropsExp = rowPropsExp + "}";
        String colValuesExp = "new Object[]{";
        String colPropsExp = "new String[]{";
        for (int i = 0; i < auxCols.length; ++i) {
            if (auxCols[i].getProperty() == null) continue;
            colValuesExp = colValuesExp + "$V{" + auxCols[i].getProperty().getProperty() + "}";
            colPropsExp = colPropsExp + "\"" + auxCols[i].getProperty().getProperty() + "\"";
            if (i + 1 >= auxCols.length || auxCols[i + 1].getProperty() == null) continue;
            colValuesExp = colValuesExp + ", ";
            colPropsExp = colPropsExp + ", ";
        }
        colValuesExp = colValuesExp + "}";
        colPropsExp = colPropsExp + "}";
        String measureProperty = meausrePrefix + djmeasure.getProperty().getProperty();
        String expText = "(((" + DJCRosstabMeasurePrecalculatedTotalProvider.class.getName() + ")$P{crosstab-measure__" + measureProperty + "_totalProvider}).getValueFor( " + colPropsExp + ", " + colValuesExp + ", " + rowPropsExp + ", " + rowValuesExp + " ))";
        if (djmeasure.getValueFormatter() != null) {
            String fieldsMap = ExpressionUtils.getTextForFieldsFromScriptlet();
            String parametersMap = ExpressionUtils.getTextForParametersFromScriptlet();
            String variablesMap = ExpressionUtils.getTextForVariablesFromScriptlet();
            String stringExpression = "(((" + DJValueFormatter.class.getName() + ")$P{crosstab-measure__" + measureProperty + "_vf}).evaluate( " + "(" + expText + "), " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " ))";
            measureExp.setText(stringExpression);
            measureExp.setValueClassName(djmeasure.getValueFormatter().getClassName());
        } else {
            log.debug((Object)("text for crosstab total provider is: " + expText));
            measureExp.setText(expText);
            String valueClassNameForOperation = ExpressionUtils.getValueClassNameForOperation(djmeasure.getOperation(), djmeasure.getProperty());
            measureExp.setValueClassName(valueClassNameForOperation);
        }
    }

    private void setUpConditionStyles(JRDesignStyle jrstyle, DJCrosstabMeasure djmeasure, String columExpression) {
        if (Utils.isEmpty(djmeasure.getConditionalStyles())) {
            return;
        }
        for (ConditionalStyle condition : djmeasure.getConditionalStyles()) {
            JRDesignExpression expression = ExpressionUtils.getExpressionForConditionalStyle(condition, columExpression);
            JRDesignConditionalStyle condStyle = this.layoutManager.makeConditionalStyle(condition.getStyle());
            condStyle.setConditionExpression((JRExpression)expression);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyle);
        }
    }

    private Style getRowTotalStyle(DJCrosstabRow crosstabRow) {
        return crosstabRow.getTotalStyle() == null ? this.djcross.getRowTotalStyle() : crosstabRow.getTotalStyle();
    }

    private Style getColumnTotalStyle(DJCrosstabColumn crosstabColumnRow) {
        return crosstabColumnRow.getTotalStyle() == null ? this.djcross.getColumnTotalStyle() : crosstabColumnRow.getTotalStyle();
    }

    private void applyBackgroundColor(JRDesignCellContents contents, DJCrosstabRow crosstabRow, DJCrosstabColumn crosstabColumn, int i, int j) {
        Color color = this.colors[i][j];
        contents.setBackcolor(color);
    }

    private void registerMeasures() {
        int measureIdx = 0;
        for (DJCrosstabMeasure djmeasure : this.djcross.getMeasures()) {
            JRDesignCrosstabParameter crosstabParameter;
            String meausrePrefix = "idx" + measureIdx + "_";
            JRDesignCrosstabMeasure measure = new JRDesignCrosstabMeasure();
            measure.setName(meausrePrefix + djmeasure.getProperty().getProperty());
            measure.setCalculation(CalculationEnum.getByValue((byte)djmeasure.getOperation().getValue()));
            measure.setValueClassName(djmeasure.getProperty().getValueClassName());
            JRDesignExpression valueExp = new JRDesignExpression();
            valueExp.setValueClassName(djmeasure.getProperty().getValueClassName());
            valueExp.setText("$F{" + djmeasure.getProperty().getProperty() + "}");
            measure.setValueExpression((JRExpression)valueExp);
            if (djmeasure.getIsPercentage().booleanValue()) {
                try {
                    Class<?> valueCass = Class.forName(djmeasure.getProperty().getValueClassName());
                    measure.setPercentageCalculatorClassName(JRPercentageCalculatorFactory.getPercentageCalculator(null, valueCass).getClass().getName());
                    measure.setPercentageType(CrosstabPercentageEnum.GRAND_TOTAL);
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            if (djmeasure.getValueFormatter() != null) {
                crosstabParameter = new JRDesignCrosstabParameter();
                crosstabParameter.setName("crosstab-measure__" + measure.getName() + "_vf");
                crosstabParameter.setValueClassName(DJValueFormatter.class.getName());
                log.debug((Object)("Registering value formatter parameter for crosstab measure " + crosstabParameter.getName()));
                try {
                    this.jrcross.addParameter((JRCrosstabParameter)crosstabParameter);
                }
                catch (JRException e) {
                    throw new EntitiesRegistrationException(e.getMessage(), e);
                }
                ((DynamicJasperDesign)this.design).getParametersWithValues().put(crosstabParameter.getName(), djmeasure.getValueFormatter());
            }
            if (djmeasure.getPrecalculatedTotalProvider() != null) {
                crosstabParameter = new JRDesignCrosstabParameter();
                crosstabParameter.setName("crosstab-measure__" + measure.getName() + "_totalProvider");
                crosstabParameter.setValueClassName(DJCRosstabMeasurePrecalculatedTotalProvider.class.getName());
                log.debug((Object)("Registering crosstab total provider parameter for measure " + crosstabParameter.getName()));
                try {
                    this.jrcross.addParameter((JRCrosstabParameter)crosstabParameter);
                }
                catch (JRException e) {
                    throw new EntitiesRegistrationException(e.getMessage(), e);
                }
                ((DynamicJasperDesign)this.design).getParametersWithValues().put(crosstabParameter.getName(), djmeasure.getPrecalculatedTotalProvider());
            }
            try {
                this.jrcross.addMeasure(measure);
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            ++measureIdx;
        }
    }

    private void registerRows() {
        DynamicJasperDesign djdesign = (DynamicJasperDesign)this.design;
        for (int i = 0; i < this.rows.length; ++i) {
            Style headerstyle;
            DJCrosstabRow crosstabRow = this.rows[i];
            JRDesignCrosstabRowGroup ctRowGroup = new JRDesignCrosstabRowGroup();
            ctRowGroup.setWidth(crosstabRow.getHeaderWidth());
            ctRowGroup.setName(crosstabRow.getProperty().getProperty());
            JRDesignCrosstabBucket rowBucket = new JRDesignCrosstabBucket();
            Comparator comparator = crosstabRow.getComparator();
            if (comparator != null) {
                String comparatorParamName = ExpressionUtils.createParameterName("crosstab_column_comparator", comparator, crosstabRow.getProperty().getProperty());
                LayoutUtils.registerAndAddParameter(djdesign, comparatorParamName, Comparator.class.getName(), comparator);
                JRDesignExpression comparatorExpression = ExpressionUtils.createExpression("$P{" + comparatorParamName + "}", Comparator.class.getName());
                rowBucket.setComparatorExpression((JRExpression)comparatorExpression);
            }
            rowBucket.setValueClassName(crosstabRow.getProperty().getValueClassName());
            ctRowGroup.setBucket(rowBucket);
            JRDesignExpression bucketExp = ExpressionUtils.createExpression("$F{" + crosstabRow.getProperty().getProperty() + "}", crosstabRow.getProperty().getValueClassName());
            rowBucket.setExpression(bucketExp);
            JRDesignCellContents rowHeaderContents = new JRDesignCellContents();
            JRDesignTextField rowTitle = new JRDesignTextField();
            JRDesignExpression rowTitExp = new JRDesignExpression();
            rowTitExp.setValueClassName(crosstabRow.getProperty().getValueClassName());
            rowTitExp.setText("$V{" + crosstabRow.getProperty().getProperty() + "}");
            rowTitle.setExpression((JRExpression)rowTitExp);
            rowTitle.setWidth(crosstabRow.getHeaderWidth());
            int auxHeight = this.getRowHeaderMaxHeight(crosstabRow);
            rowTitle.setHeight(auxHeight);
            Style style = headerstyle = crosstabRow.getHeaderStyle() == null ? this.djcross.getRowHeaderStyle() : crosstabRow.getHeaderStyle();
            if (headerstyle != null) {
                this.layoutManager.applyStyleToElement(headerstyle, (JRDesignElement)rowTitle);
                rowHeaderContents.setBackcolor(headerstyle.getBackgroundColor());
            }
            rowHeaderContents.addElement((JRDesignElement)rowTitle);
            rowHeaderContents.setMode(ModeEnum.OPAQUE);
            boolean fullBorder = i <= 0;
            this.applyCellBorder(rowHeaderContents, false, fullBorder);
            ctRowGroup.setHeader(rowHeaderContents);
            if (crosstabRow.isShowTotals()) {
                this.createRowTotalHeader(ctRowGroup, crosstabRow, fullBorder);
            }
            try {
                this.jrcross.addRowGroup(ctRowGroup);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private int getRowHeaderMaxHeight(DJCrosstabRow crosstabRow) {
        int auxHeight = crosstabRow.getHeight();
        boolean found = false;
        for (DJCrosstabRow row : this.djcross.getRows()) {
            if (!row.equals(crosstabRow) && !found) continue;
            found = true;
            if (row.equals(crosstabRow) || !row.isShowTotals()) continue;
            auxHeight += row.getHeight();
        }
        return auxHeight;
    }

    private void registerColumns() {
        DynamicJasperDesign djdesign = (DynamicJasperDesign)this.design;
        for (int i = 0; i < this.cols.length; ++i) {
            Style headerstyle;
            DJCrosstabColumn crosstabColumn = this.cols[i];
            JRDesignCrosstabColumnGroup ctColGroup = new JRDesignCrosstabColumnGroup();
            ctColGroup.setName(crosstabColumn.getProperty().getProperty());
            ctColGroup.setHeight(crosstabColumn.getHeaderHeight());
            JRDesignCrosstabBucket bucket = new JRDesignCrosstabBucket();
            if (crosstabColumn.getComparator() != null) {
                String comparatorParamName = ExpressionUtils.createParameterName("crosstab_column_comparator", crosstabColumn.getComparator(), crosstabColumn.getProperty().getProperty());
                LayoutUtils.registerAndAddParameter(djdesign, comparatorParamName, Comparator.class.getName(), crosstabColumn.getComparator());
                JRDesignExpression comparatorExpression = ExpressionUtils.createExpression("$P{" + comparatorParamName + "}", Comparator.class.getName());
                bucket.setComparatorExpression((JRExpression)comparatorExpression);
            }
            bucket.setValueClassName(crosstabColumn.getProperty().getValueClassName());
            JRDesignExpression bucketExp = ExpressionUtils.createExpression("$F{" + crosstabColumn.getProperty().getProperty() + "}", crosstabColumn.getProperty().getValueClassName());
            bucket.setExpression(bucketExp);
            ctColGroup.setBucket(bucket);
            JRDesignCellContents colHeaerContent = new JRDesignCellContents();
            JRDesignTextField colTitle = new JRDesignTextField();
            JRDesignExpression colTitleExp = new JRDesignExpression();
            colTitleExp.setValueClassName(crosstabColumn.getProperty().getValueClassName());
            colTitleExp.setText("$V{" + crosstabColumn.getProperty().getProperty() + "}");
            colTitle.setExpression((JRExpression)colTitleExp);
            colTitle.setWidth(crosstabColumn.getWidth());
            colTitle.setHeight(crosstabColumn.getHeaderHeight());
            int auxWidth = this.calculateRowHeaderMaxWidth(crosstabColumn);
            colTitle.setWidth(auxWidth);
            Style style = headerstyle = crosstabColumn.getHeaderStyle() == null ? this.djcross.getColumnHeaderStyle() : crosstabColumn.getHeaderStyle();
            if (headerstyle != null) {
                this.layoutManager.applyStyleToElement(headerstyle, (JRDesignElement)colTitle);
                colHeaerContent.setBackcolor(headerstyle.getBackgroundColor());
            }
            colHeaerContent.addElement((JRDesignElement)colTitle);
            colHeaerContent.setMode(ModeEnum.OPAQUE);
            boolean fullBorder = i <= 0;
            this.applyCellBorder(colHeaerContent, fullBorder, false);
            ctColGroup.setHeader(colHeaerContent);
            if (crosstabColumn.isShowTotals()) {
                this.createColumTotalHeader(ctColGroup, crosstabColumn, fullBorder);
            }
            try {
                this.jrcross.addColumnGroup(ctColGroup);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private int calculateRowHeaderMaxWidth(DJCrosstabColumn crosstabColumn) {
        int auxWidth = 0;
        boolean firstTime = true;
        ArrayList<DJCrosstabColumn> auxList = new ArrayList<DJCrosstabColumn>(this.djcross.getColumns());
        Collections.reverse(auxList);
        for (DJCrosstabColumn col : auxList) {
            if (col.equals(crosstabColumn)) {
                if (auxWidth != 0) break;
                auxWidth = col.getWidth();
                break;
            }
            if (firstTime) {
                auxWidth += col.getWidth();
                firstTime = false;
            }
            if (!col.isShowTotals()) continue;
            auxWidth += col.getWidth();
        }
        return auxWidth;
    }

    private void createRowTotalHeader(JRDesignCrosstabRowGroup ctRowGroup, DJCrosstabRow crosstabRow, boolean fullBorder) {
        JRDesignCellContents totalHeaderContent = new JRDesignCellContents();
        ctRowGroup.setTotalHeader(totalHeaderContent);
        ctRowGroup.setTotalPosition(CrosstabTotalPositionEnum.END);
        Style totalHeaderstyle = crosstabRow.getTotalHeaderStyle() == null ? this.djcross.getRowTotalheaderStyle() : crosstabRow.getTotalHeaderStyle();
        totalHeaderContent.setMode(ModeEnum.OPAQUE);
        JRDesignTextField element = new JRDesignTextField();
        JRDesignExpression exp = crosstabRow.getTotalLegend() != null ? ExpressionUtils.createExpression("\"" + crosstabRow.getTotalLegend() + "\"", String.class) : ExpressionUtils.createExpression("\"Total " + crosstabRow.getTitle() + "\"", String.class);
        element.setExpression((JRExpression)exp);
        element.setHeight(crosstabRow.getHeight());
        if (totalHeaderstyle != null) {
            totalHeaderContent.setBackcolor(totalHeaderstyle.getBackgroundColor());
            this.layoutManager.applyStyleToElement(totalHeaderstyle, (JRDesignElement)element);
        }
        int auxWidth = 0;
        boolean found = false;
        for (DJCrosstabRow row : this.djcross.getRows()) {
            if (!row.equals(crosstabRow) && !found) continue;
            found = true;
            auxWidth += row.getHeaderWidth();
        }
        element.setWidth(auxWidth);
        this.applyCellBorder(totalHeaderContent, false, fullBorder);
        totalHeaderContent.addElement((JRDesignElement)element);
    }

    private void applyCellBorder(JRDesignCellContents cellContent, boolean topBorder, boolean leftBorder) {
        Border cellBorder = this.djcross.getCellBorder();
        if (cellBorder != null && cellBorder.getWidth() != 0.0f) {
            byte lineStyle = cellBorder.getLineStyle();
            LayoutUtils.convertBorderToPen(cellBorder, (JRPen)cellContent.getLineBox().getBottomPen());
            LayoutUtils.convertBorderToPen(cellBorder, (JRPen)cellContent.getLineBox().getRightPen());
            if (topBorder) {
                LayoutUtils.convertBorderToPen(cellBorder, (JRPen)cellContent.getLineBox().getTopPen());
            }
            if (leftBorder) {
                LayoutUtils.convertBorderToPen(cellBorder, (JRPen)cellContent.getLineBox().getLeftPen());
            }
        }
    }

    private void createColumTotalHeader(JRDesignCrosstabColumnGroup ctColGroup, DJCrosstabColumn crosstabColumn, boolean fullBorder) {
        JRDesignCellContents totalHeaderContent = new JRDesignCellContents();
        ctColGroup.setTotalHeader(totalHeaderContent);
        ctColGroup.setTotalPosition(CrosstabTotalPositionEnum.END);
        Style totalHeaderstyle = crosstabColumn.getTotalHeaderStyle() == null ? this.djcross.getColumnTotalheaderStyle() : crosstabColumn.getTotalHeaderStyle();
        totalHeaderContent.setMode(ModeEnum.OPAQUE);
        JRDesignExpression exp = crosstabColumn.getTotalLegend() != null ? ExpressionUtils.createExpression("\"" + crosstabColumn.getTotalLegend() + "\"", String.class) : ExpressionUtils.createExpression("\"Total " + crosstabColumn.getTitle() + "\"", String.class);
        JRDesignTextField element = new JRDesignTextField();
        element.setExpression((JRExpression)exp);
        element.setWidth(crosstabColumn.getWidth());
        if (totalHeaderstyle != null) {
            this.layoutManager.applyStyleToElement(totalHeaderstyle, (JRDesignElement)element);
            totalHeaderContent.setBackcolor(totalHeaderstyle.getBackgroundColor());
        }
        int auxWidth = 0;
        boolean found = false;
        for (DJCrosstabColumn col : this.djcross.getColumns()) {
            if (!col.equals(crosstabColumn) && !found) continue;
            found = true;
            auxWidth += col.getHeaderHeight();
        }
        element.setHeight(auxWidth);
        this.applyCellBorder(totalHeaderContent, fullBorder, false);
        totalHeaderContent.addElement((JRDesignElement)element);
    }
}

