/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.LayoutUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HyperLinkUtil {
    static final Log log = LogFactory.getLog((Class)HyperLinkUtil.class);

    public static void applyHyperLinkToElement(DynamicJasperDesign design, DJHyperLink djlink, JRDesignImage image, String name) {
        StringExpression hce = djlink.getExpression();
        String text = ExpressionUtils.createCustomExpressionInvocationText(name);
        LayoutUtils.registerCustomExpressionParameter(design, name, hce);
        JRDesignExpression hlpe = new JRDesignExpression();
        hlpe.setValueClassName(hce.getClassName());
        hlpe.setText(text);
        image.setHyperlinkReferenceExpression((JRExpression)hlpe);
        image.setHyperlinkType((byte)2);
        if (djlink.getTooltip() != null) {
            StringExpression sExp = djlink.getTooltip();
            String tooltipParameterName = "hyperlink_tooltip_" + name;
            String tooltipText = ExpressionUtils.createCustomExpressionInvocationText(tooltipParameterName);
            LayoutUtils.registerCustomExpressionParameter(design, tooltipParameterName, sExp);
            JRDesignExpression tooltipExp = new JRDesignExpression();
            tooltipExp.setValueClassName(sExp.getClassName());
            tooltipExp.setText(tooltipText);
            image.setHyperlinkTooltipExpression((JRExpression)tooltipExp);
        }
    }

    public static void applyHyperLinkToElement(DynamicJasperDesign design, DJHyperLink djlink, JRDesignTextField textField, String name) {
        StringExpression hce = djlink.getExpression();
        String text = ExpressionUtils.createCustomExpressionInvocationText(name);
        LayoutUtils.registerCustomExpressionParameter(design, name, hce);
        JRDesignExpression hlpe = new JRDesignExpression();
        hlpe.setValueClassName(hce.getClassName());
        hlpe.setText(text);
        textField.setHyperlinkReferenceExpression((JRExpression)hlpe);
        textField.setHyperlinkType((byte)2);
        if (djlink.getTooltip() != null) {
            StringExpression sExp = djlink.getTooltip();
            String tooltipParameterName = "tooltip_" + name;
            String tooltipText = ExpressionUtils.createCustomExpressionInvocationText(tooltipParameterName);
            LayoutUtils.registerCustomExpressionParameter(design, tooltipParameterName, sExp);
            JRDesignExpression tooltipExp = new JRDesignExpression();
            tooltipExp.setValueClassName(sExp.getClassName());
            tooltipExp.setText(tooltipText);
            textField.setHyperlinkTooltipExpression((JRExpression)tooltipExp);
        }
    }
}

