/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.settings;

import android.content.Context;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.DeliveryMechanism;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.common.SystemCurrentTimeProvider;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.DefaultCachedSettingsIo;
import io.fabric.sdk.android.services.settings.DefaultSettingsController;
import io.fabric.sdk.android.services.settings.DefaultSettingsJsonTransform;
import io.fabric.sdk.android.services.settings.DefaultSettingsSpiCall;
import io.fabric.sdk.android.services.settings.SettingsCacheBehavior;
import io.fabric.sdk.android.services.settings.SettingsController;
import io.fabric.sdk.android.services.settings.SettingsData;
import io.fabric.sdk.android.services.settings.SettingsRequest;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class Settings {
    public static final String SETTINGS_CACHE_FILENAME = "com.crashlytics.settings.json";
    private static final String SETTINGS_URL_FORMAT = "https://settings.crashlytics.com/spi/v2/platforms/android/apps/%s/settings";
    private final AtomicReference<SettingsData> settingsData = new AtomicReference();
    private final CountDownLatch settingsDataLatch = new CountDownLatch(1);
    private SettingsController settingsController;
    private boolean initialized = false;

    public static Settings getInstance() {
        return LazyHolder.INSTANCE;
    }

    private Settings() {
    }

    public synchronized Settings initialize(Kit kit, IdManager idManager, HttpRequestFactory httpRequestFactory, String versionCode, String versionName, String urlEndpoint) {
        if (this.initialized) {
            return this;
        }
        if (this.settingsController == null) {
            Context context = kit.getContext();
            String appIdentifier = idManager.getAppIdentifier();
            String apiKey = new ApiKey().getValue(context);
            String installerPackageName = idManager.getInstallerPackageName();
            SystemCurrentTimeProvider currentTimeProvider = new SystemCurrentTimeProvider();
            DefaultSettingsJsonTransform settingsJsonTransform = new DefaultSettingsJsonTransform();
            DefaultCachedSettingsIo cachedSettingsIo = new DefaultCachedSettingsIo(kit);
            String iconHash = CommonUtils.getAppIconHashOrNull(context);
            String settingsUrl = String.format(Locale.US, SETTINGS_URL_FORMAT, appIdentifier);
            DefaultSettingsSpiCall settingsSpiCall = new DefaultSettingsSpiCall(kit, urlEndpoint, settingsUrl, httpRequestFactory);
            String deviceModel = idManager.getModelName();
            String osBuildVersion = idManager.getOsBuildVersionString();
            String osDisplayVersion = idManager.getOsDisplayVersionString();
            String installationId = idManager.getAppInstallIdentifier();
            String instanceId = CommonUtils.createInstanceIdFrom(CommonUtils.resolveBuildId(context));
            int deliveryMechanismId = DeliveryMechanism.determineFrom(installerPackageName).getId();
            SettingsRequest settingsRequest = new SettingsRequest(apiKey, deviceModel, osBuildVersion, osDisplayVersion, installationId, instanceId, versionName, versionCode, deliveryMechanismId, iconHash);
            this.settingsController = new DefaultSettingsController(kit, settingsRequest, currentTimeProvider, settingsJsonTransform, cachedSettingsIo, settingsSpiCall);
        }
        this.initialized = true;
        return this;
    }

    public void clearSettings() {
        this.settingsData.set(null);
    }

    public void setSettingsController(SettingsController settingsController) {
        this.settingsController = settingsController;
    }

    public <T> T withSettings(SettingsAccess<T> access, T defaultValue) {
        SettingsData settingsData = this.settingsData.get();
        return settingsData == null ? defaultValue : access.usingSettings(settingsData);
    }

    public SettingsData awaitSettingsData() {
        try {
            this.settingsDataLatch.await();
            return this.settingsData.get();
        }
        catch (InterruptedException e) {
            Fabric.getLogger().e("Fabric", "Interrupted while waiting for settings data.");
            return null;
        }
    }

    public synchronized boolean loadSettingsData() {
        SettingsData settingsData = this.settingsController.loadSettingsData();
        this.setSettingsData(settingsData);
        return settingsData != null;
    }

    public synchronized boolean loadSettingsSkippingCache() {
        SettingsData settingsData = this.settingsController.loadSettingsData(SettingsCacheBehavior.SKIP_CACHE_LOOKUP);
        this.setSettingsData(settingsData);
        if (settingsData == null) {
            Fabric.getLogger().e("Fabric", "Failed to force reload of settings from Crashlytics.", null);
        }
        return settingsData != null;
    }

    private void setSettingsData(SettingsData settingsData) {
        this.settingsData.set(settingsData);
        this.settingsDataLatch.countDown();
    }

    public static interface SettingsAccess<T> {
        public T usingSettings(SettingsData var1);
    }

    static class LazyHolder {
        private static final Settings INSTANCE = new Settings();

        LazyHolder() {
        }
    }
}

