/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.settings;

import io.fabric.sdk.android.services.common.CurrentTimeProvider;
import io.fabric.sdk.android.services.settings.AnalyticsSettingsData;
import io.fabric.sdk.android.services.settings.AppIconSettingsData;
import io.fabric.sdk.android.services.settings.AppSettingsData;
import io.fabric.sdk.android.services.settings.BetaSettingsData;
import io.fabric.sdk.android.services.settings.FeaturesSettingsData;
import io.fabric.sdk.android.services.settings.PromptSettingsData;
import io.fabric.sdk.android.services.settings.SessionSettingsData;
import io.fabric.sdk.android.services.settings.SettingsData;
import io.fabric.sdk.android.services.settings.SettingsJsonConstants;
import io.fabric.sdk.android.services.settings.SettingsJsonTransform;
import org.json.JSONException;
import org.json.JSONObject;

class DefaultSettingsJsonTransform
implements SettingsJsonTransform {
    DefaultSettingsJsonTransform() {
    }

    @Override
    public SettingsData buildFromJson(CurrentTimeProvider currentTimeProvider, JSONObject json) throws JSONException {
        int settingsVersion = json.optInt("settings_version", 0);
        int cacheDuration = json.optInt("cache_duration", 3600);
        AppSettingsData appData = this.buildAppDataFrom(json.getJSONObject("app"));
        SessionSettingsData settingsData = this.buildSessionDataFrom(json.getJSONObject("session"));
        PromptSettingsData promptData = this.buildPromptDataFrom(json.getJSONObject("prompt"));
        FeaturesSettingsData featureData = this.buildFeaturesSessionDataFrom(json.getJSONObject("features"));
        AnalyticsSettingsData analyticsData = this.buildAnalyticsSessionDataFrom(json.getJSONObject("analytics"));
        BetaSettingsData betaData = this.buildBetaSettingsDataFrom(json.getJSONObject("beta"));
        long expiresAtMillis = this.getExpiresAtFrom(currentTimeProvider, cacheDuration, json);
        return new SettingsData(expiresAtMillis, appData, settingsData, promptData, featureData, analyticsData, betaData, settingsVersion, cacheDuration);
    }

    @Override
    public JSONObject toJson(SettingsData settingsData) throws JSONException {
        return new JSONObject().put("expires_at", settingsData.expiresAtMillis).put("cache_duration", settingsData.cacheDuration).put("settings_version", settingsData.settingsVersion).put("features", (Object)this.toFeaturesJson(settingsData.featuresData)).put("analytics", (Object)this.toAnalyticsJson(settingsData.analyticsSettingsData)).put("beta", (Object)this.toBetaJson(settingsData.betaSettingsData)).put("app", (Object)this.toAppJson(settingsData.appData)).put("session", (Object)this.toSessionJson(settingsData.sessionData)).put("prompt", (Object)this.toPromptJson(settingsData.promptData));
    }

    private AppSettingsData buildAppDataFrom(JSONObject json) throws JSONException {
        String identifier = json.getString("identifier");
        String status = json.getString("status");
        String url = json.getString("url");
        String reportsUrl = json.getString("reports_url");
        String ndkReportsUrl = json.getString("ndk_reports_url");
        boolean updateRequired = json.optBoolean("update_required", false);
        AppIconSettingsData icon = null;
        if (json.has("icon") && json.getJSONObject("icon").has("hash")) {
            icon = this.buildIconDataFrom(json.getJSONObject("icon"));
        }
        return new AppSettingsData(identifier, status, url, reportsUrl, ndkReportsUrl, updateRequired, icon);
    }

    private AppIconSettingsData buildIconDataFrom(JSONObject iconJson) throws JSONException {
        String hash = iconJson.getString("hash");
        int width = iconJson.getInt("width");
        int height = iconJson.getInt("height");
        return new AppIconSettingsData(hash, width, height);
    }

    private FeaturesSettingsData buildFeaturesSessionDataFrom(JSONObject json) {
        boolean promptEnabled = json.optBoolean("prompt_enabled", false);
        boolean collectLoggedExceptions = json.optBoolean("collect_logged_exceptions", true);
        boolean collectReports = json.optBoolean("collect_reports", true);
        boolean collectAnalytics = json.optBoolean("collect_analytics", false);
        boolean firebaseCrashlyticsEnabled = json.optBoolean("firebase_crashlytics_enabled", false);
        return new FeaturesSettingsData(promptEnabled, collectLoggedExceptions, collectReports, collectAnalytics, firebaseCrashlyticsEnabled);
    }

    private AnalyticsSettingsData buildAnalyticsSessionDataFrom(JSONObject json) {
        String url = json.optString("url", "https://e.crashlytics.com/spi/v2/events");
        int flushSecs = json.optInt("flush_interval_secs", 600);
        int maxByteSizePerFile = json.optInt("max_byte_size_per_file", 8000);
        int maxFileCountPerSend = json.optInt("max_file_count_per_send", 1);
        int maxPendingSendFileCount = json.optInt("max_pending_send_file_count", 100);
        boolean googleAnalyticsEventWritingEnabled = json.optBoolean("forward_to_google_analytics", false);
        boolean includePurchaseEventsInForwardedEvents = json.optBoolean("include_purchase_events_in_forwarded_events", false);
        boolean trackCustomEvents = json.optBoolean("track_custom_events", true);
        boolean trackPredefinedEvents = json.optBoolean("track_predefined_events", true);
        int samplingRate = json.optInt("sampling_rate", 1);
        boolean flushOnBackground = json.optBoolean("flush_on_background", true);
        return new AnalyticsSettingsData(url, flushSecs, maxByteSizePerFile, maxFileCountPerSend, maxPendingSendFileCount, googleAnalyticsEventWritingEnabled, includePurchaseEventsInForwardedEvents, trackCustomEvents, trackPredefinedEvents, samplingRate, flushOnBackground);
    }

    private SessionSettingsData buildSessionDataFrom(JSONObject json) throws JSONException {
        int logBufferSize = json.optInt("log_buffer_size", 64000);
        int maxChainedExceptionDepth = json.optInt("max_chained_exception_depth", 8);
        int maxCustomExceptionEvents = json.optInt("max_custom_exception_events", 64);
        int maxCustomKeyValuePairs = json.optInt("max_custom_key_value_pairs", 64);
        int identifierMask = json.optInt("identifier_mask", 255);
        boolean sendSessionWithoutCrash = json.optBoolean("send_session_without_crash", false);
        int maxCompleteSessionsCount = json.optInt("max_complete_sessions_count", 4);
        return new SessionSettingsData(logBufferSize, maxChainedExceptionDepth, maxCustomExceptionEvents, maxCustomKeyValuePairs, identifierMask, sendSessionWithoutCrash, maxCompleteSessionsCount);
    }

    private PromptSettingsData buildPromptDataFrom(JSONObject json) throws JSONException {
        String title = json.optString("title", "Send Crash Report?");
        String message = json.optString("message", "Looks like we crashed! Please help us fix the problem by sending a crash report.");
        String sendButtonTitle = json.optString("send_button_title", "Send");
        boolean showCancelButton = json.optBoolean("show_cancel_button", true);
        String cancelButtonTitle = json.optString("cancel_button_title", "Don't Send");
        boolean showAlwaysSendButton = json.optBoolean("show_always_send_button", true);
        String alwaysSendButtonTitle = json.optString("always_send_button_title", "Always Send");
        return new PromptSettingsData(title, message, sendButtonTitle, showCancelButton, cancelButtonTitle, showAlwaysSendButton, alwaysSendButtonTitle);
    }

    private BetaSettingsData buildBetaSettingsDataFrom(JSONObject json) throws JSONException {
        String updateUrl = json.optString("update_endpoint", SettingsJsonConstants.BETA_UPDATE_ENDPOINT_DEFAULT);
        int updateSuspendDurationSeconds = json.optInt("update_suspend_duration", 3600);
        return new BetaSettingsData(updateUrl, updateSuspendDurationSeconds);
    }

    private long getExpiresAtFrom(CurrentTimeProvider currentTimeProvider, long cacheDurationSeconds, JSONObject json) throws JSONException {
        long expiresAtMillis = 0L;
        if (json.has("expires_at")) {
            expiresAtMillis = json.getLong("expires_at");
        } else {
            long currentTimeMillis = currentTimeProvider.getCurrentTimeMillis();
            expiresAtMillis = currentTimeMillis + cacheDurationSeconds * 1000L;
        }
        return expiresAtMillis;
    }

    private JSONObject toAppJson(AppSettingsData appData) throws JSONException {
        JSONObject json = new JSONObject().put("identifier", (Object)appData.identifier).put("status", (Object)appData.status).put("url", (Object)appData.url).put("reports_url", (Object)appData.reportsUrl).put("ndk_reports_url", (Object)appData.ndkReportsUrl).put("update_required", appData.updateRequired);
        if (appData.icon != null) {
            json.put("icon", (Object)this.toIconJson(appData.icon));
        }
        return json;
    }

    private JSONObject toIconJson(AppIconSettingsData icon) throws JSONException {
        return new JSONObject().put("hash", (Object)icon.hash).put("width", icon.width).put("height", icon.height);
    }

    private JSONObject toFeaturesJson(FeaturesSettingsData features) throws JSONException {
        return new JSONObject().put("collect_logged_exceptions", features.collectLoggedException).put("collect_reports", features.collectReports).put("collect_analytics", features.collectAnalytics);
    }

    private JSONObject toSessionJson(SessionSettingsData data) throws JSONException {
        return new JSONObject().put("log_buffer_size", data.logBufferSize).put("max_chained_exception_depth", data.maxChainedExceptionDepth).put("max_custom_exception_events", data.maxCustomExceptionEvents).put("max_custom_key_value_pairs", data.maxCustomKeyValuePairs).put("identifier_mask", data.identifierMask).put("send_session_without_crash", data.sendSessionWithoutCrash);
    }

    private JSONObject toAnalyticsJson(AnalyticsSettingsData data) throws JSONException {
        return new JSONObject().put("url", (Object)data.analyticsURL).put("flush_interval_secs", data.flushIntervalSeconds).put("max_byte_size_per_file", data.maxByteSizePerFile).put("max_file_count_per_send", data.maxFileCountPerSend).put("max_pending_send_file_count", data.maxPendingSendFileCount);
    }

    private JSONObject toBetaJson(BetaSettingsData data) throws JSONException {
        return new JSONObject().put("update_endpoint", (Object)data.updateUrl).put("update_suspend_duration", data.updateSuspendDurationSeconds);
    }

    private JSONObject toPromptJson(PromptSettingsData data) throws JSONException {
        return new JSONObject().put("title", (Object)data.title).put("message", (Object)data.message).put("send_button_title", (Object)data.sendButtonTitle).put("show_cancel_button", data.showCancelButton).put("cancel_button_title", (Object)data.cancelButtonTitle).put("show_always_send_button", data.showAlwaysSendButton).put("always_send_button_title", (Object)data.alwaysSendButtonTitle);
    }
}

