/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.settings;

import android.content.res.Resources;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.KitInfo;
import io.fabric.sdk.android.services.common.AbstractSpiCall;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.ResponseParser;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.AppRequestData;
import io.fabric.sdk.android.services.settings.AppSpiCall;
import java.io.InputStream;
import java.util.Locale;

abstract class AbstractAppSpiCall
extends AbstractSpiCall
implements AppSpiCall {
    public static final String APP_IDENTIFIER_PARAM = "app[identifier]";
    public static final String APP_NAME_PARAM = "app[name]";
    public static final String APP_INSTANCE_IDENTIFIER_PARAM = "app[instance_identifier]";
    public static final String APP_DISPLAY_VERSION_PARAM = "app[display_version]";
    public static final String APP_BUILD_VERSION_PARAM = "app[build_version]";
    public static final String APP_SOURCE_PARAM = "app[source]";
    public static final String APP_MIN_SDK_VERSION_PARAM = "app[minimum_sdk_version]";
    public static final String APP_BUILT_SDK_VERSION_PARAM = "app[built_sdk_version]";
    public static final String APP_ICON_HASH_PARAM = "app[icon][hash]";
    public static final String APP_ICON_DATA_PARAM = "app[icon][data]";
    public static final String APP_ICON_WIDTH_PARAM = "app[icon][width]";
    public static final String APP_ICON_HEIGHT_PARAM = "app[icon][height]";
    public static final String APP_ICON_PRERENDERED_PARAM = "app[icon][prerendered]";
    public static final String APP_SDK_MODULES_PARAM_PREFIX = "app[build][libraries][%s]";
    public static final String APP_SDK_MODULES_PARAM_VERSION = "app[build][libraries][%s][version]";
    public static final String APP_SDK_MODULES_PARAM_BUILD_TYPE = "app[build][libraries][%s][type]";
    static final String ICON_FILE_NAME = "icon.png";
    static final String ICON_CONTENT_TYPE = "application/octet-stream";

    public AbstractAppSpiCall(Kit kit, String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, HttpMethod method) {
        super(kit, protocolAndHostOverride, url, requestFactory, method);
    }

    @Override
    public boolean invoke(AppRequestData requestData) {
        HttpRequest httpRequest = this.getHttpRequest();
        httpRequest = this.applyHeadersTo(httpRequest, requestData);
        httpRequest = this.applyMultipartDataTo(httpRequest, requestData);
        Fabric.getLogger().d("Fabric", "Sending app info to " + this.getUrl());
        if (requestData.icon != null) {
            Fabric.getLogger().d("Fabric", "App icon hash is " + requestData.icon.hash);
            Fabric.getLogger().d("Fabric", "App icon size is " + requestData.icon.width + "x" + requestData.icon.height);
        }
        int statusCode = httpRequest.code();
        String kind = "POST".equals(httpRequest.method()) ? "Create" : "Update";
        Fabric.getLogger().d("Fabric", kind + " app request ID: " + httpRequest.header("X-REQUEST-ID"));
        Fabric.getLogger().d("Fabric", "Result was " + statusCode);
        return 0 == ResponseParser.parse(statusCode);
    }

    private HttpRequest applyHeadersTo(HttpRequest request, AppRequestData requestData) {
        return request.header("X-CRASHLYTICS-API-KEY", requestData.apiKey).header("X-CRASHLYTICS-API-CLIENT-TYPE", "android").header("X-CRASHLYTICS-API-CLIENT-VERSION", this.kit.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequest applyMultipartDataTo(HttpRequest request, AppRequestData requestData) {
        request = request.part(APP_IDENTIFIER_PARAM, requestData.appId).part(APP_NAME_PARAM, requestData.name).part(APP_DISPLAY_VERSION_PARAM, requestData.displayVersion).part(APP_BUILD_VERSION_PARAM, requestData.buildVersion).part(APP_SOURCE_PARAM, requestData.source).part(APP_MIN_SDK_VERSION_PARAM, requestData.minSdkVersion).part(APP_BUILT_SDK_VERSION_PARAM, requestData.builtSdkVersion);
        if (!CommonUtils.isNullOrEmpty(requestData.instanceIdentifier)) {
            request.part(APP_INSTANCE_IDENTIFIER_PARAM, requestData.instanceIdentifier);
        }
        if (requestData.icon != null) {
            InputStream is = null;
            try {
                is = this.kit.getContext().getResources().openRawResource(requestData.icon.iconResourceId);
                request.part(APP_ICON_HASH_PARAM, requestData.icon.hash).part(APP_ICON_DATA_PARAM, ICON_FILE_NAME, ICON_CONTENT_TYPE, is).part(APP_ICON_WIDTH_PARAM, requestData.icon.width).part(APP_ICON_HEIGHT_PARAM, requestData.icon.height);
            }
            catch (Resources.NotFoundException e) {
                try {
                    Fabric.getLogger().e("Fabric", "Failed to find app icon with resource ID: " + requestData.icon.iconResourceId, e);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeOrLog(is, "Failed to close app icon InputStream.");
                    throw throwable;
                }
                CommonUtils.closeOrLog(is, "Failed to close app icon InputStream.");
            }
            CommonUtils.closeOrLog(is, "Failed to close app icon InputStream.");
        }
        if (requestData.sdkKits != null) {
            for (KitInfo kit : requestData.sdkKits) {
                request.part(this.getKitVersionKey(kit), kit.getVersion());
                request.part(this.getKitBuildTypeKey(kit), kit.getBuildType());
            }
        }
        return request;
    }

    String getKitVersionKey(KitInfo kit) {
        return String.format(Locale.US, APP_SDK_MODULES_PARAM_VERSION, kit.getIdentifier());
    }

    String getKitBuildTypeKey(KitInfo kit) {
        return String.format(Locale.US, APP_SDK_MODULES_PARAM_BUILD_TYPE, kit.getIdentifier());
    }
}

