/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.persistence;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.persistence.PreferenceStore;

public class PreferenceStoreImpl
implements PreferenceStore {
    private final SharedPreferences sharedPreferences;
    private final String preferenceName;
    private final Context context;

    public PreferenceStoreImpl(Context context, String name) {
        if (context == null) {
            throw new IllegalStateException("Cannot get directory before context has been set. Call Fabric.with() first");
        }
        this.context = context;
        this.preferenceName = name;
        this.sharedPreferences = this.context.getSharedPreferences(this.preferenceName, 0);
    }

    @Deprecated
    public PreferenceStoreImpl(Kit kit) {
        this(kit.getContext(), kit.getClass().getName());
    }

    @Override
    public SharedPreferences get() {
        return this.sharedPreferences;
    }

    @Override
    public SharedPreferences.Editor edit() {
        return this.sharedPreferences.edit();
    }

    @Override
    @TargetApi(value=9)
    public boolean save(SharedPreferences.Editor editor) {
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
            return true;
        }
        return editor.commit();
    }
}

