/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.network;

import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.TreeMap;

public final class UrlUtils {
    public static final String UTF8 = "UTF8";

    private UrlUtils() {
    }

    public static TreeMap<String, String> getQueryParams(URI uri, boolean decode) {
        return UrlUtils.getQueryParams(uri.getRawQuery(), decode);
    }

    public static TreeMap<String, String> getQueryParams(String paramsString, boolean decode) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (paramsString == null) {
            return params;
        }
        for (String nameValuePairString : paramsString.split("&")) {
            String[] nameValuePair = nameValuePairString.split("=");
            if (nameValuePair.length == 2) {
                if (decode) {
                    params.put(UrlUtils.urlDecode(nameValuePair[0]), UrlUtils.urlDecode(nameValuePair[1]));
                    continue;
                }
                params.put(nameValuePair[0], nameValuePair[1]);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)nameValuePair[0])) continue;
            if (decode) {
                params.put(UrlUtils.urlDecode(nameValuePair[0]), "");
                continue;
            }
            params.put(nameValuePair[0], "");
        }
        return params;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, UTF8);
        }
        catch (UnsupportedEncodingException unlikely) {
            throw new RuntimeException(unlikely.getMessage(), unlikely);
        }
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLDecoder.decode(s, UTF8);
        }
        catch (UnsupportedEncodingException unlikely) {
            throw new RuntimeException(unlikely.getMessage(), unlikely);
        }
    }

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String encoded = UrlUtils.urlEncode(s);
        int encodedLength = encoded.length();
        for (int i = 0; i < encodedLength; ++i) {
            char c = encoded.charAt(i);
            if (c == '*') {
                sb.append("%2A");
                continue;
            }
            if (c == '+') {
                sb.append("%20");
                continue;
            }
            if (c == '%' && i + 2 < encodedLength && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                sb.append('~');
                i += 2;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

