/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.events;

import android.content.Context;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.QueueFile;
import io.fabric.sdk.android.services.events.EventsStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QueueFileEventStorage
implements EventsStorage {
    private final Context context;
    private final File workingDirectory;
    private final String targetDirectoryName;
    private final File workingFile;
    private QueueFile queueFile;
    private File targetDirectory;

    public QueueFileEventStorage(Context context, File workingDirectory, String workingFileName, String targetDirectoryName) throws IOException {
        this.context = context;
        this.workingDirectory = workingDirectory;
        this.targetDirectoryName = targetDirectoryName;
        this.workingFile = new File(this.workingDirectory, workingFileName);
        this.queueFile = new QueueFile(this.workingFile);
        this.createTargetDirectory();
    }

    private void createTargetDirectory() {
        this.targetDirectory = new File(this.workingDirectory, this.targetDirectoryName);
        if (!this.targetDirectory.exists()) {
            this.targetDirectory.mkdirs();
        }
    }

    @Override
    public void add(byte[] data) throws IOException {
        this.queueFile.add(data);
    }

    @Override
    public int getWorkingFileUsedSizeInBytes() {
        return this.queueFile.usedBytes();
    }

    @Override
    public void rollOver(String targetName) throws IOException {
        this.queueFile.close();
        this.move(this.workingFile, new File(this.targetDirectory, targetName));
        this.queueFile = new QueueFile(this.workingFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(File sourceFile, File targetFile) throws IOException {
        OutputStream fos = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFile);
            fos = this.getMoveOutputStream(targetFile);
            CommonUtils.copyStream(fis, fos, new byte[1024]);
        }
        catch (Throwable throwable) {
            CommonUtils.closeOrLog(fis, "Failed to close file input stream");
            CommonUtils.closeOrLog(fos, "Failed to close output stream");
            sourceFile.delete();
            throw throwable;
        }
        CommonUtils.closeOrLog(fis, "Failed to close file input stream");
        CommonUtils.closeOrLog(fos, "Failed to close output stream");
        sourceFile.delete();
    }

    public OutputStream getMoveOutputStream(File targetFile) throws IOException {
        return new FileOutputStream(targetFile);
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public File getRollOverDirectory() {
        return this.targetDirectory;
    }

    @Override
    public List<File> getBatchOfFilesToSend(int maxBatchSize) {
        ArrayList<File> batch = new ArrayList<File>();
        for (File file : this.targetDirectory.listFiles()) {
            batch.add(file);
            if (batch.size() >= maxBatchSize) break;
        }
        return batch;
    }

    @Override
    public void deleteFilesInRollOverDirectory(List<File> files) {
        for (File file : files) {
            CommonUtils.logControlled(this.context, String.format("deleting sent analytics file %s", file.getName()));
            file.delete();
        }
    }

    @Override
    public List<File> getAllFilesInRollOverDirectory() {
        return Arrays.asList(this.targetDirectory.listFiles());
    }

    @Override
    public void deleteWorkingFile() {
        try {
            this.queueFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.workingFile.delete();
    }

    @Override
    public boolean isWorkingFileEmpty() {
        return this.queueFile.isEmpty();
    }

    @Override
    public boolean canWorkingFileStore(int newEventSizeInBytes, int maxByteSizePerFile) {
        return this.queueFile.hasSpaceFor(newEventSizeInBytes, maxByteSizePerFile);
    }
}

