/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.AdvertisingInfo;
import io.fabric.sdk.android.services.common.AdvertisingInfoProvider;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.DeviceIdentifierProvider;
import io.fabric.sdk.android.services.common.FirebaseInfo;
import io.fabric.sdk.android.services.common.InstallerPackageNameProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class IdManager {
    public static final String COLLECT_DEVICE_IDENTIFIERS = "com.crashlytics.CollectDeviceIdentifiers";
    public static final String COLLECT_USER_IDENTIFIERS = "com.crashlytics.CollectUserIdentifiers";
    public static final String DEFAULT_VERSION_NAME = "0.0";
    static final String PREFKEY_ADVERTISING_ID = "crashlytics.advertising.id";
    private static final String PREFKEY_INSTALLATION_UUID = "crashlytics.installation.id";
    private static final Pattern ID_PATTERN = Pattern.compile("[^\\p{Alnum}]");
    private static final String BAD_ANDROID_ID = "9774d56d682e549c";
    private static final String FORWARD_SLASH_REGEX = Pattern.quote("/");
    private final ReentrantLock installationIdLock = new ReentrantLock();
    private final InstallerPackageNameProvider installerPackageNameProvider;
    private final boolean collectHardwareIds;
    private final boolean collectUserIds;
    private final Context appContext;
    private final String appIdentifier;
    private final String appInstallIdentifier;
    private final Collection<Kit> kits;
    AdvertisingInfoProvider advertisingInfoProvider;
    AdvertisingInfo advertisingInfo;
    boolean fetchedAdvertisingInfo;
    FirebaseInfo firebaseInfo;

    public IdManager(Context appContext, String appIdentifier, String appInstallIdentifier, Collection<Kit> kits) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext must not be null");
        }
        if (appIdentifier == null) {
            throw new IllegalArgumentException("appIdentifier must not be null");
        }
        if (kits == null) {
            throw new IllegalArgumentException("kits must not be null");
        }
        this.appContext = appContext;
        this.appIdentifier = appIdentifier;
        this.appInstallIdentifier = appInstallIdentifier;
        this.kits = kits;
        this.installerPackageNameProvider = new InstallerPackageNameProvider();
        this.advertisingInfoProvider = new AdvertisingInfoProvider(appContext);
        this.firebaseInfo = new FirebaseInfo();
        this.collectHardwareIds = CommonUtils.getBooleanResourceValue(appContext, COLLECT_DEVICE_IDENTIFIERS, true);
        if (!this.collectHardwareIds) {
            Fabric.getLogger().d("Fabric", "Device ID collection disabled for " + appContext.getPackageName());
        }
        this.collectUserIds = CommonUtils.getBooleanResourceValue(appContext, COLLECT_USER_IDENTIFIERS, true);
        if (!this.collectUserIds) {
            Fabric.getLogger().d("Fabric", "User information collection disabled for " + appContext.getPackageName());
        }
    }

    @Deprecated
    public String createIdHeaderValue(String apiKey, String packageName) {
        return "";
    }

    public boolean canCollectUserIds() {
        return this.collectUserIds;
    }

    private String formatId(String id) {
        return id == null ? null : ID_PATTERN.matcher(id).replaceAll("").toLowerCase(Locale.US);
    }

    public String getAppInstallIdentifier() {
        String appInstallId = this.appInstallIdentifier;
        if (appInstallId == null) {
            SharedPreferences prefs = CommonUtils.getSharedPrefs(this.appContext);
            this.checkAdvertisingIdRotation(prefs);
            appInstallId = prefs.getString(PREFKEY_INSTALLATION_UUID, null);
            if (appInstallId == null) {
                appInstallId = this.createInstallationUUID(prefs);
            }
        }
        return appInstallId;
    }

    public String getAppIdentifier() {
        return this.appIdentifier;
    }

    public String getOsVersionString() {
        return this.getOsDisplayVersionString() + "/" + this.getOsBuildVersionString();
    }

    public String getOsDisplayVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.RELEASE);
    }

    public String getOsBuildVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.INCREMENTAL);
    }

    public String getModelName() {
        return String.format(Locale.US, "%s/%s", this.removeForwardSlashesIn(Build.MANUFACTURER), this.removeForwardSlashesIn(Build.MODEL));
    }

    private String removeForwardSlashesIn(String s) {
        return s.replaceAll(FORWARD_SLASH_REGEX, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    private String createInstallationUUID(SharedPreferences prefs) {
        this.installationIdLock.lock();
        try {
            String uuid = prefs.getString(PREFKEY_INSTALLATION_UUID, null);
            if (uuid == null) {
                uuid = this.formatId(UUID.randomUUID().toString());
                prefs.edit().putString(PREFKEY_INSTALLATION_UUID, uuid).commit();
            }
            String string = uuid;
            return string;
        }
        finally {
            this.installationIdLock.unlock();
        }
    }

    private void checkAdvertisingIdRotation(SharedPreferences prefs) {
        AdvertisingInfo newAdInfo = this.getAdvertisingInfo();
        if (newAdInfo != null) {
            this.flushInstallationIdIfNecessary(prefs, newAdInfo.advertisingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    private void flushInstallationIdIfNecessary(SharedPreferences prefs, String advertisingId) {
        this.installationIdLock.lock();
        try {
            if (TextUtils.isEmpty((CharSequence)advertisingId)) {
                return;
            }
            String oldId = prefs.getString(PREFKEY_ADVERTISING_ID, null);
            if (TextUtils.isEmpty((CharSequence)oldId)) {
                prefs.edit().putString(PREFKEY_ADVERTISING_ID, advertisingId).commit();
            } else if (!oldId.equals(advertisingId)) {
                prefs.edit().remove(PREFKEY_INSTALLATION_UUID).putString(PREFKEY_ADVERTISING_ID, advertisingId).commit();
            }
        }
        finally {
            this.installationIdLock.unlock();
        }
    }

    public Map<DeviceIdentifierType, String> getDeviceIdentifiers() {
        HashMap<DeviceIdentifierType, String> ids = new HashMap<DeviceIdentifierType, String>();
        for (Kit kit : this.kits) {
            if (!(kit instanceof DeviceIdentifierProvider)) continue;
            DeviceIdentifierProvider idProvider = (DeviceIdentifierProvider)((Object)kit);
            Map<DeviceIdentifierType, String> kitIds = idProvider.getDeviceIdentifiers();
            for (Map.Entry<DeviceIdentifierType, String> entry : kitIds.entrySet()) {
                this.putNonNullIdInto(ids, entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(ids);
    }

    public String getInstallerPackageName() {
        return this.installerPackageNameProvider.getInstallerPackageName(this.appContext);
    }

    public Boolean isLimitAdTrackingEnabled() {
        Boolean toReturn = null;
        if (this.shouldCollectHardwareIds()) {
            toReturn = this.explicitCheckLimitAdTracking();
        }
        return toReturn;
    }

    @Deprecated
    public String getAdvertisingId() {
        return null;
    }

    private void putNonNullIdInto(Map<DeviceIdentifierType, String> idMap, DeviceIdentifierType idKey, String idValue) {
        if (idValue != null) {
            idMap.put(idKey, idValue);
        }
    }

    @Deprecated
    public String getAndroidId() {
        return null;
    }

    @Deprecated
    public String getTelephonyId() {
        return null;
    }

    @Deprecated
    public String getWifiMacAddress() {
        return null;
    }

    @Deprecated
    public String getBluetoothMacAddress() {
        return null;
    }

    @Deprecated
    public String getSerialNumber() {
        return null;
    }

    protected boolean shouldCollectHardwareIds() {
        return this.collectHardwareIds && !this.firebaseInfo.isFirebaseCrashlyticsEnabled(this.appContext);
    }

    synchronized AdvertisingInfo getAdvertisingInfo() {
        if (!this.fetchedAdvertisingInfo) {
            this.advertisingInfo = this.advertisingInfoProvider.getAdvertisingInfo();
            this.fetchedAdvertisingInfo = true;
        }
        return this.advertisingInfo;
    }

    private Boolean explicitCheckLimitAdTracking() {
        AdvertisingInfo advertisingInfo = this.getAdvertisingInfo();
        if (advertisingInfo != null) {
            return advertisingInfo.limitAdTrackingEnabled;
        }
        return null;
    }

    public static enum DeviceIdentifierType {
        WIFI_MAC_ADDRESS(1),
        BLUETOOTH_MAC_ADDRESS(2),
        FONT_TOKEN(53),
        ANDROID_ID(100),
        ANDROID_DEVICE_ID(101),
        ANDROID_SERIAL(102),
        ANDROID_ADVERTISING_ID(103);

        public final int protobufIndex;

        private DeviceIdentifierType(int pbufIndex) {
            this.protobufIndex = pbufIndex;
        }
    }
}

