/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.content.Context;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.FirebaseApp;
import java.lang.reflect.Method;

final class FirebaseAppImpl
implements FirebaseApp {
    private static final String FIREBASE_APP_CLASS = "com.google.firebase.FirebaseApp";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private static final String IS_DATA_COLLECTION_ENABLED_METHOD = "isDataCollectionDefaultEnabled";
    private final Method isDataCollectionDefaultEnabledMethod;
    private final Object firebaseAppInstance;

    public static FirebaseApp getInstance(Context context) {
        try {
            Class<?> firebaseAppClass = context.getClassLoader().loadClass(FIREBASE_APP_CLASS);
            Method getInstanceMethod = firebaseAppClass.getDeclaredMethod(GET_INSTANCE_METHOD, new Class[0]);
            Object instance = getInstanceMethod.invoke(firebaseAppClass, new Object[0]);
            return new FirebaseAppImpl(firebaseAppClass, instance);
        }
        catch (ClassNotFoundException e) {
            Fabric.getLogger().d("Fabric", "Could not find class: com.google.firebase.FirebaseApp");
        }
        catch (NoSuchMethodException e) {
            Fabric.getLogger().d("Fabric", "Could not find method: " + e.getMessage());
        }
        catch (Exception e) {
            Fabric.getLogger().d("Fabric", "Unexpected error loading FirebaseApp instance.", e);
        }
        return null;
    }

    private FirebaseAppImpl(Class firebaseAppClass, Object instance) throws NoSuchMethodException {
        this.firebaseAppInstance = instance;
        this.isDataCollectionDefaultEnabledMethod = firebaseAppClass.getDeclaredMethod(IS_DATA_COLLECTION_ENABLED_METHOD, new Class[0]);
    }

    @Override
    public boolean isDataCollectionDefaultEnabled() {
        try {
            return (Boolean)this.isDataCollectionDefaultEnabledMethod.invoke(this.firebaseAppInstance, new Object[0]);
        }
        catch (Exception e) {
            Fabric.getLogger().d("Fabric", "Cannot check isDataCollectionDefaultEnabled on FirebaseApp.", e);
            return false;
        }
    }
}

