/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.text.TextUtils;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.FirebaseInfo;

public class ApiKey {
    static final String FABRIC_API_KEY = "io.fabric.ApiKey";
    static final String CRASHLYTICS_API_KEY = "com.crashlytics.ApiKey";
    static final String STRING_TWITTER_CONSUMER_SECRET = "@string/twitter_consumer_secret";

    @Deprecated
    public static String getApiKey(Context context) {
        Fabric.getLogger().w("Fabric", "getApiKey(context) is deprecated, please upgrade kit(s) to the latest version.");
        return new ApiKey().getValue(context);
    }

    @Deprecated
    public static String getApiKey(Context context, boolean debug) {
        Fabric.getLogger().w("Fabric", "getApiKey(context, debug) is deprecated, please upgrade kit(s) to the latest version.");
        return new ApiKey().getValue(context);
    }

    public String getValue(Context context) {
        String apiKey = this.getApiKeyFromManifest(context);
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            apiKey = this.getApiKeyFromStrings(context);
        }
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            apiKey = this.getApiKeyFromFirebaseAppId(context);
        }
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            this.logErrorOrThrowException(context);
        }
        return apiKey;
    }

    protected String getApiKeyFromFirebaseAppId(Context context) {
        return new FirebaseInfo().getApiKeyFromFirebaseAppId(context);
    }

    protected String getApiKeyFromManifest(Context context) {
        String apiKey = null;
        try {
            String packageName = context.getPackageName();
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(packageName, 128);
            Bundle bundle = ai.metaData;
            if (bundle != null) {
                apiKey = bundle.getString(FABRIC_API_KEY);
                if (STRING_TWITTER_CONSUMER_SECRET.equals(apiKey)) {
                    Fabric.getLogger().d("Fabric", "Ignoring bad default value for Fabric ApiKey set by FirebaseUI-Auth");
                    apiKey = null;
                }
                if (apiKey == null) {
                    Fabric.getLogger().d("Fabric", "Falling back to Crashlytics key lookup from Manifest");
                    apiKey = bundle.getString(CRASHLYTICS_API_KEY);
                }
            }
        }
        catch (Exception e) {
            Fabric.getLogger().d("Fabric", "Caught non-fatal exception while retrieving apiKey: " + e);
        }
        return apiKey;
    }

    protected String getApiKeyFromStrings(Context context) {
        String apiKey = null;
        int id = CommonUtils.getResourcesIdentifier(context, FABRIC_API_KEY, "string");
        if (id == 0) {
            Fabric.getLogger().d("Fabric", "Falling back to Crashlytics key lookup from Strings");
            id = CommonUtils.getResourcesIdentifier(context, CRASHLYTICS_API_KEY, "string");
        }
        if (id != 0) {
            apiKey = context.getResources().getString(id);
        }
        return apiKey;
    }

    protected void logErrorOrThrowException(Context context) {
        if (Fabric.isDebuggable() || CommonUtils.isAppDebuggable(context)) {
            throw new IllegalArgumentException(this.buildApiKeyInstructions());
        }
        Fabric.getLogger().e("Fabric", this.buildApiKeyInstructions());
    }

    protected String buildApiKeyInstructions() {
        return "Fabric could not be initialized, API key missing from AndroidManifest.xml. Add the following tag to your Application element \n\t<meta-data android:name=\"io.fabric.ApiKey\" android:value=\"YOUR_API_KEY\"/>";
    }
}

