/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android;

import android.os.SystemClock;
import android.text.TextUtils;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.KitInfo;
import io.fabric.sdk.android.services.common.CommonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class FabricKitsFinder
implements Callable<Map<String, KitInfo>> {
    static final String FABRIC_DIR = "fabric/";
    private static final String FABRIC_IDENTIFIER_KEY = "fabric-identifier";
    private static final String FABRIC_VERSION_KEY = "fabric-version";
    private static final String FABRIC_BUILD_TYPE_KEY = "fabric-build-type";
    final String apkFileName;

    FabricKitsFinder(String apkFileName) {
        this.apkFileName = apkFileName;
    }

    @Override
    public Map<String, KitInfo> call() throws Exception {
        HashMap<String, KitInfo> kitInfos = new HashMap<String, KitInfo>();
        long startScan = SystemClock.elapsedRealtime();
        kitInfos.putAll(this.findImplicitKits());
        kitInfos.putAll(this.findRegisteredKits());
        Fabric.getLogger().v("Fabric", "finish scanning in " + (SystemClock.elapsedRealtime() - startScan));
        return kitInfos;
    }

    private Map<String, KitInfo> findImplicitKits() {
        HashMap<String, KitInfo> implicitKits = new HashMap<String, KitInfo>();
        try {
            Class.forName("com.google.android.gms.ads.AdView");
            KitInfo admobKitInfo = new KitInfo("com.google.firebase.firebase-ads", "0.0.0", "binary");
            implicitKits.put(admobKitInfo.getIdentifier(), admobKitInfo);
            Fabric.getLogger().v("Fabric", "Found kit: com.google.firebase.firebase-ads");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return implicitKits;
    }

    private Map<String, KitInfo> findRegisteredKits() throws Exception {
        HashMap<String, KitInfo> registeredKits = new HashMap<String, KitInfo>();
        ZipFile apkFile = this.loadApkFile();
        Enumeration<? extends ZipEntry> entries = apkFile.entries();
        while (entries.hasMoreElements()) {
            KitInfo kitInfo;
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(FABRIC_DIR) || entry.getName().length() <= FABRIC_DIR.length() || (kitInfo = this.loadKitInfo(entry, apkFile)) == null) continue;
            registeredKits.put(kitInfo.getIdentifier(), kitInfo);
            Fabric.getLogger().v("Fabric", String.format("Found kit:[%s] version:[%s]", kitInfo.getIdentifier(), kitInfo.getVersion()));
        }
        try {
            if (apkFile != null) {
                apkFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return registeredKits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KitInfo loadKitInfo(ZipEntry fabricFile, ZipFile apk) {
        InputStream inputStream = null;
        try {
            inputStream = apk.getInputStream(fabricFile);
            Properties properties = new Properties();
            properties.load(inputStream);
            String id = properties.getProperty(FABRIC_IDENTIFIER_KEY);
            String version = properties.getProperty(FABRIC_VERSION_KEY);
            String buildType = properties.getProperty(FABRIC_BUILD_TYPE_KEY);
            if (TextUtils.isEmpty((CharSequence)id) || TextUtils.isEmpty((CharSequence)version)) {
                throw new IllegalStateException("Invalid format of fabric file," + fabricFile.getName());
            }
            KitInfo kitInfo = new KitInfo(id, version, buildType);
            return kitInfo;
        }
        catch (IOException ie) {
            Fabric.getLogger().e("Fabric", "Error when parsing fabric properties " + fabricFile.getName(), ie);
        }
        finally {
            CommonUtils.closeQuietly(inputStream);
        }
        return null;
    }

    protected ZipFile loadApkFile() throws IOException {
        return new ZipFile(this.apkFileName);
    }
}

