/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.network;

import android.content.Context;
import android.os.Build;
import android.os.NetworkOnMainThreadException;
import android.util.Log;
import io.branch.referral.PrefHelper;
import io.branch.referral.network.BranchRemoteInterface;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchRemoteInterfaceUrlConnection
extends BranchRemoteInterface {
    private static final int DEFAULT_TIMEOUT = 3000;
    PrefHelper prefHelper;

    BranchRemoteInterfaceUrlConnection(Context context) {
        this.prefHelper = PrefHelper.getInstance(context);
    }

    @Override
    public BranchRemoteInterface.BranchResponse doRestfulGet(String url) throws BranchRemoteInterface.BranchRemoteException {
        return this.doRestfulGet(url, 0);
    }

    @Override
    public BranchRemoteInterface.BranchResponse doRestfulPost(String url, JSONObject payload) throws BranchRemoteInterface.BranchRemoteException {
        return this.doRestfulPost(url, payload, 0);
    }

    private BranchRemoteInterface.BranchResponse doRestfulGet(String url, int retryNumber) throws BranchRemoteInterface.BranchRemoteException {
        HttpURLConnection connection = null;
        try {
            int timeout = this.prefHelper.getTimeout();
            if (timeout <= 0) {
                timeout = 3000;
            }
            String appendKey = url.contains("?") ? "&" : "?";
            String modifiedUrl = url + appendKey + "retryNumber" + "=" + retryNumber;
            URL urlObject = new URL(modifiedUrl);
            connection = (HttpsURLConnection)urlObject.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            int responseCode = connection.getResponseCode();
            if (responseCode >= 500 && retryNumber < this.prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(this.prefHelper.getRetryInterval());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                BranchRemoteInterface.BranchResponse e = this.doRestfulGet(url, ++retryNumber);
                return e;
            }
            if (responseCode != 200 && connection.getErrorStream() != null) {
                BranchRemoteInterface.BranchResponse e = new BranchRemoteInterface.BranchResponse(this.getResponseString(connection.getErrorStream()), responseCode);
                return e;
            }
            BranchRemoteInterface.BranchResponse e = new BranchRemoteInterface.BranchResponse(this.getResponseString(connection.getInputStream()), responseCode);
            return e;
        }
        catch (SocketException ex) {
            PrefHelper.Debug(this.getClass().getSimpleName(), "Http connect exception: " + ex.getMessage());
            throw new BranchRemoteInterface.BranchRemoteException(-113);
        }
        catch (SocketTimeoutException ex) {
            if (retryNumber < this.prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(this.prefHelper.getRetryInterval());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                BranchRemoteInterface.BranchResponse branchResponse = this.doRestfulGet(url, ++retryNumber);
                return branchResponse;
            }
            throw new BranchRemoteInterface.BranchRemoteException(-111);
        }
        catch (IOException ex) {
            PrefHelper.Debug(this.getClass().getSimpleName(), "Branch connect exception: " + ex.getMessage());
            throw new BranchRemoteInterface.BranchRemoteException(-113);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BranchRemoteInterface.BranchResponse doRestfulPost(String url, JSONObject payload, int retryNumber) throws BranchRemoteInterface.BranchRemoteException {
        BranchRemoteInterface.BranchResponse branchResponse;
        HttpURLConnection connection = null;
        int timeout = this.prefHelper.getTimeout();
        if (timeout <= 0) {
            timeout = 3000;
        }
        try {
            payload.put("retryNumber", retryNumber);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            URL urlObject = new URL(url);
            connection = (HttpsURLConnection)urlObject.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestMethod("POST");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            outputStreamWriter.write(payload.toString());
            outputStreamWriter.flush();
            int responseCode = connection.getResponseCode();
            if (responseCode >= 500 && retryNumber < this.prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(this.prefHelper.getRetryInterval());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                BranchRemoteInterface.BranchResponse e = this.doRestfulPost(url, payload, ++retryNumber);
                return e;
            }
            if (responseCode != 200 && connection.getErrorStream() != null) {
                BranchRemoteInterface.BranchResponse e = new BranchRemoteInterface.BranchResponse(this.getResponseString(connection.getErrorStream()), responseCode);
                return e;
            }
            BranchRemoteInterface.BranchResponse e = new BranchRemoteInterface.BranchResponse(this.getResponseString(connection.getInputStream()), responseCode);
            return e;
        }
        catch (SocketTimeoutException ex) {
            if (retryNumber < this.prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(this.prefHelper.getRetryInterval());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                branchResponse = this.doRestfulPost(url, payload, ++retryNumber);
                return branchResponse;
            }
            throw new BranchRemoteInterface.BranchRemoteException(-111);
        }
        catch (IOException ex) {
            PrefHelper.Debug(this.getClass().getSimpleName(), "Http connect exception: " + ex.getMessage());
            throw new BranchRemoteInterface.BranchRemoteException(-113);
        }
        catch (Exception ex) {
            PrefHelper.Debug(this.getClass().getSimpleName(), "Exception: " + ex.getMessage());
            if (Build.VERSION.SDK_INT >= 11 && ex instanceof NetworkOnMainThreadException) {
                Log.i((String)"BranchSDK", (String)"Branch Error: Don't call our synchronous methods on the main thread!!!");
            }
            branchResponse = new BranchRemoteInterface.BranchResponse(null, 500);
            return branchResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String getResponseString(InputStream inputStream) {
        String responseString = null;
        if (inputStream != null) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            try {
                responseString = rd.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return responseString;
    }
}

