/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import io.branch.referral.ApkParser;
import io.branch.referral.BranchAsyncTask;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SystemObserver {
    public static final String BLANK = "bnc_no_value";
    private static final int STATE_FRESH_INSTALL = 0;
    private static final int STATE_UPDATE = 2;
    private static final int STATE_NO_CHANGE = 1;
    private static final int GAID_FETCH_TIME_OUT = 1500;
    String GAIDString_ = null;
    int LATVal_ = 0;
    private Context context_;
    private boolean isRealHardwareId;

    public SystemObserver(Context context) {
        this.context_ = context;
        this.isRealHardwareId = true;
    }

    public String getUniqueID(boolean debug) {
        if (this.context_ != null) {
            String androidID = null;
            if (!debug) {
                androidID = Settings.Secure.getString((ContentResolver)this.context_.getContentResolver(), (String)"android_id");
            }
            if (androidID == null) {
                androidID = UUID.randomUUID().toString();
                this.isRealHardwareId = false;
            }
            return androidID;
        }
        return BLANK;
    }

    public boolean hasRealHardwareId() {
        return this.isRealHardwareId;
    }

    public String getPackageName() {
        String packageName = "";
        try {
            PackageInfo info = this.context_.getPackageManager().getPackageInfo(this.context_.getPackageName(), 0);
            packageName = info.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return packageName;
    }

    public String getURIScheme() {
        return this.getURIScheme(this.context_.getPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURIScheme(String packageName) {
        String scheme = BLANK;
        if (!this.isLowOnMemory()) {
            PackageManager pm = this.context_.getPackageManager();
            try {
                ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
                String sourceApk = ai.publicSourceDir;
                JarFile jf = null;
                InputStream is = null;
                try {
                    jf = new JarFile(sourceApk);
                    is = jf.getInputStream(jf.getEntry("AndroidManifest.xml"));
                    byte[] xml = new byte[is.available()];
                    is.read(xml);
                    scheme = new ApkParser().decompressXML(xml);
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                            is = null;
                        }
                        if (jf != null) {
                            jf.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return scheme;
    }

    private boolean isLowOnMemory() {
        ActivityManager activityManager = (ActivityManager)this.context_.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(mi);
        return mi.lowMemory;
    }

    @SuppressLint(value={"NewApi"})
    public JSONArray getListOfApps() {
        JSONArray arr = new JSONArray();
        PackageManager pm = this.context_.getPackageManager();
        List packages = pm.getInstalledApplications(128);
        if (packages != null) {
            for (ApplicationInfo appInfo : packages) {
                if ((appInfo.flags & 1) == 1) continue;
                JSONObject packObj = new JSONObject();
                try {
                    PackageInfo packInfo;
                    String sourceDir;
                    String pSourceDir;
                    String packName;
                    String label;
                    CharSequence labelCs = appInfo.loadLabel(pm);
                    String string = label = labelCs == null ? null : labelCs.toString();
                    if (label != null) {
                        packObj.put("name", (Object)label);
                    }
                    if ((packName = appInfo.packageName) != null) {
                        packObj.put(Defines.Jsonkey.AppIdentifier.getKey(), (Object)packName);
                        String uriScheme = this.getURIScheme(packName);
                        if (!uriScheme.equals(BLANK)) {
                            packObj.put(Defines.Jsonkey.URIScheme.getKey(), (Object)uriScheme);
                        }
                    }
                    if ((pSourceDir = appInfo.publicSourceDir) != null) {
                        packObj.put("public_source_dir", (Object)pSourceDir);
                    }
                    if ((sourceDir = appInfo.sourceDir) != null) {
                        packObj.put("source_dir", (Object)sourceDir);
                    }
                    if ((packInfo = pm.getPackageInfo(appInfo.packageName, 4096)) != null) {
                        if (packInfo.versionCode >= 9) {
                            packObj.put("install_date", packInfo.firstInstallTime);
                            packObj.put("last_update_date", packInfo.lastUpdateTime);
                        }
                        packObj.put("version_code", packInfo.versionCode);
                        if (packInfo.versionName != null) {
                            packObj.put("version_name", (Object)packInfo.versionName);
                        }
                    }
                    packObj.put(Defines.Jsonkey.OS.getKey(), (Object)this.getOS());
                    arr.put((Object)packObj);
                }
                catch (PackageManager.NameNotFoundException | JSONException throwable) {}
            }
        }
        return arr;
    }

    public String getAppVersion() {
        try {
            PackageInfo packageInfo = this.context_.getPackageManager().getPackageInfo(this.context_.getPackageName(), 0);
            if (packageInfo.versionName != null) {
                return packageInfo.versionName;
            }
            return BLANK;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return BLANK;
        }
    }

    public String getPhoneBrand() {
        return Build.MANUFACTURER;
    }

    public String getPhoneModel() {
        return Build.MODEL;
    }

    public String getISO2CountryCode() {
        if (Locale.getDefault() != null) {
            return Locale.getDefault().getCountry();
        }
        return "";
    }

    public String getISO2LanguageCode() {
        if (Locale.getDefault() != null) {
            return Locale.getDefault().getLanguage();
        }
        return "";
    }

    public String getOS() {
        return "Android";
    }

    public int getOSVersion() {
        return Build.VERSION.SDK_INT;
    }

    public boolean isSimulator() {
        return Build.FINGERPRINT.contains("generic");
    }

    @SuppressLint(value={"NewApi"})
    public int getUpdateState() {
        PrefHelper pHelper = PrefHelper.getInstance(this.context_);
        String currAppVersion = this.getAppVersion();
        if (BLANK.equals(pHelper.getAppVersion())) {
            if (Build.VERSION.SDK_INT >= 9) {
                try {
                    PackageInfo packageInfo = this.context_.getPackageManager().getPackageInfo(this.context_.getPackageName(), 0);
                    if (packageInfo.lastUpdateTime != packageInfo.firstInstallTime) {
                        return 2;
                    }
                    return 0;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            return 0;
        }
        if (!pHelper.getAppVersion().equals(currAppVersion)) {
            return 2;
        }
        return 1;
    }

    public DisplayMetrics getScreenDisplay() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = ((WindowManager)this.context_.getSystemService("window")).getDefaultDisplay();
        display.getMetrics(displayMetrics);
        return displayMetrics;
    }

    public boolean getWifiConnected() {
        if (0 == this.context_.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager connManager = (ConnectivityManager)this.context_.getSystemService("connectivity");
            NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
            return wifiInfo != null && wifiInfo.isConnected();
        }
        return false;
    }

    public Object getAdInfoObject() {
        Object adInfoObj = null;
        try {
            Class<?> AdvertisingIdClientClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            Method getAdvertisingIdInfoMethod = AdvertisingIdClientClass.getMethod("getAdvertisingIdInfo", Context.class);
            adInfoObj = getAdvertisingIdInfoMethod.invoke(null, this.context_);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return adInfoObj;
    }

    public String getAdvertisingId(Object adInfoObj) {
        try {
            Method getIdMethod = adInfoObj.getClass().getMethod("getId", new Class[0]);
            this.GAIDString_ = (String)getIdMethod.invoke(adInfoObj, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.GAIDString_;
    }

    public int getLATValue(Object adInfoObj) {
        try {
            Method getLatMethod = adInfoObj.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
            this.LATVal_ = (Boolean)getLatMethod.invoke(adInfoObj, new Object[0]) != false ? 1 : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.LATVal_;
    }

    public boolean prefetchGAdsParams(GAdsParamsFetchEvents callback) {
        boolean isPrefetchStarted = false;
        if (TextUtils.isEmpty((CharSequence)this.GAIDString_)) {
            isPrefetchStarted = true;
            new GAdsPrefetchTask(callback).executeTask(new Void[0]);
        }
        return isPrefetchStarted;
    }

    public static String getLocalIPAddress() {
        String ipAddress = "";
        try {
            ArrayList<NetworkInterface> netInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            block2: for (NetworkInterface netInterface : netInterfaces) {
                ArrayList<InetAddress> addresses = Collections.list(netInterface.getInetAddresses());
                for (InetAddress address : addresses) {
                    String ip;
                    boolean isIPv4;
                    if (address.isLoopbackAddress() || !(isIPv4 = (ip = address.getHostAddress()).indexOf(58) < 0)) continue;
                    ipAddress = ip;
                    continue block2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ipAddress;
    }

    static interface GAdsParamsFetchEvents {
        public void onGAdsFetchFinished();
    }

    private class GAdsPrefetchTask
    extends BranchAsyncTask<Void, Void, Void> {
        private final GAdsParamsFetchEvents callback_;

        public GAdsPrefetchTask(GAdsParamsFetchEvents callback) {
            this.callback_ = callback;
        }

        protected Void doInBackground(Void ... params) {
            final CountDownLatch latch = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Process.setThreadPriority((int)-19);
                    Object adInfoObj = SystemObserver.this.getAdInfoObject();
                    SystemObserver.this.getAdvertisingId(adInfoObj);
                    SystemObserver.this.getLATValue(adInfoObj);
                    latch.countDown();
                }
            }).start();
            try {
                latch.await(1500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            if (this.callback_ != null) {
                this.callback_.onGAdsFetchFinished();
            }
        }
    }
}

