/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerResponse;
import io.branch.referral.SystemObserver;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestRegisterOpen
extends ServerRequestInitSession {
    Branch.BranchReferralInitListener callback_;
    final SystemObserver systemObserver_;

    public ServerRequestRegisterOpen(Context context, Branch.BranchReferralInitListener callback, SystemObserver sysObserver) {
        super(context, Defines.RequestPath.RegisterOpen.getPath());
        this.systemObserver_ = sysObserver;
        this.callback_ = callback;
        JSONObject openPost = new JSONObject();
        try {
            openPost.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
            openPost.put(Defines.Jsonkey.IdentityID.getKey(), (Object)this.prefHelper_.getIdentityID());
            openPost.put(Defines.Jsonkey.IsReferrable.getKey(), this.prefHelper_.getIsReferrable());
            if (!sysObserver.getAppVersion().equals("bnc_no_value")) {
                openPost.put(Defines.Jsonkey.AppVersion.getKey(), (Object)sysObserver.getAppVersion());
            }
            openPost.put(Defines.Jsonkey.FaceBookAppLinkChecked.getKey(), this.prefHelper_.getIsAppLinkTriggeredInit());
            openPost.put(Defines.Jsonkey.Update.getKey(), sysObserver.getUpdateState());
            openPost.put(Defines.Jsonkey.Debug.getKey(), this.prefHelper_.getExternDebug());
            this.setPost(openPost);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
    }

    public ServerRequestRegisterOpen(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
        this.systemObserver_ = new SystemObserver(context);
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        super.onRequestSucceeded(resp, branch);
        try {
            JSONObject dataObj;
            if (resp.getObject().has(Defines.Jsonkey.LinkClickID.getKey())) {
                this.prefHelper_.setLinkClickID(resp.getObject().getString(Defines.Jsonkey.LinkClickID.getKey()));
            } else {
                this.prefHelper_.setLinkClickID("bnc_no_value");
            }
            if (resp.getObject().has(Defines.Jsonkey.Data.getKey()) && (dataObj = new JSONObject(resp.getObject().getString(Defines.Jsonkey.Data.getKey()))).has(Defines.Jsonkey.Clicked_Branch_Link.getKey()) && dataObj.getBoolean(Defines.Jsonkey.Clicked_Branch_Link.getKey()) && this.prefHelper_.getInstallParams().equals("bnc_no_value") && this.prefHelper_.getIsReferrable() == 1) {
                String params = resp.getObject().getString(Defines.Jsonkey.Data.getKey());
                this.prefHelper_.setInstallParams(params);
            }
            if (resp.getObject().has(Defines.Jsonkey.Data.getKey())) {
                String params = resp.getObject().getString(Defines.Jsonkey.Data.getKey());
                this.prefHelper_.setSessionParams(params);
            } else {
                this.prefHelper_.setSessionParams("bnc_no_value");
            }
            if (this.callback_ != null) {
                this.callback_.onInitFinished(branch.getLatestReferringParams(), null);
            }
            this.prefHelper_.setAppVersion(this.systemObserver_.getAppVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.onInitSessionCompleted(resp, branch);
    }

    public void setInitFinishedCallback(Branch.BranchReferralInitListener callback) {
        if (callback != null) {
            this.callback_ = callback;
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("error_message", (Object)"Trouble reaching server. Please try again in a few minutes");
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
            this.callback_.onInitFinished(obj, new BranchError("Trouble initializing Branch. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onInitFinished(null, new BranchError("Trouble initializing Branch.", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }

    @Override
    public boolean hasCallBack() {
        return this.callback_ != null;
    }

    @Override
    public String getRequestActionName() {
        return "open";
    }
}

