/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import io.branch.referral.Branch;
import io.branch.referral.BranchViewHandler;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import io.branch.referral.util.CommerceEvent;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestRActionCompleted
extends ServerRequest {
    private final BranchViewHandler.IBranchViewEvents callback_;

    public ServerRequestRActionCompleted(Context context, CommerceEvent commerceEvent, JSONObject metadata, BranchViewHandler.IBranchViewEvents callback) {
        super(context, Defines.RequestPath.CompletedAction.getPath());
        this.callback_ = callback;
        JSONObject post = new JSONObject();
        try {
            post.put(Defines.Jsonkey.IdentityID.getKey(), (Object)this.prefHelper_.getIdentityID());
            post.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
            post.put(Defines.Jsonkey.SessionID.getKey(), (Object)this.prefHelper_.getSessionID());
            if (!this.prefHelper_.getLinkClickID().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.LinkClickID.getKey(), (Object)this.prefHelper_.getLinkClickID());
            }
            post.put(Defines.Jsonkey.Event.getKey(), (Object)"purchase");
            if (metadata != null) {
                post.put(Defines.Jsonkey.Metadata.getKey(), (Object)metadata);
            }
            if (commerceEvent != null) {
                post.put(Defines.Jsonkey.CommerceData.getKey(), (Object)commerceEvent.getCommerceJSONObject());
            }
            this.updateEnvironment(context, post);
            this.setPost(post);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
    }

    public ServerRequestRActionCompleted(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
        this.callback_ = null;
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        block5: {
            if (resp.getObject() != null && resp.getObject().has(Defines.Jsonkey.BranchViewData.getKey()) && Branch.getInstance().currentActivityReference_ != null && Branch.getInstance().currentActivityReference_.get() != null) {
                String actionName = "";
                try {
                    JSONObject post = this.getPost();
                    if (post != null && post.has(Defines.Jsonkey.Event.getKey())) {
                        actionName = post.getString(Defines.Jsonkey.Event.getKey());
                    }
                    if (Branch.getInstance().currentActivityReference_ != null) {
                        Activity currentActivity = (Activity)Branch.getInstance().currentActivityReference_.get();
                        JSONObject branchViewJsonObj = resp.getObject().getJSONObject(Defines.Jsonkey.BranchViewData.getKey());
                        BranchViewHandler.getInstance().showBranchView(branchViewJsonObj, actionName, (Context)currentActivity, this.callback_);
                    }
                }
                catch (JSONException exception) {
                    if (this.callback_ == null) break block5;
                    this.callback_.onBranchViewError(-201, "Unable to show branch view. Branch view received is invalid ", actionName);
                }
            }
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            Log.i((String)"BranchSDK", (String)"Trouble executing your request. Please add 'android.permission.INTERNET' in your applications manifest file");
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
    }

    @Override
    public boolean shouldRetryOnFail() {
        return true;
    }
}

