/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import io.branch.referral.Branch;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerRequestLogout;
import io.branch.referral.ServerRequestRegisterClose;
import io.branch.referral.ServerRequestRegisterInstall;
import io.branch.referral.ServerRequestRegisterOpen;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestQueue {
    private static final String PREF_KEY = "BNCServerRequestQueue";
    private static final int MAX_ITEMS = 25;
    private static ServerRequestQueue SharedInstance;
    private SharedPreferences sharedPref;
    private SharedPreferences.Editor editor;
    private final List<ServerRequest> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerRequestQueue getInstance(Context c) {
        if (SharedInstance != null) return SharedInstance;
        Class<ServerRequestQueue> clazz = ServerRequestQueue.class;
        synchronized (ServerRequestQueue.class) {
            if (SharedInstance != null) return SharedInstance;
            SharedInstance = new ServerRequestQueue(c);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SharedInstance;
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private ServerRequestQueue(Context c) {
        this.sharedPref = c.getSharedPreferences("BNC_Server_Request_Queue", 0);
        this.editor = this.sharedPref.edit();
        this.queue = this.retrieve(c);
    }

    private void persist() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = ServerRequestQueue.this.queue;
                synchronized (list) {
                    JSONArray jsonArr = new JSONArray();
                    for (ServerRequest aQueue : ServerRequestQueue.this.queue) {
                        JSONObject json = aQueue.toJSON();
                        if (json == null) continue;
                        jsonArr.put((Object)json);
                    }
                    boolean succeeded = false;
                    try {
                        ServerRequestQueue.this.editor.putString(ServerRequestQueue.PREF_KEY, jsonArr.toString()).commit();
                        succeeded = true;
                    }
                    catch (ConcurrentModificationException ex) {
                        PrefHelper.Debug("Persisting Queue: ", "Failed to persit queue " + ex.getMessage());
                    }
                    finally {
                        if (!succeeded) {
                            try {
                                ServerRequestQueue.this.editor.putString(ServerRequestQueue.PREF_KEY, jsonArr.toString()).commit();
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {}
                        }
                    }
                }
            }
        }).start();
    }

    private List<ServerRequest> retrieve(Context context) {
        List<ServerRequest> result = Collections.synchronizedList(new LinkedList());
        String jsonStr = this.sharedPref.getString(PREF_KEY, null);
        if (jsonStr != null) {
            try {
                JSONArray jsonArr = new JSONArray(jsonStr);
                for (int i = 0; i < Math.min(jsonArr.length(), 25); ++i) {
                    JSONObject json = jsonArr.getJSONObject(i);
                    ServerRequest req = ServerRequest.fromJSON(json, context);
                    if (req == null || req instanceof ServerRequestRegisterClose || req instanceof ServerRequestLogout) continue;
                    result.add(req);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public int getSize() {
        return this.queue.size();
    }

    public void enqueue(ServerRequest request) {
        if (request != null) {
            this.queue.add(request);
            if (this.getSize() >= 25) {
                this.queue.remove(1);
            }
            this.persist();
        }
    }

    public ServerRequest dequeue() {
        ServerRequest req = null;
        try {
            req = this.queue.remove(0);
            this.persist();
        }
        catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
            // empty catch block
        }
        return req;
    }

    public ServerRequest peek() {
        ServerRequest req = null;
        try {
            req = this.queue.get(0);
        }
        catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
            // empty catch block
        }
        return req;
    }

    public ServerRequest peekAt(int index) {
        ServerRequest req = null;
        try {
            req = this.queue.get(index);
        }
        catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
            // empty catch block
        }
        return req;
    }

    public void insert(ServerRequest request, int index) {
        try {
            if (this.queue.size() < index) {
                index = this.queue.size();
            }
            this.queue.add(index, request);
            this.persist();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public ServerRequest removeAt(int index) {
        ServerRequest req = null;
        try {
            req = this.queue.remove(index);
            this.persist();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return req;
    }

    public boolean remove(ServerRequest request) {
        boolean isRemoved = false;
        try {
            isRemoved = this.queue.remove(request);
            this.persist();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return isRemoved;
    }

    public void clear() {
        try {
            this.queue.clear();
            this.persist();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsClose() {
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            for (ServerRequest req : this.queue) {
                if (req == null || !req.getRequestPath().equals(Defines.RequestPath.RegisterClose.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInstallOrOpen() {
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            for (ServerRequest req : this.queue) {
                if (req == null || !(req instanceof ServerRequestRegisterInstall) && !(req instanceof ServerRequestRegisterOpen)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveInstallOrOpenToFront(ServerRequest request, int networkCount, Branch.BranchReferralInitListener callback) {
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            Iterator<ServerRequest> iter = this.queue.iterator();
            while (iter.hasNext()) {
                ServerRequest req = iter.next();
                if (req == null || !(req instanceof ServerRequestRegisterInstall) && !(req instanceof ServerRequestRegisterOpen)) continue;
                iter.remove();
                break;
            }
        }
        if (networkCount == 0) {
            this.insert(request, 0);
        } else {
            this.insert(request, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstallOrOpenCallback(Branch.BranchReferralInitListener callback) {
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            for (ServerRequest req : this.queue) {
                if (req == null) continue;
                if (req instanceof ServerRequestRegisterInstall) {
                    ((ServerRequestRegisterInstall)req).setInitFinishedCallback(callback);
                    continue;
                }
                if (!(req instanceof ServerRequestRegisterOpen)) continue;
                ((ServerRequestRegisterOpen)req).setInitFinishedCallback(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK lock) {
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            for (ServerRequest req : this.queue) {
                if (req == null) continue;
                req.removeProcessWaitLock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrongMatchWaitLock() {
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            for (ServerRequest req : this.queue) {
                if (req == null || !(req instanceof ServerRequestInitSession)) continue;
                req.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.STRONG_MATCH_PENDING_WAIT_LOCK);
            }
        }
    }
}

