/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.util.Log;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestLogout
extends ServerRequest {
    private Branch.LogoutStatusListener callback_;

    public ServerRequestLogout(Context context, Branch.LogoutStatusListener callback) {
        super(context, Defines.RequestPath.Logout.getPath());
        this.callback_ = callback;
        JSONObject post = new JSONObject();
        try {
            post.put(Defines.Jsonkey.IdentityID.getKey(), (Object)this.prefHelper_.getIdentityID());
            post.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
            post.put(Defines.Jsonkey.SessionID.getKey(), (Object)this.prefHelper_.getSessionID());
            if (!this.prefHelper_.getLinkClickID().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.LinkClickID.getKey(), (Object)this.prefHelper_.getLinkClickID());
            }
            this.setPost(post);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
    }

    public ServerRequestLogout(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        try {
            this.prefHelper_.setSessionID(resp.getObject().getString(Defines.Jsonkey.SessionID.getKey()));
            this.prefHelper_.setIdentityID(resp.getObject().getString(Defines.Jsonkey.IdentityID.getKey()));
            this.prefHelper_.setUserURL(resp.getObject().getString(Defines.Jsonkey.Link.getKey()));
            this.prefHelper_.setInstallParams("bnc_no_value");
            this.prefHelper_.setSessionParams("bnc_no_value");
            this.prefHelper_.setIdentity("bnc_no_value");
            this.prefHelper_.clearUserValues();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            if (this.callback_ != null) {
                this.callback_.onLogoutFinished(true, null);
            }
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            this.callback_.onLogoutFinished(false, new BranchError("Logout error. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            Log.i((String)"BranchSDK", (String)"Trouble executing your request. Please add 'android.permission.INTERNET' in your applications manifest file");
            if (this.callback_ != null) {
                this.callback_.onLogoutFinished(false, new BranchError("Logout failed", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }
}

