/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestIdentifyUserRequest
extends ServerRequest {
    Branch.BranchReferralInitListener callback_;
    String userId_ = null;

    public ServerRequestIdentifyUserRequest(Context context, Branch.BranchReferralInitListener callback, String userId) {
        super(context, Defines.RequestPath.IdentifyUser.getPath());
        this.callback_ = callback;
        this.userId_ = userId;
        JSONObject post = new JSONObject();
        try {
            post.put(Defines.Jsonkey.IdentityID.getKey(), (Object)this.prefHelper_.getIdentityID());
            post.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
            post.put(Defines.Jsonkey.SessionID.getKey(), (Object)this.prefHelper_.getSessionID());
            if (!this.prefHelper_.getLinkClickID().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.LinkClickID.getKey(), (Object)this.prefHelper_.getLinkClickID());
            }
            post.put(Defines.Jsonkey.Identity.getKey(), (Object)userId);
            this.setPost(post);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
    }

    public ServerRequestIdentifyUserRequest(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        try {
            if (this.getPost() != null && this.getPost().has(Defines.Jsonkey.Identity.getKey())) {
                this.prefHelper_.setIdentity(this.getPost().getString(Defines.Jsonkey.Identity.getKey()));
            }
            this.prefHelper_.setIdentityID(resp.getObject().getString(Defines.Jsonkey.IdentityID.getKey()));
            this.prefHelper_.setUserURL(resp.getObject().getString(Defines.Jsonkey.Link.getKey()));
            if (resp.getObject().has(Defines.Jsonkey.ReferringData.getKey())) {
                String params = resp.getObject().getString(Defines.Jsonkey.ReferringData.getKey());
                this.prefHelper_.setInstallParams(params);
            }
            if (this.callback_ != null) {
                this.callback_.onInitFinished(branch.getFirstReferringParams(), null);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("error_message", (Object)"Trouble reaching server. Please try again in a few minutes");
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
            this.callback_.onInitFinished(obj, new BranchError("Trouble setting the user alias. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onInitFinished(null, new BranchError("Trouble setting the user alias.", -102));
            }
            return true;
        }
        try {
            String userId = this.getPost().getString(Defines.Jsonkey.Identity.getKey());
            if (userId == null || userId.length() == 0 || userId.equals(this.prefHelper_.getIdentity())) {
                return true;
            }
        }
        catch (JSONException ignore) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    public boolean isExistingID() {
        try {
            String userId = this.getPost().getString(Defines.Jsonkey.Identity.getKey());
            return userId != null && userId.equals(this.prefHelper_.getIdentity());
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void handleUserExist(Branch branch) {
        if (this.callback_ != null) {
            this.callback_.onInitFinished(branch.getFirstReferringParams(), null);
        }
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }

    @Override
    public boolean shouldRetryOnFail() {
        return true;
    }
}

