/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestGetRewards
extends ServerRequest {
    Branch.BranchReferralStateChangedListener callback_;

    public ServerRequestGetRewards(Context context, Branch.BranchReferralStateChangedListener callback) {
        super(context, Defines.RequestPath.GetCredits.getPath());
        this.callback_ = callback;
    }

    public ServerRequestGetRewards(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
    }

    @Override
    public String getRequestUrl() {
        return super.getRequestUrl() + this.prefHelper_.getIdentityID();
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        boolean updateListener = false;
        Iterator keys = resp.getObject().keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                int credits = resp.getObject().getInt(key);
                if (credits != this.prefHelper_.getCreditCount(key)) {
                    updateListener = true;
                }
                this.prefHelper_.setCreditCount(key, credits);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (this.callback_ != null) {
            this.callback_.onStateChanged(updateListener, null);
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            this.callback_.onStateChanged(false, new BranchError("Trouble retrieving user credits. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onStateChanged(false, new BranchError("Trouble retrieving user credits.", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return true;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }
}

