/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import io.branch.referral.Branch;
import io.branch.referral.BranchViewHandler;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestActionCompleted
extends ServerRequest {
    private final BranchViewHandler.IBranchViewEvents callback_;

    public ServerRequestActionCompleted(Context context, String action, JSONObject metadata, BranchViewHandler.IBranchViewEvents callback) {
        super(context, Defines.RequestPath.CompletedAction.getPath());
        this.callback_ = callback;
        JSONObject post = new JSONObject();
        try {
            post.put(Defines.Jsonkey.IdentityID.getKey(), (Object)this.prefHelper_.getIdentityID());
            post.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
            post.put(Defines.Jsonkey.SessionID.getKey(), (Object)this.prefHelper_.getSessionID());
            if (!this.prefHelper_.getLinkClickID().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.LinkClickID.getKey(), (Object)this.prefHelper_.getLinkClickID());
            }
            post.put(Defines.Jsonkey.Event.getKey(), (Object)action);
            if (metadata != null) {
                post.put(Defines.Jsonkey.Metadata.getKey(), (Object)metadata);
            }
            this.updateEnvironment(context, post);
            this.setPost(post);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
        if (action != null && action.equalsIgnoreCase("purchase")) {
            Log.e((String)"BranchSDK", (String)"Warning: You are sending a purchase event with our non-dedicated purchase function. Please see function sendCommerceEvent");
        }
    }

    public ServerRequestActionCompleted(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
        this.callback_ = null;
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        block5: {
            if (resp.getObject() != null && resp.getObject().has(Defines.Jsonkey.BranchViewData.getKey()) && Branch.getInstance().currentActivityReference_ != null && Branch.getInstance().currentActivityReference_.get() != null) {
                String actionName = "";
                try {
                    JSONObject post = this.getPost();
                    if (post != null && post.has(Defines.Jsonkey.Event.getKey())) {
                        actionName = post.getString(Defines.Jsonkey.Event.getKey());
                    }
                    if (Branch.getInstance().currentActivityReference_ != null) {
                        Activity currentActivity = (Activity)Branch.getInstance().currentActivityReference_.get();
                        JSONObject branchViewJsonObj = resp.getObject().getJSONObject(Defines.Jsonkey.BranchViewData.getKey());
                        BranchViewHandler.getInstance().showBranchView(branchViewJsonObj, actionName, (Context)currentActivity, this.callback_);
                    }
                }
                catch (JSONException exception) {
                    if (this.callback_ == null) break block5;
                    this.callback_.onBranchViewError(-201, "Unable to show branch view. Branch view received is invalid ", actionName);
                }
            }
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            Log.i((String)"BranchSDK", (String)"Trouble executing your request. Please add 'android.permission.INTERNET' in your applications manifest file");
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
    }

    @Override
    public boolean shouldRetryOnFail() {
        return true;
    }
}

