/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import io.branch.referral.Defines;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PrefHelper {
    private static boolean BNC_Dev_Debug = false;
    private static boolean BNC_Logging = false;
    private static boolean BNC_App_Listing = true;
    public static final String NO_STRING_VALUE = "bnc_no_value";
    private static final int INTERVAL_RETRY = 1000;
    private static final int MAX_RETRIES = 3;
    private static final int TIMEOUT = 5500;
    private static final String SHARED_PREF_FILE = "branch_referral_shared_pref";
    private static final String KEY_BRANCH_KEY = "bnc_branch_key";
    private static final String KEY_APP_VERSION = "bnc_app_version";
    private static final String KEY_DEVICE_FINGERPRINT_ID = "bnc_device_fingerprint_id";
    private static final String KEY_SESSION_ID = "bnc_session_id";
    private static final String KEY_IDENTITY_ID = "bnc_identity_id";
    private static final String KEY_IDENTITY = "bnc_identity";
    private static final String KEY_LINK_CLICK_ID = "bnc_link_click_id";
    private static final String KEY_LINK_CLICK_IDENTIFIER = "bnc_link_click_identifier";
    private static final String KEY_GOOGLE_SEARCH_INSTALL_IDENTIFIER = "bnc_google_search_install_identifier";
    private static final String KEY_IS_TRIGGERED_BY_FB_APP_LINK = "bnc_triggered_by_fb_app_link";
    private static final String KEY_APP_LINK = "bnc_app_link";
    private static final String KEY_PUSH_IDENTIFIER = "bnc_push_identifier";
    private static final String KEY_SESSION_PARAMS = "bnc_session_params";
    private static final String KEY_INSTALL_PARAMS = "bnc_install_params";
    private static final String KEY_USER_URL = "bnc_user_url";
    private static final String KEY_IS_REFERRABLE = "bnc_is_referrable";
    private static final String KEY_BUCKETS = "bnc_buckets";
    private static final String KEY_CREDIT_BASE = "bnc_credit_base_";
    private static final String KEY_ACTIONS = "bnc_actions";
    private static final String KEY_TOTAL_BASE = "bnc_total_base_";
    private static final String KEY_UNIQUE_BASE = "bnc_balance_base_";
    private static final String KEY_RETRY_COUNT = "bnc_retry_count";
    private static final String KEY_RETRY_INTERVAL = "bnc_retry_interval";
    private static final String KEY_TIMEOUT = "bnc_timeout";
    private static final String KEY_LAST_READ_SYSTEM = "bnc_system_read_date";
    private static final String KEY_EXTERNAL_INTENT_URI = "bnc_external_intent_uri";
    private static final String KEY_EXTERNAL_INTENT_EXTRA = "bnc_external_intent_extra";
    private static final String KEY_BRANCH_VIEW_NUM_OF_USE = "bnc_branch_view_use";
    private static final String KEY_BRANCH_ANALYTICAL_DATA = "bnc_branch_analytical_data";
    private static final String KEY_LAST_STRONG_MATCH_TIME = "bnc_branch_strong_match_time";
    private static final String KEY_INSTALL_REFERRER = "bnc_install_referrer";
    private static final String KEY_IS_FULL_APP_CONVERSION = "bnc_is_full_app_conversion";
    private static String Branch_Key = null;
    private static PrefHelper prefHelper_;
    private SharedPreferences appSharedPrefs_;
    private SharedPreferences.Editor prefsEditor_;
    private JSONObject requestMetadata;
    private Context context_;
    private static JSONObject savedAnalyticsData_;

    public PrefHelper() {
    }

    private PrefHelper(Context context) {
        this.appSharedPrefs_ = context.getSharedPreferences(SHARED_PREF_FILE, 0);
        this.prefsEditor_ = this.appSharedPrefs_.edit();
        this.context_ = context;
        this.requestMetadata = new JSONObject();
    }

    public static PrefHelper getInstance(Context context) {
        if (prefHelper_ == null) {
            prefHelper_ = new PrefHelper(context);
        }
        return prefHelper_;
    }

    public String getAPIBaseUrl() {
        return "https://api.branch.io/";
    }

    public void setTimeout(int timeout) {
        this.setInteger(KEY_TIMEOUT, timeout);
    }

    public int getTimeout() {
        return this.getInteger(KEY_TIMEOUT, 5500);
    }

    public void setRetryCount(int retry) {
        this.setInteger(KEY_RETRY_COUNT, retry);
    }

    public int getRetryCount() {
        return this.getInteger(KEY_RETRY_COUNT, 3);
    }

    public void setRetryInterval(int retryInt) {
        this.setInteger(KEY_RETRY_INTERVAL, retryInt);
    }

    public int getRetryInterval() {
        return this.getInteger(KEY_RETRY_INTERVAL, 1000);
    }

    public void setAppVersion(String version) {
        this.setString(KEY_APP_VERSION, version);
    }

    public String getAppVersion() {
        return this.getString(KEY_APP_VERSION);
    }

    public boolean setBranchKey(String key) {
        Branch_Key = key;
        String currentBranchKey = this.getString(KEY_BRANCH_KEY);
        if (key == null || currentBranchKey == null || !currentBranchKey.equals(key)) {
            this.clearPrefOnBranchKeyChange();
            this.setString(KEY_BRANCH_KEY, key);
            return true;
        }
        return false;
    }

    public String getBranchKey() {
        if (Branch_Key == null) {
            Branch_Key = this.getString(KEY_BRANCH_KEY);
        }
        return Branch_Key;
    }

    public String readBranchKey(boolean isLive) {
        String metaDataKey;
        String branchKey = null;
        String string = metaDataKey = isLive ? "io.branch.sdk.BranchKey" : "io.branch.sdk.BranchKey.test";
        if (!isLive) {
            this.setExternDebug();
        }
        try {
            ApplicationInfo ai = this.context_.getPackageManager().getApplicationInfo(this.context_.getPackageName(), 128);
            if (ai.metaData != null && (branchKey = ai.metaData.getString(metaDataKey)) == null && !isLive) {
                branchKey = ai.metaData.getString("io.branch.sdk.BranchKey");
            }
        }
        catch (PackageManager.NameNotFoundException ai) {
            // empty catch block
        }
        if (TextUtils.isEmpty(branchKey)) {
            try {
                Resources resources = this.context_.getResources();
                branchKey = resources.getString(resources.getIdentifier(metaDataKey, "string", this.context_.getPackageName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (branchKey == null) {
            branchKey = NO_STRING_VALUE;
        }
        return branchKey;
    }

    public void setDeviceFingerPrintID(String device_fingerprint_id) {
        this.setString(KEY_DEVICE_FINGERPRINT_ID, device_fingerprint_id);
    }

    public String getDeviceFingerPrintID() {
        return this.getString(KEY_DEVICE_FINGERPRINT_ID);
    }

    public void setSessionID(String session_id) {
        this.setString(KEY_SESSION_ID, session_id);
    }

    public String getSessionID() {
        return this.getString(KEY_SESSION_ID);
    }

    public void setIdentityID(String identity_id) {
        this.setString(KEY_IDENTITY_ID, identity_id);
    }

    public String getIdentityID() {
        return this.getString(KEY_IDENTITY_ID);
    }

    public void setIdentity(String identity) {
        this.setString(KEY_IDENTITY, identity);
    }

    public String getIdentity() {
        return this.getString(KEY_IDENTITY);
    }

    public void setLinkClickID(String link_click_id) {
        this.setString(KEY_LINK_CLICK_ID, link_click_id);
    }

    public String getLinkClickID() {
        return this.getString(KEY_LINK_CLICK_ID);
    }

    public void setIsAppLinkTriggeredInit(Boolean isAppLinkTriggered) {
        this.setBool(KEY_IS_TRIGGERED_BY_FB_APP_LINK, isAppLinkTriggered);
    }

    public boolean getIsAppLinkTriggeredInit() {
        return this.getBool(KEY_IS_TRIGGERED_BY_FB_APP_LINK);
    }

    public void setExternalIntentUri(String uri) {
        this.setString(KEY_EXTERNAL_INTENT_URI, uri);
    }

    public String getExternalIntentUri() {
        return this.getString(KEY_EXTERNAL_INTENT_URI);
    }

    public void setExternalIntentExtra(String extras) {
        this.setString(KEY_EXTERNAL_INTENT_EXTRA, extras);
    }

    public String getExternalIntentExtra() {
        return this.getString(KEY_EXTERNAL_INTENT_EXTRA);
    }

    public void setLinkClickIdentifier(String identifier) {
        this.setString(KEY_LINK_CLICK_IDENTIFIER, identifier);
    }

    public String getLinkClickIdentifier() {
        return this.getString(KEY_LINK_CLICK_IDENTIFIER);
    }

    public void setGoogleSearchInstallIdentifier(String identifier) {
        this.setString(KEY_GOOGLE_SEARCH_INSTALL_IDENTIFIER, identifier);
    }

    public String getGoogleSearchInstallIdentifier() {
        return this.getString(KEY_GOOGLE_SEARCH_INSTALL_IDENTIFIER);
    }

    public void setAppLink(String appLinkUrl) {
        this.setString(KEY_APP_LINK, appLinkUrl);
    }

    public String getAppLink() {
        return this.getString(KEY_APP_LINK);
    }

    public void setIsFullAppConversion(boolean isFullAppConversion) {
        this.setBool(KEY_IS_FULL_APP_CONVERSION, isFullAppConversion);
    }

    public boolean isFullAppConversion() {
        return this.getBool(KEY_IS_FULL_APP_CONVERSION);
    }

    public void setPushIdentifier(String pushIdentifier) {
        this.setString(KEY_PUSH_IDENTIFIER, pushIdentifier);
    }

    public String getPushIdentifier() {
        return this.getString(KEY_PUSH_IDENTIFIER);
    }

    public String getSessionParams() {
        return this.getString(KEY_SESSION_PARAMS);
    }

    public void setSessionParams(String params) {
        this.setString(KEY_SESSION_PARAMS, params);
    }

    public String getInstallParams() {
        return this.getString(KEY_INSTALL_PARAMS);
    }

    public void setInstallParams(String params) {
        this.setString(KEY_INSTALL_PARAMS, params);
    }

    public void setInstallReferrerParams(String params) {
        this.setString(KEY_INSTALL_REFERRER, params);
    }

    public String getInstallReferrerParams() {
        return this.getString(KEY_INSTALL_REFERRER);
    }

    public void setUserURL(String user_url) {
        this.setString(KEY_USER_URL, user_url);
    }

    public String getUserURL() {
        return this.getString(KEY_USER_URL);
    }

    public int getIsReferrable() {
        return this.getInteger(KEY_IS_REFERRABLE);
    }

    public void setIsReferrable() {
        this.setInteger(KEY_IS_REFERRABLE, 1);
    }

    public void clearIsReferrable() {
        this.setInteger(KEY_IS_REFERRABLE, 0);
    }

    public void clearSystemReadStatus() {
        Calendar c = Calendar.getInstance();
        this.setLong(KEY_LAST_READ_SYSTEM, c.getTimeInMillis() / 1000L);
    }

    public void clearUserValues() {
        ArrayList<String> buckets = this.getBuckets();
        for (String bucket : buckets) {
            this.setCreditCount(bucket, 0);
        }
        this.setBuckets(new ArrayList<String>());
        ArrayList<String> actions = this.getActions();
        for (String action : actions) {
            this.setActionTotalCount(action, 0);
            this.setActionUniqueCount(action, 0);
        }
        this.setActions(new ArrayList<String>());
    }

    private ArrayList<String> getBuckets() {
        String bucketList = this.getString(KEY_BUCKETS);
        if (bucketList.equals(NO_STRING_VALUE)) {
            return new ArrayList<String>();
        }
        return this.deserializeString(bucketList);
    }

    private void setBuckets(ArrayList<String> buckets) {
        if (buckets.size() == 0) {
            this.setString(KEY_BUCKETS, NO_STRING_VALUE);
        } else {
            this.setString(KEY_BUCKETS, this.serializeArrayList(buckets));
        }
    }

    public void setCreditCount(int count) {
        this.setCreditCount(Defines.Jsonkey.DefaultBucket.getKey(), count);
    }

    public void setCreditCount(String bucket, int count) {
        ArrayList<String> buckets = this.getBuckets();
        if (!buckets.contains(bucket)) {
            buckets.add(bucket);
            this.setBuckets(buckets);
        }
        this.setInteger(KEY_CREDIT_BASE + bucket, count);
    }

    public int getCreditCount() {
        return this.getCreditCount(Defines.Jsonkey.DefaultBucket.getKey());
    }

    public int getCreditCount(String bucket) {
        return this.getInteger(KEY_CREDIT_BASE + bucket);
    }

    private ArrayList<String> getActions() {
        String actionList = this.getString(KEY_ACTIONS);
        if (actionList.equals(NO_STRING_VALUE)) {
            return new ArrayList<String>();
        }
        return this.deserializeString(actionList);
    }

    private void setActions(ArrayList<String> actions) {
        if (actions.size() == 0) {
            this.setString(KEY_ACTIONS, NO_STRING_VALUE);
        } else {
            this.setString(KEY_ACTIONS, this.serializeArrayList(actions));
        }
    }

    public void setActionTotalCount(String action, int count) {
        ArrayList<String> actions = this.getActions();
        if (!actions.contains(action)) {
            actions.add(action);
            this.setActions(actions);
        }
        this.setInteger(KEY_TOTAL_BASE + action, count);
    }

    public void setActionUniqueCount(String action, int count) {
        this.setInteger(KEY_UNIQUE_BASE + action, count);
    }

    public int getActionTotalCount(String action) {
        return this.getInteger(KEY_TOTAL_BASE + action);
    }

    public int getActionUniqueCount(String action) {
        return this.getInteger(KEY_UNIQUE_BASE + action);
    }

    private String serializeArrayList(ArrayList<String> strings) {
        String retString = "";
        for (String value : strings) {
            retString = retString + value + ",";
        }
        retString = retString.substring(0, retString.length() - 1);
        return retString;
    }

    private ArrayList<String> deserializeString(String list) {
        ArrayList<String> strings = new ArrayList<String>();
        String[] stringArr = list.split(",");
        Collections.addAll(strings, stringArr);
        return strings;
    }

    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    public int getInteger(String key, int defaultValue) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getInt(key, defaultValue);
    }

    public long getLong(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getLong(key, 0L);
    }

    public float getFloat(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getFloat(key, 0.0f);
    }

    public String getString(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getString(key, NO_STRING_VALUE);
    }

    public boolean getBool(String key) {
        return PrefHelper.prefHelper_.appSharedPrefs_.getBoolean(key, false);
    }

    public void setInteger(String key, int value) {
        PrefHelper.prefHelper_.prefsEditor_.putInt(key, value);
        PrefHelper.prefHelper_.prefsEditor_.apply();
    }

    public void setLong(String key, long value) {
        PrefHelper.prefHelper_.prefsEditor_.putLong(key, value);
        PrefHelper.prefHelper_.prefsEditor_.apply();
    }

    public void setFloat(String key, float value) {
        PrefHelper.prefHelper_.prefsEditor_.putFloat(key, value);
        PrefHelper.prefHelper_.prefsEditor_.apply();
    }

    public void setString(String key, String value) {
        PrefHelper.prefHelper_.prefsEditor_.putString(key, value);
        PrefHelper.prefHelper_.prefsEditor_.apply();
    }

    public void setBool(String key, Boolean value) {
        PrefHelper.prefHelper_.prefsEditor_.putBoolean(key, value.booleanValue());
        PrefHelper.prefHelper_.prefsEditor_.apply();
    }

    public void updateBranchViewUsageCount(String branchViewId) {
        String key = "bnc_branch_view_use_" + branchViewId;
        int currentUsage = this.getBranchViewUsageCount(branchViewId) + 1;
        this.setInteger(key, currentUsage);
    }

    public int getBranchViewUsageCount(String branchViewId) {
        String key = "bnc_branch_view_use_" + branchViewId;
        return this.getInteger(key, 0);
    }

    public JSONObject getBranchAnalyticsData() {
        JSONObject analyticsDataObject;
        if (savedAnalyticsData_ != null) {
            analyticsDataObject = savedAnalyticsData_;
        } else {
            String savedAnalyticsData = this.getString(KEY_BRANCH_ANALYTICAL_DATA);
            analyticsDataObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)savedAnalyticsData) && !savedAnalyticsData.equals(NO_STRING_VALUE)) {
                try {
                    analyticsDataObject = new JSONObject(savedAnalyticsData);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        return analyticsDataObject;
    }

    public void clearBranchAnalyticsData() {
        savedAnalyticsData_ = null;
        this.setString(KEY_BRANCH_ANALYTICAL_DATA, "");
    }

    public void saveBranchAnalyticsData(JSONObject analyticsData) {
        String sessionID = this.getSessionID();
        if (!sessionID.equals(NO_STRING_VALUE)) {
            if (savedAnalyticsData_ == null) {
                savedAnalyticsData_ = this.getBranchAnalyticsData();
            }
            try {
                JSONArray viewDataArray;
                if (savedAnalyticsData_.has(sessionID)) {
                    viewDataArray = savedAnalyticsData_.getJSONArray(sessionID);
                } else {
                    viewDataArray = new JSONArray();
                    savedAnalyticsData_.put(sessionID, (Object)viewDataArray);
                }
                viewDataArray.put((Object)analyticsData);
                this.setString(KEY_BRANCH_ANALYTICAL_DATA, savedAnalyticsData_.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public void saveLastStrongMatchTime(long strongMatchCheckTime) {
        this.setLong(KEY_LAST_STRONG_MATCH_TIME, strongMatchCheckTime);
    }

    public long getLastStrongMatchTime() {
        return this.getLong(KEY_LAST_STRONG_MATCH_TIME);
    }

    private void clearPrefOnBranchKeyChange() {
        String linkClickID = this.getLinkClickID();
        String linkClickIdentifier = this.getLinkClickIdentifier();
        String appLink = this.getAppLink();
        String pushIdentifier = this.getPushIdentifier();
        this.prefsEditor_.clear();
        this.setLinkClickID(linkClickID);
        this.setLinkClickIdentifier(linkClickIdentifier);
        this.setAppLink(appLink);
        this.setPushIdentifier(pushIdentifier);
        PrefHelper.prefHelper_.prefsEditor_.apply();
    }

    public void setExternDebug() {
        BNC_Dev_Debug = true;
    }

    public boolean getExternDebug() {
        return BNC_Dev_Debug;
    }

    public void setLogging(boolean logging) {
        BNC_Logging = logging;
    }

    public void disableExternAppListing() {
        BNC_App_Listing = false;
    }

    public boolean getExternAppListing() {
        return BNC_App_Listing;
    }

    public void setRequestMetadata(@NonNull String key, @NonNull String value) {
        if (key == null) {
            return;
        }
        if (this.requestMetadata.has(key) && value == null) {
            this.requestMetadata.remove(key);
        }
        try {
            this.requestMetadata.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public JSONObject getRequestMetadata() {
        return this.requestMetadata;
    }

    public void log(String tag, String message) {
        if (BNC_Dev_Debug || BNC_Logging) {
            Log.i((String)tag, (String)message);
        }
    }

    public static void Debug(String tag, String message) {
        if (prefHelper_ != null) {
            prefHelper_.log(tag, message);
        } else if (BNC_Dev_Debug || BNC_Logging) {
            Log.i((String)tag, (String)message);
        }
    }
}

