/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;

public class InstallListener
extends BroadcastReceiver {
    private static String installID_ = "bnc_no_value";
    private static IInstallReferrerEvents callback_ = null;
    private static boolean isWaitingForReferrer;

    public static void startInstallReferrerTime(long delay) {
        isWaitingForReferrer = true;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (callback_ != null) {
                    callback_.onInstallReferrerEventsFinished();
                    callback_ = null;
                    isWaitingForReferrer = false;
                }
            }
        }, delay);
    }

    public void onReceive(Context context, Intent intent) {
        String rawReferrerString = intent.getStringExtra("referrer");
        if (rawReferrerString != null) {
            try {
                String[] referralParams;
                rawReferrerString = URLDecoder.decode(rawReferrerString, "UTF-8");
                HashMap<String, String> referrerMap = new HashMap<String, String>();
                for (String referrerParam : referralParams = rawReferrerString.split("&")) {
                    String[] keyValue = referrerParam.split("=");
                    if (keyValue.length <= 1) continue;
                    referrerMap.put(URLDecoder.decode(keyValue[0], "UTF-8"), URLDecoder.decode(keyValue[1], "UTF-8"));
                }
                PrefHelper prefHelper = PrefHelper.getInstance(context);
                if (isWaitingForReferrer) {
                    if (referrerMap.containsKey(Defines.Jsonkey.LinkClickID.getKey())) {
                        installID_ = (String)referrerMap.get(Defines.Jsonkey.LinkClickID.getKey());
                        prefHelper.setLinkClickIdentifier(installID_);
                    }
                    if (referrerMap.containsKey(Defines.Jsonkey.IsFullAppConv.getKey()) && referrerMap.containsKey(Defines.Jsonkey.ReferringLink.getKey())) {
                        prefHelper.setIsFullAppConversion(Boolean.parseBoolean((String)referrerMap.get(Defines.Jsonkey.IsFullAppConv.getKey())));
                        prefHelper.setAppLink((String)referrerMap.get(Defines.Jsonkey.ReferringLink.getKey()));
                    }
                }
                if (referrerMap.containsKey(Defines.Jsonkey.GoogleSearchInstallReferrer.getKey())) {
                    prefHelper.setGoogleSearchInstallIdentifier((String)referrerMap.get(Defines.Jsonkey.GoogleSearchInstallReferrer.getKey()));
                }
                if (callback_ != null) {
                    callback_.onInstallReferrerEventsFinished();
                    callback_ = null;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                Log.w((String)"BranchSDK", (String)"Illegal characters in url encoded string");
            }
        }
    }

    public static String getInstallationID() {
        return installID_;
    }

    public static void setListener(IInstallReferrerEvents installReferrerFetch) {
        callback_ = installReferrerFetch;
    }

    static interface IInstallReferrerEvents {
        public void onInstallReferrerEventsFinished();
    }
}

