/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import io.branch.referral.Branch;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.json.JSONObject;

public class BranchViewHandler {
    private static BranchViewHandler thisInstance_;
    private boolean isBranchViewDialogShowing_;
    private boolean isBranchViewAccepted_;
    private BranchView openOrInstallPendingBranchView_ = null;
    private boolean loadingHtmlInBackGround_ = false;
    private static final String BRANCH_VIEW_REDIRECT_SCHEME = "branch-cta";
    private static final String BRANCH_VIEW_REDIRECT_ACTION_ACCEPT = "accept";
    private static final String BRANCH_VIEW_REDIRECT_ACTION_CANCEL = "cancel";
    public static final int BRANCH_VIEW_ERR_ALREADY_SHOWING = -200;
    public static final int BRANCH_VIEW_ERR_INVALID_VIEW = -201;
    public static final int BRANCH_VIEW_ERR_TEMP_UNAVAILABLE = -202;
    public static final int BRANCH_VIEW_ERR_REACHED_LIMIT = -203;
    private String parentActivityClassName_;
    private boolean webViewLoadError_;
    private Dialog branchViewDialog_;

    private BranchViewHandler() {
    }

    public static BranchViewHandler getInstance() {
        if (thisInstance_ == null) {
            thisInstance_ = new BranchViewHandler();
        }
        return thisInstance_;
    }

    public boolean showPendingBranchView(Context appContext) {
        boolean isBranchViewShowed = this.showBranchView(this.openOrInstallPendingBranchView_, appContext, null);
        if (isBranchViewShowed) {
            this.openOrInstallPendingBranchView_ = null;
        }
        return isBranchViewShowed;
    }

    public boolean showBranchView(JSONObject branchViewObj, String actionName, Context appContext, IBranchViewEvents callback) {
        BranchView branchView = new BranchView(branchViewObj, actionName);
        return this.showBranchView(branchView, appContext, callback);
    }

    private boolean showBranchView(BranchView branchView, Context appContext, IBranchViewEvents callback) {
        if (this.isBranchViewDialogShowing_ || this.loadingHtmlInBackGround_) {
            if (callback != null) {
                callback.onBranchViewError(-200, "Unable to create a Branch view. A Branch view is already showing", branchView.branchViewAction_);
            }
            return false;
        }
        this.isBranchViewDialogShowing_ = false;
        this.isBranchViewAccepted_ = false;
        if (appContext != null && branchView != null) {
            if (branchView.isAvailable(appContext)) {
                if (!TextUtils.isEmpty((CharSequence)branchView.webViewHtml_)) {
                    this.createAndShowBranchView(branchView, appContext, callback);
                } else {
                    this.loadingHtmlInBackGround_ = true;
                    new loadBranchViewTask(branchView, appContext, callback).execute(new Void[0]);
                }
                return true;
            }
            if (callback != null) {
                callback.onBranchViewError(-203, "Unable to create this Branch view. Reached maximum usage limit ", branchView.branchViewAction_);
            }
        }
        return false;
    }

    private void createAndShowBranchView(final BranchView branchView, Context appContext, final IBranchViewEvents callback) {
        if (appContext != null && branchView != null) {
            final WebView webView = new WebView(appContext);
            webView.getSettings().setJavaScriptEnabled(true);
            if (Build.VERSION.SDK_INT >= 19) {
                webView.setLayerType(2, null);
            }
            this.webViewLoadError_ = false;
            if (TextUtils.isEmpty((CharSequence)branchView.webViewHtml_)) {
                return;
            }
            webView.loadDataWithBaseURL(null, branchView.webViewHtml_, "text/html", "utf-8", null);
            webView.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    boolean isHandled = BranchViewHandler.this.handleUserActionRedirect(url);
                    if (!isHandled) {
                        view.loadUrl(url);
                    } else if (BranchViewHandler.this.branchViewDialog_ != null) {
                        BranchViewHandler.this.branchViewDialog_.dismiss();
                    }
                    return isHandled;
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    super.onReceivedError(view, errorCode, description, failingUrl);
                    BranchViewHandler.this.webViewLoadError_ = true;
                }

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    BranchViewHandler.this.openBranchViewDialog(branchView, callback, webView);
                }
            });
        }
    }

    private void openBranchViewDialog(final BranchView branchView, final IBranchViewEvents callback, WebView webView) {
        if (!this.webViewLoadError_ && Branch.getInstance() != null && Branch.getInstance().currentActivityReference_ != null) {
            Activity currentActivity = (Activity)Branch.getInstance().currentActivityReference_.get();
            if (currentActivity != null) {
                branchView.updateUsageCount(currentActivity.getApplicationContext(), branchView.branchViewID_);
                this.parentActivityClassName_ = currentActivity.getClass().getName();
                RelativeLayout layout = new RelativeLayout((Context)currentActivity);
                layout.setVisibility(8);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                layout.addView((View)webView, (ViewGroup.LayoutParams)layoutParams);
                layout.setBackgroundColor(0);
                if (this.branchViewDialog_ != null && this.branchViewDialog_.isShowing()) {
                    if (callback != null) {
                        callback.onBranchViewError(-200, "Unable to create a Branch view. A Branch view is already showing", branchView.branchViewAction_);
                    }
                    return;
                }
                this.branchViewDialog_ = new Dialog((Context)currentActivity, 16973834);
                this.branchViewDialog_.setContentView((View)layout);
                layout.setVisibility(0);
                webView.setVisibility(0);
                this.branchViewDialog_.show();
                this.showViewWithAlphaAnimation((View)layout);
                this.showViewWithAlphaAnimation((View)webView);
                this.isBranchViewDialogShowing_ = true;
                if (callback != null) {
                    callback.onBranchViewVisible(branchView.branchViewAction_, branchView.branchViewID_);
                }
                this.branchViewDialog_.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialog) {
                        BranchViewHandler.this.isBranchViewDialogShowing_ = false;
                        BranchViewHandler.this.branchViewDialog_ = null;
                        if (callback != null) {
                            if (BranchViewHandler.this.isBranchViewAccepted_) {
                                callback.onBranchViewAccepted(branchView.branchViewAction_, branchView.branchViewID_);
                            } else {
                                callback.onBranchViewCancelled(branchView.branchViewAction_, branchView.branchViewID_);
                            }
                        }
                    }
                });
            }
        } else {
            this.isBranchViewDialogShowing_ = false;
            if (callback != null) {
                callback.onBranchViewError(-202, "Unable to create a Branch view due to a temporary network error", branchView.branchViewAction_);
            }
        }
    }

    private boolean handleUserActionRedirect(String url) {
        boolean isRedirectionHandled = false;
        try {
            URI uri = new URI(url);
            if (uri.getScheme().equalsIgnoreCase(BRANCH_VIEW_REDIRECT_SCHEME)) {
                if (uri.getHost().equalsIgnoreCase(BRANCH_VIEW_REDIRECT_ACTION_ACCEPT)) {
                    this.isBranchViewAccepted_ = true;
                    isRedirectionHandled = true;
                } else if (uri.getHost().equalsIgnoreCase(BRANCH_VIEW_REDIRECT_ACTION_CANCEL)) {
                    this.isBranchViewAccepted_ = false;
                    isRedirectionHandled = true;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return isRedirectionHandled;
    }

    private void showViewWithAlphaAnimation(View view) {
        AlphaAnimation animation1 = new AlphaAnimation(0.1f, 1.0f);
        animation1.setDuration(500L);
        animation1.setStartOffset(10L);
        animation1.setInterpolator((Interpolator)new AccelerateInterpolator());
        animation1.setFillAfter(true);
        view.setVisibility(0);
        view.startAnimation((Animation)animation1);
    }

    private void hideViewWithAlphaAnimation(View view) {
        AlphaAnimation animation1 = new AlphaAnimation(1.0f, 0.0f);
        animation1.setDuration(500L);
        animation1.setStartOffset(10L);
        animation1.setInterpolator((Interpolator)new DecelerateInterpolator());
        animation1.setFillAfter(true);
        view.setVisibility(8);
        view.startAnimation((Animation)animation1);
    }

    public boolean markInstallOrOpenBranchViewPending(JSONObject branchViewObj, String action) {
        Activity currentActivity;
        boolean isMarked = false;
        BranchView branchView = new BranchView(branchViewObj, action);
        if (branchView != null && Branch.getInstance().currentActivityReference_ != null && (currentActivity = (Activity)Branch.getInstance().currentActivityReference_.get()) != null && branchView.isAvailable((Context)currentActivity)) {
            this.openOrInstallPendingBranchView_ = new BranchView(branchViewObj, action);
            isMarked = true;
        }
        return isMarked;
    }

    public boolean isInstallOrOpenBranchViewPending(Context context) {
        return this.openOrInstallPendingBranchView_ != null && this.openOrInstallPendingBranchView_.isAvailable(context);
    }

    public void onCurrentActivityDestroyed(Activity activity) {
        if (this.parentActivityClassName_ != null && this.parentActivityClassName_.equalsIgnoreCase(activity.getClass().getName())) {
            this.isBranchViewDialogShowing_ = false;
        }
    }

    public static interface IBranchViewEvents {
        public void onBranchViewVisible(String var1, String var2);

        public void onBranchViewAccepted(String var1, String var2);

        public void onBranchViewCancelled(String var1, String var2);

        public void onBranchViewError(int var1, String var2, String var3);
    }

    private class BranchView {
        private String branchViewID_ = "";
        private String branchViewAction_ = "";
        private int num_of_use_ = 1;
        private String webViewUrl_ = "";
        private String webViewHtml_ = "";
        private static final int USAGE_UNLIMITED = -1;

        private BranchView(JSONObject branchViewJson, String actionName) {
            try {
                this.branchViewAction_ = actionName;
                if (branchViewJson.has(Defines.Jsonkey.BranchViewID.getKey())) {
                    this.branchViewID_ = branchViewJson.getString(Defines.Jsonkey.BranchViewID.getKey());
                }
                if (branchViewJson.has(Defines.Jsonkey.BranchViewNumOfUse.getKey())) {
                    this.num_of_use_ = branchViewJson.getInt(Defines.Jsonkey.BranchViewNumOfUse.getKey());
                }
                if (branchViewJson.has(Defines.Jsonkey.BranchViewUrl.getKey())) {
                    this.webViewUrl_ = branchViewJson.getString(Defines.Jsonkey.BranchViewUrl.getKey());
                }
                if (branchViewJson.has(Defines.Jsonkey.BranchViewHtml.getKey())) {
                    this.webViewHtml_ = branchViewJson.getString(Defines.Jsonkey.BranchViewHtml.getKey());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isAvailable(Context context) {
            int usedCount = PrefHelper.getInstance(context).getBranchViewUsageCount(this.branchViewID_);
            return this.num_of_use_ > usedCount || this.num_of_use_ == -1;
        }

        public void updateUsageCount(Context context, String branchViewID) {
            PrefHelper.getInstance(context).updateBranchViewUsageCount(branchViewID);
        }
    }

    private class loadBranchViewTask
    extends AsyncTask<Void, Void, Boolean> {
        private final BranchView branchView;
        private final Context context;
        private final IBranchViewEvents callback;
        private String htmlString;

        public loadBranchViewTask(BranchView branchView, Context context, IBranchViewEvents callback) {
            this.branchView = branchView;
            this.context = context;
            this.callback = callback;
        }

        protected Boolean doInBackground(Void ... params) {
            int code = -1;
            try {
                URL url = new URL(this.branchView.webViewUrl_);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                code = connection.getResponseCode();
                if (code == 200) {
                    int length;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    InputStream inputStream = connection.getInputStream();
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, length);
                    }
                    this.branchView.webViewHtml_ = outputStream.toString("UTF-8");
                    outputStream.close();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return code == 200;
        }

        protected void onPostExecute(Boolean loadHtml) {
            super.onPostExecute((Object)loadHtml);
            if (loadHtml.booleanValue()) {
                BranchViewHandler.this.createAndShowBranchView(this.branchView, this.context, this.callback);
            } else if (this.callback != null) {
                this.callback.onBranchViewError(-202, "Unable to create a Branch view due to a temporary network error", this.branchView.branchViewAction_);
            }
            BranchViewHandler.this.loadingHtmlInBackGround_ = false;
        }
    }
}

