/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import io.branch.referral.Defines;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BranchLinkData
extends JSONObject {
    private Collection<String> tags;
    private String alias;
    private int type;
    private String channel;
    private String feature;
    private String stage;
    private String campaign;
    private String params;
    private int duration;

    public void putTags(Collection<String> tags) throws JSONException {
        if (tags != null) {
            this.tags = tags;
            JSONArray tagArray = new JSONArray();
            for (String tag : tags) {
                tagArray.put((Object)tag);
            }
            this.put(Defines.LinkParam.Tags.getKey(), tagArray);
        }
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public void putAlias(String alias) throws JSONException {
        if (alias != null) {
            this.alias = alias;
            this.put(Defines.LinkParam.Alias.getKey(), alias);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void putType(int type) throws JSONException {
        if (type != 0) {
            this.type = type;
            this.put(Defines.LinkParam.Type.getKey(), type);
        }
    }

    public int getType() {
        return this.type;
    }

    public void putDuration(int duration) throws JSONException {
        if (duration > 0) {
            this.duration = duration;
            this.put(Defines.LinkParam.Duration.getKey(), duration);
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void putChannel(String channel) throws JSONException {
        if (channel != null) {
            this.channel = channel;
            this.put(Defines.LinkParam.Channel.getKey(), channel);
        }
    }

    public String getChannel() {
        return this.channel;
    }

    public void putFeature(String feature) throws JSONException {
        if (feature != null) {
            this.feature = feature;
            this.put(Defines.LinkParam.Feature.getKey(), feature);
        }
    }

    public String getFeature() {
        return this.feature;
    }

    public void putStage(String stage) throws JSONException {
        if (stage != null) {
            this.stage = stage;
            this.put(Defines.LinkParam.Stage.getKey(), stage);
        }
    }

    public String getStage() {
        return this.stage;
    }

    public void putCampaign(String campaign) throws JSONException {
        if (campaign != null) {
            this.campaign = campaign;
            this.put(Defines.LinkParam.Campaign.getKey(), campaign);
        }
    }

    public String getCampaign() {
        return this.campaign;
    }

    public void putParams(String params) throws JSONException {
        this.params = params;
        this.put(Defines.LinkParam.Data.getKey(), params);
    }

    public String getParams() {
        return this.params;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BranchLinkData other = (BranchLinkData)((Object)obj);
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.channel == null ? other.channel != null : !this.channel.equals(other.channel)) {
            return false;
        }
        if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.stage == null ? other.stage != null : !this.stage.equals(other.stage)) {
            return false;
        }
        if (this.campaign == null ? other.campaign != null : !this.campaign.equals(other.campaign)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.toString().equals(other.tags.toString()));
    }

    @SuppressLint(value={"DefaultLocale"})
    public int hashCode() {
        int result = 1;
        int prime = 19;
        result = prime * result + this.type;
        result = prime * result + (this.alias == null ? 0 : this.alias.toLowerCase().hashCode());
        result = prime * result + (this.channel == null ? 0 : this.channel.toLowerCase().hashCode());
        result = prime * result + (this.feature == null ? 0 : this.feature.toLowerCase().hashCode());
        result = prime * result + (this.stage == null ? 0 : this.stage.toLowerCase().hashCode());
        result = prime * result + (this.campaign == null ? 0 : this.campaign.toLowerCase().hashCode());
        result = prime * result + (this.params == null ? 0 : this.params.toLowerCase().hashCode());
        result = prime * result + this.duration;
        if (this.tags != null) {
            for (String tag : this.tags) {
                result = prime * result + tag.toLowerCase().hashCode();
            }
        }
        return result;
    }

    public JSONObject getLinkDataJsonObject() {
        JSONObject linkDataJson = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.channel)) {
                linkDataJson.put("~" + Defines.LinkParam.Channel.getKey(), (Object)this.channel);
            }
            if (!TextUtils.isEmpty((CharSequence)this.alias)) {
                linkDataJson.put("~" + Defines.LinkParam.Alias.getKey(), (Object)this.alias);
            }
            if (!TextUtils.isEmpty((CharSequence)this.feature)) {
                linkDataJson.put("~" + Defines.LinkParam.Feature.getKey(), (Object)this.feature);
            }
            if (!TextUtils.isEmpty((CharSequence)this.stage)) {
                linkDataJson.put("~" + Defines.LinkParam.Stage.getKey(), (Object)this.stage);
            }
            if (!TextUtils.isEmpty((CharSequence)this.campaign)) {
                linkDataJson.put("~" + Defines.LinkParam.Campaign.getKey(), (Object)this.campaign);
            }
            if (this.has(Defines.LinkParam.Tags.getKey())) {
                linkDataJson.put(Defines.LinkParam.Tags.getKey(), (Object)this.getJSONArray(Defines.LinkParam.Tags.getKey()));
            }
            linkDataJson.put("~" + Defines.LinkParam.Type.getKey(), this.type);
            linkDataJson.put("~" + Defines.LinkParam.Duration.getKey(), this.duration);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return linkDataJson;
    }
}

